/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.QPfAuthorize;
import com.gtis.portal.entity.QPfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PfMenuServiceImpl
implements PfMenuService {
    @Autowired
    BaseDao baseDao;
    @PersistenceContext
    EntityManager em;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public PfMenu getMenu(String menuId) {
        return (PfMenu)this.baseDao.getById(PfMenu.class, (Object)menuId);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateMenu(PfMenu menu) {
        this.baseDao.update((Object)menu);
    }

    public void addMenu(PfMenu menu) {
        this.baseDao.save((Object)menu);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void delMenu(PfMenu menu) {
        JPAQuery query = new JPAQuery(this.em);
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        List menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuParentId.eq((Object)menu.getMenuId())})).list((Expression)qPfMenu);
        if (menuList == null || menuList.size() == 0) {
            new JPADeleteClause(this.em, (EntityPath)qPfMenu).where(new Predicate[]{qPfMenu.menuId.eq((Object)menu.getMenuId())}).execute();
        } else {
            for (PfMenu menuVo : menuList) {
                this.delMenu(menuVo);
            }
        }
    }

    public Menu getMenusByRole(String roles) {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isBlank((String)roles)) {
            menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        } else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            Object[] roleList = roles.split(",");
            menuList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuId.in((Collection)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfAuthorize})).where(new Predicate[]{qPfAuthorize.authorizeObjType.eq((Object)"1"), qPfAuthorize.menuVisible.gt((Number)0), qPfAuthorize.undertakerId.in(roleList)})).distinct()).list((Expression)qPfAuthorize.authorizeObjId))})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        }
        LinkedHashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = PfMenuServiceImpl.toMenu((PfMenu)menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : ((HashMap)menuMap).values()) {
            if (menu.getPid() != null) {
                Menu pMenu = (Menu)((HashMap)menuMap).get(menu.getPid());
                if (pMenu == null) continue;
                pMenu.addChild(menu);
                continue;
            }
            root = menu;
        }
        return root;
    }

    private static Menu toMenu(PfMenu menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull((String)menuVo.getMenuParentId()));
        menu.setCls(menuVo.getMenuCss());
        menu.setExpanded(menuVo.isMenuExpanded());
        String rid = menuVo.getResourceId();
        if (rid != null) {
            menu.setLink("r:" + rid);
        }
        menu.setModel(menuVo.getMenuModel());
        return menu;
    }
}

