package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfStuffConfigService;
import com.gtis.portal.util.*;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * 任务办理中心
 */
@Controller
@RequestMapping("/taskHandle")
public class TaskHandleController extends BaseController {
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    PfStuffConfigService stuffConfigService;
    @Autowired
    PfResourceService resourceService;

    @RequestMapping("")
    public String taskHandle(Model model,@RequestParam(value = "taskid", required = false) String taskid,HttpServletRequest request) throws Exception {
        boolean  hasFinish=false;
        String fileTokenId= "";
        int fileCenterNodeId=0;
        boolean quickTurn=false;
        boolean canTrustTask=false;
        String defaultName="";
        String kcdjTypeConfig ="";
        String busiType ="";
        String readOnly ="";
        boolean hasDel=false;
        boolean canDelOthers=false;
        int menuCount=0;
        PfWorkFlowInstanceVo workFlowInstanceVo=null;
        List<Menu> menuList=null;
        String taskBackRemark="";
        boolean backState = false;
        if (StringUtils.isNotBlank(taskid)) {
            PfTaskVo taskVo = taskService.getTask(taskid);
            PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());

            // 菜单
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);

            //本段方法是为了获取是否第一次打开第一个节点的任务办理
            if (StringUtils.isBlank(activityVo.getActivityBefore()) && !taskVo.isAccepted()){
                //如果没有前一个节点，则表示是首节点，之后在判断是否是首次创建任务，也就是节点数据库数为1
                //判断是否是首节点，因为如果是首节点，就要考虑关闭时，是否提示是否保存该流程
                List<PfActivityVo> acList = taskService.getWorkflowInstanceActivityByTask(workFlowInstanceVo.getWorkflowIntanceId());
                if (acList != null && acList.size() == 1){
                    //直接创建工作流任务，不用弹出新建页面
                    String directCreateTask = xmlModel.getExtendedAttribute("DirectCreateTask")+"";
                    //获取流程创建时，是否提示“关闭时是否删除流程”
                    String createTaskAlertSave = "true";//xmlModel.getExtendedAttribute("CreateTaskAlertSave");

                    //只有当该流程是直接，而不弹出新建页面时，才进行处理，也就是直接弹出的待办任务，关闭窗口时，是否提示用户保存或者删除
                    if (StringUtils.equalsIgnoreCase("true",directCreateTask)){
                        model.addAttribute("createTaskAlertSave",createTaskAlertSave);
                    }
                }
            }

            taskService.updateTaskStadus(taskid);

            //是否退回过
            if(activityVo!=null && activityVo.isBackState()){
                String beforeTaskId = taskVo.getTaskBefore();
                PfTaskVo pfTaskVo=taskService.getHistoryTask(beforeTaskId);
                if(pfTaskVo!=null){
                    taskBackRemark = pfTaskVo.getRemark();
                }
                backState = true;
            }

            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF,true);

            try{
                Node node = nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), true);
                if (node!=null){
                    fileTokenId=nodeService.getToken(node);
                    fileCenterNodeId=node.getId();
                }
            }catch (Exception ex){

            }
            List<PfTaskVo> beforeTasks=taskService.getHistoryTaskByBefore(taskVo);
            if (beforeTasks == null){
                beforeTasks = new ArrayList<PfTaskVo>();
            }

            model.addAttribute("taskVo",taskVo);
            model.addAttribute("activityVo",activityVo);
            model.addAttribute("beforeTasks",beforeTasks);
            model.addAttribute("workFlowDefineVo",workFlowDefineVo);

            //由于部分业务是由收件单创建附件文件夹，并且收件单类型会根据一些参数生成不同而附件材料，
            // 因此该参数就是为了避免，每个工作流都自动创建附件文件夹，如果有表单辅助的，可以配置该选项
            String noCreateFile = xmlModel.getExtendedAttribute("NoAutoCreateFile");
            if (!StringUtils.equalsIgnoreCase("true",noCreateFile)){
                try{
                    //获得工作流定义中的附件类型，用于待办任务打开时，初始化待办任务的附件管理页面
                    CommonUtils.initWorkflowFileCenter(nodeService,stuffConfigService,workFlowInstanceVo.getWorkflowDefinitionId(),fileCenterNodeId);
                }catch (Exception ex){
                }
            }

            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            quickTurn = aModel.isQuickTurn();
            List<RiskModel> riskList = aModel.getRiskModelList();
            defaultName=aModel.getExtendedAttribute("DefaultName");

            if ("true".equals(aModel.getExtendedAttribute("CanEnTrustTask"))){
                canTrustTask=true;
            }

            //全局的显示委托按钮的配置
            String trustTaskEnable = AppConfig.getProperty("portal.handle.trust.task.enable");
            if (StringUtils.equalsIgnoreCase("true",trustTaskEnable)){
                canTrustTask=true;
            }
            //扩展属性中关于勘测定界管理模块的配置属性获取
            kcdjTypeConfig = aModel.getExtendedAttribute("KcdjTypeConfig")+"";
            if (StringUtils.isBlank(kcdjTypeConfig)) {
                kcdjTypeConfig = xmlModel.getExtendedAttribute("KcdjTypeConfig");
            }
            busiType = xmlModel.getExtendedAttribute("BusiType")+"";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlModel.getExtendedAttribute("busiType")+"";
            }

            //默认赋予文件中心可编辑权限，只有在工作流扩展属性中增加了“FileCenterReadOnly”属性，且赋值为“true”时，不可编辑
            readOnly = aModel.getExtendedAttribute("FileCenterReadOnly")+"";
            readOnly = readOnly.toLowerCase();
            if (!readOnly.equals("true")) {
                readOnly = "false";
            }
            org.dom4j.Node node = aModel.getResourcesNode();

            if (node!=null){
                List resList=node.selectNodes(".//Resource");
                menuCount = resList.size();
            }
             hasDel = permitDel(taskVo,request);

            if ("结束活动".equals(aModel.getActivityDescription())){
                hasFinish=true;
            }else{
                if (aModel.getDefineId().equals(xmlModel.getEndActivityDefine()) && aModel.getTransitionsList().size()==0){
                    hasFinish=true;
                }
            }

             canDelOthers= aModel.isCanDelOthers();
            //取办理菜单
            String menuXml=aModel.getResources();
            menuList = WorkFlowXmlUtil.getWorkFlowHandleMenu(menuXml,taskid,workFlowInstanceVo.getProId(),workFlowInstanceVo.getWorkflowIntanceId(),resourceService, Constants.HandType.TASK.getBm());
        }
        if(workFlowInstanceVo==null){
            workFlowInstanceVo=new PfWorkFlowInstanceVo();
        }
        if(menuList==null){
            menuList=new ArrayList<Menu>();
        }

        workFlowInstanceVo.setWorkflowIntanceName(CommonUtils.removeBlankLine(workFlowInstanceVo.getWorkflowIntanceName()));

        model.addAttribute("hasFinish",hasFinish);
        model.addAttribute("fileTokenId",fileTokenId);
        model.addAttribute("fileCenterNodeId",fileCenterNodeId);
        model.addAttribute("quickTurn",quickTurn);
        model.addAttribute("canTrustTask",canTrustTask);
        model.addAttribute("defaultName",defaultName);
        model.addAttribute("kcdjTypeConfig",kcdjTypeConfig);
        model.addAttribute("busiType",busiType);
        model.addAttribute("readOnly",readOnly);
        model.addAttribute("hasDel",hasDel);
        model.addAttribute("canDelOthers",canDelOthers);
        model.addAttribute("workFlowInstanceVo",workFlowInstanceVo);
        model.addAttribute("taskid",taskid);
        model.addAttribute("menuCount",menuCount);
        model.addAttribute("menuList",menuList);
//        System.out.println(JSON.toJSONString(menuList));
        model.addAttribute("bdcdjUrl", RequestUtils.initOptProperties(AppConfig.getProperty("bdcdj.url")));
        model.addAttribute("version", AppConfig.getProperty("portal.version"));
        model.addAttribute("taskBackRemark",taskBackRemark);
        model.addAttribute("taskBackState",backState);
        model.addAttribute("handType",Constants.HandType.TASK.getBm());
        String relWorkflowEnable = AppConfig.getProperty("portal.handle.rel.workflow.enable");
        if (StringUtils.equalsIgnoreCase("false",readOnly)){
            relWorkflowEnable = "true";
        }
        model.addAttribute("relWorkflowEnable", relWorkflowEnable);
        return "/task/handle/task-handle";
    }
    private boolean permitDel(PfTaskVo taskVo,HttpServletRequest request) {
        if (!SessionUtil.getUserInfo(request)
                .isAdmin()) {
            PfActivityVo activityVo = taskService.getActivity(taskVo
                    .getActivityId());
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService
                    .getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml workXml = WorkFlowXmlUtil
                    .getInstanceModel(workFlowInstanceVo);
            // WorkFlowXml workXml
            // =workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
            if (!workXml.getBeginActivityDefine().equals(
                    activityVo.getActivityDefinitionId())) {
                return false;
            }
        }
        return true;
    }

    @RequestMapping("modifyWf")
    @ResponseBody
    public Object modifyWf(HttpServletRequest req,@RequestParam(value = "proid", required = true)String proid,String workflowIntanceName) throws Exception{
        if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(workflowIntanceName)){
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(proid);
            if (workFlowInstanceVo != null){
                workFlowInstanceVo.setWorkflowIntanceName(java.net.URLDecoder.decode(workflowIntanceName,"UTF-8"));
                workFlowIntanceService.updateWorkFlowIntanceName(workFlowInstanceVo);
                return handlerSuccessJson();
            }
        }
        return handlerErrorJson();
    }

    /**
     * 获取到上个任务的办理意见
     * @param req
     * @param taskid
     * @return
     * @throws Exception
     */
    @RequestMapping("remark")
    @ResponseBody
    public Map<String, Object> remark(HttpServletRequest req,@RequestParam(value = "taskid", required = true)String taskid) throws Exception {
        String remark = "";
        if (StringUtils.isNotBlank(taskid)){
            PfTaskVo taskVo= taskService.getTask(taskid);
            if (taskVo!=null){
                String beforeTaskId = taskVo.getTaskBefore();
                if (StringUtils.isNotBlank(beforeTaskId)){
                    PfTaskVo beforeTaskVo = taskService.getHistoryTask(beforeTaskId);
                    if (beforeTaskVo != null && StringUtils.isNotBlank(beforeTaskVo.getRemark())) {
                        remark=beforeTaskVo.getRemark()+"("+beforeTaskVo.getUserVo().getUserName()+")";
                    }
                }
            }
        }
        Map<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "操作成功！");
        result.put("remark",remark);
        return result;
    }

    @RequestMapping("custom")
    public String customHandle(Model model,String taskid,HttpServletRequest request,String wdid,String proid) throws Exception {
        if (StringUtils.isBlank(proid)){
            proid = UUIDGenerator.generate18();
        }
        if (StringUtils.isNotBlank(wdid)) {
            int menuCount=0;
            PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(wdid);
            // 菜单
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
            ActivityModel aModel = xmlModel.getActivity(xmlModel.getBeginActivityDefine());
            org.dom4j.Node node = aModel.getResourcesNode();

            if (node!=null){
                List resList=node.selectNodes(".//Resource");
                menuCount = resList.size();
            }

            //取办理菜单
            String menuXml=aModel.getResources();
            List<Menu> menuList = WorkFlowXmlUtil.getWorkFlowHandleMenu(menuXml,taskid,proid,proid,resourceService, Constants.HandType.TASK.getBm());
            model.addAttribute("taskid",taskid);
            model.addAttribute("menuCount",menuCount);
            model.addAttribute("menuList",menuList);

            PfWorkFlowInstanceVo workFlowInstanceVo = new PfWorkFlowInstanceVo();
            workFlowInstanceVo.setProId(proid);
            workFlowInstanceVo.setWorkflowIntanceId(proid);
            workFlowInstanceVo.setWorkflowDefinitionId(wdid);
            model.addAttribute("workFlowInstanceVo",workFlowInstanceVo);
        }
        model.addAttribute("version", AppConfig.getProperty("portal.version"));
        model.addAttribute("handType",Constants.HandType.TASK.getBm());
        return "/task/handle/custom-handle";
    }

}
