package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.ResourceModel;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 任务办理中心
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/projectHandle")
public class ProjectHandleController {
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysMenuService menuService;


    @RequestMapping("")
    public String taskHandle(Model model,@RequestParam(value = "wiid", required = false) String wiid,@RequestParam(value = "proid", required = false) String proid,@RequestParam(value = "wdno", required = false) String wdno,HttpServletRequest request) throws Exception {
        String fileTokenId= "";
        int fileCenterNodeId=0;
        String defaultName="";
        String kcdjTypeConfig ="";
        String busiType ="";
        String wfName ="";
        String readOnly ="true";
        boolean disable=false;
        int menuCount=0;
        PfTaskVo taskVo=null;
        PfWorkFlowInstanceVo workFlowInstanceVo=null;
        PfWorkFlowDefineVo workFlowDefineVo=null;
        List<Menu> menuList=null;
        if (wiid != null && !wiid.equals("")) {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(wiid);
        } else {
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstanceByProId(proid);
        }
        if (workFlowInstanceVo!=null){
            workFlowDefineVo= workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
            wiid = workFlowInstanceVo.getWorkflowIntanceId();
        }else if(StringUtils.isNotBlank(wdno)){
            workFlowDefineVo= workFlowDefineService.getWorkFlowByDefinitionNo(wdno);
        }
        wfName =workFlowDefineVo.getWorkflowName();
        if (workFlowDefineVo!=null){
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
            disable = xmlDao.isDisable();
            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
            try {
                Node node=null;
                if (StringUtils.isBlank(wiid))
                    node = nodeService.getNode(space.getId(), proid, true);
                else
                    node = nodeService.getNode(space.getId(), wiid, false);
                if (node != null) {
                    fileTokenId = nodeService.getToken(node);
                    fileCenterNodeId = node.getId();
                }
            } catch (Exception ex) {

            }

            model.addAttribute("taskVo",taskVo);
            model.addAttribute("workFlowDefineVo",workFlowDefineVo);

            ////////////////////////////////////////////////////////////
            //扩展属性中关于勘测定界管理模块的配置属性获取
            kcdjTypeConfig = xmlDao.getExtendedAttribute("KcdjTypeConfig")+"";
            if (StringUtils.isBlank(kcdjTypeConfig)) {
                kcdjTypeConfig = xmlDao.getExtendedAttribute("KcdjTypeConfig");
            }
            busiType = xmlDao.getExtendedAttribute("BusiType")+"";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType")+"";
            }

            //取办理菜单
            String roles = SessionUtil.getUserInfo(request).getRoleIds();
            List<PfResourceVo> lstResult = menuService.getProjectMenu(roles,workFlowDefineVo.getWorkflowDefinitionId());
            List<PfActivityVo> activityVoList= taskService.getWorkFlowInstanceActivityList(wiid);
            int size=0;
            String showActivityName="";
            /**
             * 此处主要是存放已经插入的菜单，如果存在id和name相同的资源，则不再重复插入
             */
            HashMap<String, String> insertedMenuMap = new HashMap<String, String>();
            if (lstResult != null) {
                menuList=new ArrayList<Menu>();
                for (int i =0; i< lstResult.size(); i++) {
                    PfResourceVo menuVo = lstResult.get(i);
                    String tempKey = menuVo.getResourceId() + "_" + menuVo.getResourceName();
                    if (insertedMenuMap.get(tempKey) != null) {
                        //System.out.println(")^^^^^^^^^^^^^^^^menuVo="+menuVo.getResourceName());
                        continue;
                    }
                    insertedMenuMap.put(tempKey, tempKey);
                    Menu menu=new Menu();
                    menu.setId(menuVo.getResourceId());
                    String name=menuVo.getResourceName();
                    menu.setText(name);
                    //&__showtoolbar__=false
                    if(disable)
                        menu.setLink( "/SysResource.action?handleType="+Constants.HandType.PROJECT.getBm()+"&from=pro&disable=true&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId());
                    else
                        menu.setLink( "/SysResource.action?handleType="+Constants.HandType.PROJECT.getBm()+"&proid=" + workFlowInstanceVo.getProId() + "&wiid=" + wiid + "&rid=" + menuVo.getResourceId());
                        menuList.add(menu);
                }
            }
        }
        if (menuList == null || menuList.isEmpty()){
            menuList = getActivityMenu(wiid,workFlowInstanceVo,workFlowDefineVo);
        }

        if(workFlowInstanceVo==null){
            workFlowInstanceVo=new PfWorkFlowInstanceVo();
        }
        if(menuList==null){
            menuList=new ArrayList<Menu>();
        }

        workFlowInstanceVo.setWorkflowIntanceName(CommonUtils.removeBlankLine(workFlowInstanceVo.getWorkflowIntanceName()));
        model.addAttribute("fileTokenId",fileTokenId);
        model.addAttribute("fileCenterNodeId",fileCenterNodeId);
        model.addAttribute("defaultName",defaultName);
        model.addAttribute("kcdjTypeConfig",kcdjTypeConfig);
        model.addAttribute("busiType",busiType);
        model.addAttribute("readOnly",readOnly);
        model.addAttribute("workFlowInstanceVo",workFlowInstanceVo);
        model.addAttribute("menuCount",menuCount);
        model.addAttribute("menuList",menuList);
        model.addAttribute("handType",Constants.HandType.PROJECT.getBm());
        String relWorkflowEnable = AppConfig.getProperty("portal.handle.rel.workflow.enable");
        if (StringUtils.equalsIgnoreCase("false",readOnly)){
            relWorkflowEnable = "true";
        }
        model.addAttribute("relWorkflowEnable", relWorkflowEnable);
        return "/task/handle/task-projectHandle";
    }
    private boolean permitDel(PfTaskVo taskVo,HttpServletRequest request) {
        if (!SessionUtil.getUserInfo(request).isAdmin()) {
            PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            // WorkFlowXml workXml
            // =workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
            if (!workXml.getBeginActivityDefine().equals(
                    activityVo.getActivityDefinitionId())) {
                return false;
            }
        }
        return true;
    }

    /**
     * 获取节点menu
     * #项目管理中菜单的调用是否需要采用工作流定义的节点菜单，而非工作流实例菜单
     #如果配置为true，则无权限控制，仅仅是方便查看，减少配置
     #处理逻辑：优先当前活动菜单，其次办结节点，最后开始节点菜单
     * @return
     * @throws Exception
     */
    public List<Menu> getActivityMenu(String proid,PfWorkFlowInstanceVo workFlowInstanceVo,PfWorkFlowDefineVo workFlowDefineVo) {
        List<Menu> menuList=new ArrayList<Menu>();
        /*boolean acmenu = AppConfig.getBooleanProperty("workflow.project.handle.activity.menu",false);
        if (!acmenu){
            return menuList;
        }*/
        if (StringUtils.isNotBlank(proid) && workFlowInstanceVo != null) {
            try {
                ActivityModel aModel = null;
                WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
                WorkFlowXml xmlWDModel = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);

                String projectHandleMenu = xmlModel.getExtendedAttribute("ProjectHandleMenu")+"";
                if (StringUtils.isBlank(projectHandleMenu)){
                    projectHandleMenu = xmlWDModel.getExtendedAttribute("ProjectHandleMenu")+"";
                }

                if (StringUtils.equalsIgnoreCase(projectHandleMenu,"true")){
                    List<PfTaskVo> taskList = taskService.getTaskListByInstance(proid);
                    if (aModel == null && taskList != null && taskList.size() > 0){
                        PfTaskVo taskVo = taskList.get(0);
                        PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
                        aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
                    }
                }

                String projectHandleMenuLastActivity = xmlModel.getExtendedAttribute("ProjectHandleMenuLastActivity")+"";
                if (StringUtils.isBlank(projectHandleMenuLastActivity)){
                    projectHandleMenuLastActivity = xmlWDModel.getExtendedAttribute("ProjectHandleMenuLastActivity")+"";
                }
                if (StringUtils.equalsIgnoreCase(projectHandleMenuLastActivity,"true")){
                    String acdId = xmlModel.getEndActivityDefine();
                    aModel = xmlModel.getActivity(acdId);
                    if (!(aModel != null && aModel.getResourceList() != null && aModel.getResourceList().size() > 0)) {
                        acdId = xmlModel.getBeginActivityDefine();
                        aModel = xmlModel.getActivity(acdId);
                    }
                }

                if (aModel != null && aModel.getResources() != null){
                    menuList = WorkFlowXmlUtil.getWorkFlowHandleMenu(aModel.getResources(),null,workFlowInstanceVo.getProId(),workFlowInstanceVo.getWorkflowIntanceId(),resourceService, Constants.HandType.PROJECT.getBm());
                }
            }catch (Exception ex){

            }
        }
        return menuList;
    }

}
