package com.jsegov.tag.sign;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;

public class SignServlet extends HttpServlet {

    private static final long serialVersionUID = -8500804963122596444L;

    private static final String CONTENT_TYPE = "text/html; charset=utf-8";

    public SignServlet() {
        super();
    }

    public void destroy() {
        super.destroy(); // Just puts "destroy" string in log
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String empId = "", signkey = "", proid = "", sql = "", type = "0", userName = "";
        String content = "";
        boolean isAuto = false;
        PreparedStatement pst = null;
        // 删除签名
        // 保存自动签名
        // 保存手动签名
        SAXReader reader = new SAXReader();
        Connection conn = null;
        try {
            conn = ((DataSource) Container.getBean("egov")).getConnection();
            org.dom4j.Document document = reader.read(request.getInputStream());
            signkey = getNodeAttr(document, "//signdata", "signkey");
            proid = getNodeAttr(document, "//signdata", "proid");
            empId = SessionUtil.getUserId(request);
            System.out.println("==================empId=" + empId);
            userName = getUserName(empId);
            System.out.println("==================userName=" + userName);
            content = getNodeAttr(document, "//signdata", "content");
            String signId = getsignId(conn, proid, signkey, empId);
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String strDate = sdf.format(cal.getTime());
            if (document.selectNodes("//signdata[@autopic='true']").size() > 0) {// 保存自动签名
                isAuto = true;// 保存自动签名
                type = "1";
            }
            Node node = document.selectSingleNode("signdata");
            String pnts = node.getText().trim();
            if (!isAuto && pnts.equals("")) {// 删除签名
                if (!signId.equals("")) {
                    sql = "delete from PF_USERSIGN where SIGN_ID='" + signId + "'";
                    pst = conn.prepareStatement(sql);
                    pst.executeUpdate();
                    signId = "";
                }
            } else { // 保存签名
                if (signId.equals("")) {
                    sql = "insert into PF_USERSIGN (SIGN_ID,PRO_ID,SIGN_KEY,SIGN_NAME,SIGN_DATE,SIGN_TYPE,USER_ID,SIGN_PIC)";
                    sql = sql + " values (?,?,?,?,to_date(?,'yyyy-mm-dd hh24:mi:ss'),?,?,Empty_BLOB())";
                    pst = conn.prepareStatement(sql);
                    signId = UUIDGenerator.generate();
                    pst.setString(1, signId);
                    pst.setString(2, proid);
                    pst.setString(3, signkey);
                    pst.setString(4, userName);
                    pst.setString(5, strDate);
                    //pst.setDate(5, dd);
                    pst.setString(6, type);
                    pst.setString(7, empId);
                    //pst.setString(8, content);
                } else {
                    sql = "update PF_USERSIGN set SIGN_NAME=?,SIGN_DATE=to_date(?,'yyyy-mm-dd hh24:mi:ss'),SIGN_TYPE=?,USER_ID=?,SIGN_PIC=Empty_BLOB()";
                    sql = sql + " where SIGN_ID='" + signId + "'";
                    pst = conn.prepareStatement(sql);
                    pst.setString(1, userName);
                    pst.setString(2, strDate);
                    pst.setString(3, type);
                    pst.setString(4, empId);
                    //pst.setString(5, content);
                }
                pst.executeUpdate();
            }

            if (!isAuto) {// 保存手动签名
                UpdateSignPic(conn, document, signId);
            } else { // 保存自动签名
                UpdateSignPicFromSz(conn, empId, signId);
            }
            System.out.println("signId" + signId);
            WriteResponse(request, response, signId + "|" + userName + "|" + strDate + "|" + content);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            try {
                conn.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    private String getUserName(String empId) {
        String userName = "测试人员";
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = ((DataSource) Container.getBean("egov")).getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select USER_NAME from PF_USER where USER_ID='" + empId + "' ");
            if (rs.next()) {
                userName = rs.getString("USER_NAME");
            }
        } catch (Exception e) {
            System.out.println("未获取到人员信息！");
        } finally {
            try {
                conn.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return userName;
    }

    @SuppressWarnings("deprecation")
    private void UpdateSignPicFromSz(Connection conn, String empId, String SIGN_ID) {
        // 获取数据库操作语句
        if (empId.equals("") || empId.equals("-1"))
            return;
        Statement stmt = null;
        ResultSet rs = null;
        Statement stmtsz = null;
        ResultSet rssz = null;
        Connection connsz = null;
        try {
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            connsz = ((DataSource) Container.getBean("egov")).getConnection();
            stmtsz = connsz.createStatement();
            rssz = stmtsz.executeQuery("select * from PF_USER  where USER_ID='" + empId + "' ");
            if (rssz.next()) {
                rs = stmt.executeQuery("select SIGN_PIC from PF_USERSIGN where SIGN_ID='" + SIGN_ID + "' FOR UPDATE");

                if (rs.next()) {
                    /* 取出此BLOB对象 */
                    oracle.sql.BLOB blob = (oracle.sql.BLOB) rs.getBlob("SIGN_PIC");
                    /* 向BLOB对象中写入数据 */
                    BufferedOutputStream out = new BufferedOutputStream(blob.getBinaryOutputStream());
                    InputStream is = rssz.getBinaryStream("USER_SIGN");
                    if (is != null) {
                        try {
                            byte[] buff = new byte[2048];
                            int bytesRead;
                            while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                                out.write(buff, 0, bytesRead);
                            }

                            out.close();
                        } finally {
                            is.close();
                        }
                    }
                }
                conn.setAutoCommit(false);
                conn.commit();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                rs.close();
                rssz.close();
                stmt.close();
                connsz.close();
                stmtsz.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

    @SuppressWarnings("deprecation")
    private void UpdateSignPic(Connection conn, Document document, String SIGN_ID) {
        // 获取数据库操作语句
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            Node node = document.selectSingleNode("signdata");
            if (node != null) {
                BufferedImage bufferImg = drawPic(node.getText());
                rs = stmt.executeQuery("select SIGN_PIC from PF_USERSIGN where SIGN_ID='" + SIGN_ID + "' FOR UPDATE");

                if (rs.next()) {
                    /* 取出此BLOB对象 */
                    oracle.sql.BLOB blob = (oracle.sql.BLOB) rs.getBlob("SIGN_PIC");
                    /* 向BLOB对象中写入数据 */
                    BufferedOutputStream out = new BufferedOutputStream(blob.getBinaryOutputStream());
                    ImageIO.write(bufferImg, "jpg", out);
                    out.close();
                }
                conn.setAutoCommit(false);
                conn.commit();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                rs.close();
                stmt.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

    }

    private String getsignId(Connection conn, String proId, String signKey, String empid) {
        String signId = "";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select SIGN_ID from PF_USERSIGN where " + " SIGN_KEY='" + signKey + "' and PRO_ID='" + proId + "' and USER_ID='" + empid + "'");
            if (rs.next()) {
                signId = rs.getString("SIGN_ID");
            }
        } catch (Exception e) {
        } finally {
            try {
                rs.close();
                stmt.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return signId;
    }

    private String getNodeAttr(Document document, String path, String attrName) {
        String attrValue = "";
        Node node = document.selectSingleNode(path);
        if (node != null) {
            attrValue = node.valueOf("@" + attrName);
        }
        return attrValue;
    }

    private void WriteResponse(HttpServletRequest request, HttpServletResponse response, String value) throws IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        out.println(value);
        out.close();
    }

    /**
     * The doPost method of the servlet. <br>
     * <p/>
     * This method is called when a form has its tag value method equals to
     * post.
     *
     * @param request  the request send by the client to the server
     * @param response the response send by the server to the client
     * @throws ServletException if an error occurred
     * @throws IOException      if an error occurred
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        doGet(request, response);
    }

    /**
     * Initialization of the servlet. <br>
     *
     * @throws ServletException if an error occure
     */
    public void init() throws ServletException {
        // Put your code here
    }

    /**
     * 根据点的字符串信息生成图片
     *
     * @param strPoint
     * @return
     */
    @SuppressWarnings("unchecked")
    private BufferedImage drawPic(String strPoint) {
        boolean flage = true;
        Graphics2D graphic = null;
        BufferedImage bfimg = new BufferedImage(400, 160, BufferedImage.TYPE_INT_RGB);
        BasicStroke bs = new BasicStroke((float) 10.0);

        graphic = bfimg.createGraphics();
        graphic.setStroke(bs);
        graphic.setColor(new Color(255, 255, 255));
        graphic.fillRect(0, 0, 400, 160);
        int[] xPoints = new int[10000];
        int[] yPoints = new int[10000];
        int nPoints = 0, vNum = 0;
        int i = 0, j = 0, k = 0;
        Vector vctline = new Vector();
        String strline;
        strPoint = "|" + strPoint;
        for (i = 0; i < strPoint.length(); i++) {
            String line = new String();
            if (strPoint.charAt(i) != '|') {
                j = i + 1;
                k = 0;
                while (j < strPoint.length() && strPoint.charAt(j) != '|') {
                    line = line + strPoint.charAt(j);
                    j++;
                    k++;
                }
                i = i + k;
                k = 0;
                vctline.add(vNum++, line);
            }
        }
        k = 0;
        for (i = 0; i < vctline.size(); i++) {
            strline = vctline.get(i).toString();
            String strfig = "";
            int p = 0;
            for (j = 0; j < strline.length(); j++) {
                if (strline.charAt(j) == ',') {
                    p = j - 1;
                    strfig = "";
                    while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                        strfig = strline.charAt(p) + strfig;
                        p--;
                        if (p < 0) {
                            p = 0;
                            flage = false;
                        }
                    }
                    flage = true;
                    xPoints[k] = Integer.parseInt(strfig);
                    p = j + 1;
                    strfig = "";
                    while (flage && strline.charAt(p) >= '0' && strline.charAt(j) <= '9') {
                        strfig = strfig + strline.charAt(p);
                        p++;
                        if (p >= strline.length()) {
                            p = 0;
                            flage = false;
                        }
                    }
                    flage = true;
                    yPoints[k] = Integer.parseInt(strfig);
                    k++;
                    nPoints = k;
                }
            }
            k = 0;
            if (nPoints > 0) {
                graphic.setColor(new Color(0, 0, 0));
                graphic.drawPolyline(xPoints, yPoints, nPoints);
                nPoints = 0;
            }
        }
        graphic.setColor(new Color(0, 0, 0));
        graphic.drawPolyline(xPoints, yPoints, nPoints);
        return bfimg;
    }
}
