package com.gtis.web.old;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FormDefintion {
	
	private String dfId="";  //定义表主键
	Document xlstDoc = null;
	Document xmlDoc = null;
	Document xmlShell=null;
	public FormDefintion(Document xlstDoc,Document xmlDoc,Document xmlShell,String dFId){
		this.xlstDoc=xlstDoc;
		this.xmlDoc=xmlDoc;
		this.dfId=dFId;
		this.xmlShell=xmlShell;
	}

	/**
	 * 从表单定义中获取xlst的Document
	 * 
	 * @param dFId
	 * @return
	 */
	public Document getXLSTDocument() {
		return this.xlstDoc;
	}
	
	/**
	 * 从表单定义中获取xml的Document
	 * 
	 * @param dIId
	 * @return
	 */
	public Document getXMLDocument() {
		return this.xmlDoc;
		
	}
	
	public Document getDocumentShell(){
		return this.xmlShell;
	}
	/**
	 * 根据定义xml返回空白xml实例
	 * @return Document
	 */
	public Document getBlackXML(){
		Document bDoc=null;
		bDoc=DocumentHelper.createDocument();
		Document docForm=getXMLDocument();
		Element root = bDoc.addElement("DataSet");
		Element dataSetElement=docForm.getRootElement();
		//加入样式单
		root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		root.addAttribute("xsi:noNamespaceSchemaLocation", "http://www.oracle.com/DForms.xsd");
		//加入属性
		for(int i=0;i<dataSetElement.attributeCount();i++){
			root.addAttribute(dataSetElement.attribute(i).getName(),dataSetElement.attribute(i).getText());
		}
		//根据ElementDefine生成空白数据
		List lstDefine=dataSetElement.selectNodes("/DataSet/Define/ElementDefine");
		for (int i = 0; i < lstDefine.size(); i++) {
			Element defineElement=(Element)lstDefine.get(i);
			Element dataElement = root.addElement("ElementData");
			dataElement.addAttribute("Id", defineElement.attributeValue("Id"));
		}
		return bDoc;
	}
	

	public String getDfId() {
		return dfId;
	}

	public void setDfId(String dfId) {
		this.dfId = dfId;
	}
}
