package com.gtis.web.action.sjd;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONUtil;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.*;
import com.gtis.plat.form.print.XMLBuildHelper;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.util.SjdUtil;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;

/**
 * @文件名 SjdManageAction.java
 * @作者 卢向伟
 * @创建日期 2013-2-21
 * @创建时间 下午2:50:50 
 * @版本号 V 1.0
 */
public class SjdManageAction implements ServletRequestAware, ServletResponseAware{
	private Logger logger = Logger.getLogger(this.getClass().getName());
	private HttpServletRequest request;
	private HttpServletResponse response;
	private BaseDao sjdDaoImpl;
	private String sjdid;
	private String data_id;
	private SjdVo sjdVo;
	private SjdclVo sjdclVo;
	private String result;
	private String message;
	private SplitParam splitParam;
	private String ids;
	private String state;//页面打开的方式（新增、编辑）
	private String proid;
	private List<SjdclVo> sjdclList;
	private String[] data_idArr;
	private Integer[] xhArr;
	private String[] nameArr;
	private Integer[] numArr;
	private Integer[] ysnumArr;
	private Integer[] dbnumArr;
	private String[] bzArr;
	
	private SysWorkFlowDefineService workFlowDefineService;
	private SysWorkFlowInstanceService sysWorkFlowInstanceService;
	
	private static final String spacecode = "WORK_FLOW_STUFF";
	private int nodeId;
	private String token;
	private NodeService nodeService;
	private String filename;
	private List<String> listID;
	//前后台交互
	private String paramString;
	private String configId;
	private String configName;
	
	
	public String execute()throws Exception{
		openSjdInput();
		return "sjdInput";
	}
	/**
	 * 打开收件单页面
	 * @return
	 * @throws Exception
	 */
	public String openSjdInput()throws Exception{
		message = "";
		if (StringUtils.isBlank(proid)) {
			proid = UUIDGenerator.generate();
		}
		PfWorkFlowInstanceVo workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
		if (workFlowInstanceVo != null && StringUtils.isNotBlank(workFlowInstanceVo.getWorkflowDefinitionId())) {
			configId = workFlowInstanceVo.getWorkflowDefinitionId();
			PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(configId);
			configName = workFlowDefineVo.getWorkflowName();
		}
		if (StringUtils.isBlank(configId)) {
			configId = "custom";
		}
		sjdVo=sjdDaoImpl.getObject(proid,"PROID");
		createFileCenterNode(proid,spacecode);
		if (sjdVo == null) {
			sjdVo = new SjdVo();
			sjdVo.setProid(proid);
			sjdVo.setSjdid(UUIDGenerator.generate());
			sjdVo.setSjd_sj_date(CommonUtil.getCurrDate());
			sjdVo.setSjd_sjr(SessionUtil.getUserName(request));
			sjdVo.setBusiType(configId);
			sjdVo.setSjd_sqlx(configName);
			
			sjdVo.setSjd_bh_year(Integer.parseInt(CommonUtil.getCurrYear()));
			HashMap param = new HashMap();
			if (StringUtils.isNotBlank(configName)) {
				param.put("SJD_SQLX",configName);
			}
			param.put("SJD_BH_YEAR",sjdVo.getSjd_bh_year());
			Integer bh_xh = sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
			if (bh_xh == null) {
				bh_xh = 0;
			}
			sjdVo.setSjd_bh_xh(bh_xh+1);
			DecimalFormat decimalFormat = new DecimalFormat("0000");
			String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
			String bh ="（"+sjdVo.getSjd_bh_year()+"）第"+lsh+"号";
			sjdVo.setSjd_bh(bh.replaceAll("null", ""));
			sjdDaoImpl.insertObject(sjdVo);
		}
		if (sjdVo.getSjd_bh_year() == null || sjdVo.getSjd_bh_year() < 1) {
			sjdVo.setSjd_bh_year(Integer.parseInt(CommonUtil.getCurrYear()));
		}
		if (sjdVo.getSjd_bh_xh() == null || sjdVo.getSjd_bh_xh() < 1) {
			HashMap param = new HashMap();
			if (StringUtils.isNotBlank(configName)) {
				param.put("SJD_SQLX",configName);
			}
			param.put("SJD_BH_YEAR",sjdVo.getSjd_bh_year());
			Integer bh_xh = sjdDaoImpl.getObjectByIbatisStr(param, "getMaxSjdXh");
			if (bh_xh == null) {
				bh_xh = 0;
			}
			sjdVo.setSjd_bh_xh(bh_xh+1);
		}
		if (StringUtils.isBlank(sjdVo.getSjd_bh()) || sjdVo.getSjd_bh().length() <= 12) {
			DecimalFormat decimalFormat = new DecimalFormat("0000");
			String lsh = decimalFormat.format(sjdVo.getSjd_bh_xh());
			String bh ="（"+sjdVo.getSjd_bh_year()+"）第"+lsh+"号";
			sjdVo.setSjd_bh(bh.replaceAll("null", ""));
		}
		if (sjdVo.getSjd_cnqx() == null || sjdVo.getSjd_cnqx() < 0) {
			sjdVo.setSjd_cnqx(workFlowInstanceVo.getTimeLimit());
		}
		
		sjdclList = SjdUtil.getSjdclListBySjdVo(sjdVo);
		if (sjdclList == null || sjdclList.size() == 0) {
			sjdclList = this.initDefaultFile(sjdVo, nodeId,configId,sjdclList);
		}
		Collections.sort(sjdclList);
		SjdclVo clVo = new SjdclVo();
		clVo.setProid(sjdVo.getProid());
		clVo.setSjdid(sjdVo.getSjdid());
		clVo.setData_id("demo");
		sjdclList.add(clVo);
		return "sjdInput";
	}
	/**
	 * 保存资料收据页面
	 * @return
	 * @throws Exception
	 */
	public String saveSjdInput() throws Exception{
		sjdclList = new ArrayList<SjdclVo>();
		if(StringUtils.isNotBlank(sjdVo.getSjdid())){
			if(data_idArr != null && data_idArr.length > 0){
				for (int i = 0; i < nameArr.length; i++) {
					String nameA = nameArr[i]+"";
					for (int j = i+1; j < nameArr.length; j++) {
						String nameB = nameArr[j]+"";
						if(nameA.equals(nameB)){
							message = "文件资料名称不能重复！";
							result = "false";
							return "sjdInput";
						}
					}
				}
				createFileCenterNode(sjdVo.getProid(),spacecode);
				for (int i = 0; i < data_idArr.length; i++) {
					try {
						if (xhArr[i] == null && StringUtils.isBlank(nameArr[i]) && ysnumArr[i] == null && dbnumArr[i] == null && StringUtils.isBlank(bzArr[i])) {
							continue;
						}else {
							SjdclVo vo = new SjdclVo();
							if (data_idArr[i] != null && data_idArr[i].equals("demo")) {
								vo.setData_id(UUIDGenerator.generate());
							} else {
								vo.setData_id(data_idArr[i]);
							}
							vo.setProid(sjdVo.getProid());
							vo.setSjdid(sjdVo.getSjdid());
							vo.setXh(xhArr[i]);
							vo.setName(nameArr[i]);
							vo.setNum(numArr[i]);
							vo.setYsnum(ysnumArr[i]);
							vo.setDbnum(dbnumArr[i]);
							vo.setBz(bzArr[i]);
							Node nodeChild = getOrCreateNode(nodeId, vo.getName());
							vo.setNode_id(nodeChild.getId());
							sjdclList.add(vo);
						}
					} catch (Exception e) {
						logger.error(e.getMessage());
					}
				}
			}
			try {
				if (sjdclList != null) {
	    			String clJson = JSONUtil.serialize(sjdclList);
	    			sjdVo.setSjd_cl(clJson.getBytes());
	    		}
				sjdDaoImpl.updateObject(sjdVo);
				message = "操作成功";
	            result = "true";
			} catch (Exception e) {
				message="操作失败";
				result="false";
				logger.error(e.getMessage());
			}
		}
		Collections.sort(sjdclList);
		SjdclVo clVo = new SjdclVo();
		clVo.setProid(sjdVo.getProid());
		clVo.setSjdid(sjdVo.getSjdid());
		clVo.setData_id("demo");
		sjdclList.add(clVo);
		return "sjdInput";
	}
	/**
	 * 删除资料信息
	 * @return
	 * @throws Exception
	 */
	public String deleteSjdclInput() throws Exception{
		HashMap<String, String> returnMap = new HashMap<String, String>();
		if(StringUtils.isNotBlank(ids) && StringUtils.isNotBlank(proid)){
			String idParam = java.net.URLDecoder.decode(ids,"utf-8");
			//根据ID获取对应的材料名称集合
			List<String> nameList = new ArrayList<String>();
			sjdVo=sjdDaoImpl.getObject(proid,"PROID");
			if (sjdVo != null && sjdVo.getSjd_cl() != null) {
//				String json = new String(sjdVo.getSjd_cl());
//				List<SjdclVo> clList = JSON.parseArray(json,SjdclVo.class);
				List<SjdclVo> clList = SjdUtil.getSjdclListBySjdVo(sjdVo);
				List<SjdclVo> hasClList = new ArrayList<SjdclVo>();
				if (clList != null && clList.size() > 0) {
					for (int i = 0; i < clList.size(); i++) {
						String id = clList.get(i).getData_id();
						if (idParam.indexOf(id) > -1 && StringUtils.isNotBlank(clList.get(i).getName())) {
							nameList.add(clList.get(i).getName());
						}else {
							hasClList.add(clList.get(i));
						}
					}
				}
				String clJson = JSONUtil.serialize(hasClList);
    			sjdVo.setSjd_cl(clJson.getBytes());
    			sjdDaoImpl.updateObject(sjdVo);
			}
			//根据名称删除对应的文件中心记录
			for (int i = 0; i < nameList.size(); i++) {
				try {
					Space space = nodeService.getWorkSpace(spacecode, true);
				    Node prjNode = nodeService.getNode(space.getId(), proid, true);
				    Node child = nodeService.getChildNode(prjNode.getId(), nameList.get(i));
					nodeService.remove(child.getId());
					message = "操作成功";
		            result = "true";
				} catch (Exception e) {
					message = "文件中心删除异常";
					result="false";
				}
			}
		}
		returnMap.put("result", result);
		returnMap.put("msg", message);
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(returnMap));
		return "none";
	}
	
	public String goPrint()throws Exception{
		StringBuilder xml = new StringBuilder();
		xml.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>\n");
		xml.append("<fetchdatas>\n");
		xml.append("<datas>\n");
		XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
		if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(sjdid)) {
			SjdVo sjdVo = new SjdVo();
			List<SjdclVo> dataList = new ArrayList<SjdclVo>();
			if (StringUtils.isNotBlank(sjdid)) {
				sjdVo=sjdDaoImpl.getObject(sjdid);
				if (sjdVo == null) {
					sjdVo = new SjdVo();
					sjdVo.setProid(proid);
					sjdVo.setSjdid(sjdid);
				}
			}
			xml.append(xmlBuildHelper.voToXml(sjdVo));
			xml.append("</datas>\n");
			
			dataList = SjdUtil.getSjdclListBySjdVo(sjdVo);
			if(dataList==null||dataList.size()==0){
				dataList =new ArrayList<SjdclVo>();
				SjdclVo tempVo = new SjdclVo();
				dataList.add(tempVo);
			}
			//记录总数
			xml.append("<detail ID=\"SJDCL\">\n");
			xml.append(xmlBuildHelper.voListToXml(dataList));
			xml.append("</detail>\n");
		}
		if(xml.indexOf("</datas>")==-1) {
			xml.append("</datas>\n");
		}
		
		xml.append("</fetchdatas>");
		String res=xml.toString();
		response.setContentType("text/xml; charset=GBK");
		PrintWriter out = response.getWriter();
		out.write(res);
		out.flush();
		out.close();
		System.out.println(res);
		return "none";
	}

	/**
	 * 创建文件中心节点
	 * @param fileId 主键id
	 * @param spacecode 工作空间
	 * @return 返回nodeId和token
	 * @throws Exception
	 */
	private void createFileCenterNode(String fileId,String spacecode) throws Exception{
		Space space = null;
		try {
			space = nodeService.getWorkSpace(spacecode, true);
			Node prjNode = nodeService.getNode(space.getId(), fileId, true);
			nodeId=prjNode.getId();
			token=nodeService.getToken(prjNode);
		} catch (Exception e) {
			System.out.println("文件中心异常："+e.getMessage());
		}
	}
	
	 /**
     * 批量上传及补拍
     * @param proid
     * @return json returnMap
     */
    public String uploadInfo(){
		try {
			if (StringUtils.isNotBlank(proid)) {
		        Space space = null;
		        space = nodeService.getWorkSpace(spacecode,true);
		        Node node = nodeService.getNode(space.getId(), proid,true);
				token = nodeService.getToken(node);
				HashMap<String, String> returnMap = new HashMap<String, String>();
				returnMap.put("token", token);
				String fileId = "";
				if (StringUtils.isNotBlank(filename)) {
					Node nodeChild = getOrCreateNode(node.getId(), filename);
					fileId = nodeChild.getId().toString();
				}else{
					fileId = node.getId().toString();
				}
				returnMap.put("fileId", fileId);
				String fileCenterUrl = AppConfig.getProperty("fileCenter.url");
				if (StringUtils.isNotBlank(fileCenterUrl) && fileCenterUrl.length()>4){
					returnMap.put("fileCenterUrl", fileCenterUrl.substring(4));
				}
				ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(returnMap));
			}			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "none";
	}
    /**
	 * 信息预览
	 * @return
	 * @throws Exception
	 */
    public String previewPic() throws Exception{
    	listID = new ArrayList<String>();
    	if(proid!=null && !proid.equals("") && filename!=null && !filename.equals("")){
    		 Space space = null;
	         space = nodeService.getWorkSpace(spacecode,true);
	         Node node = nodeService.getNode(space.getId(), proid,true);
	         Node child = nodeService.getChildNode(node.getId(), filename);
	         List<Node> list = nodeService.getAllChildNodes(child.getId());
	         for(Node tdnode:list){
	        	listID.add(tdnode.getId().toString()); 
	         }
    	}
    	return "preview";
    }
    /**
	 * 删除信息
	 * @return
	 * @throws Exception
	 */
    public String delFile() throws Exception{
		if(ids != null && !ids.equals("")){
			nodeService.remove(Integer.valueOf(ids));
		}
		return null;
	}
    /**
     * 初始化默认文件列表
     * @param vo
     * @param nid
     * @param bType
     */
    private List<SjdclVo> initDefaultFile(SjdVo vo,int nid,String wdid,List<SjdclVo> clList){
    	try {
    		if (clList == null) {
    			clList = new ArrayList<SjdclVo>();
			}
    		HashMap param = new HashMap();
    		param.put("WORKFLOW_DEFINITION_ID", wdid);
    		List<StuffConfigVo> zdbList = sjdDaoImpl.getObjectListByIbatisStr(param, "get_PF_STUFF_CONFIG");
    		if(zdbList != null && zdbList.size() > 0){
    			System.out.println("初始化收件单材料字典数据......");
    			for (int i = 0; i < zdbList.size(); i++) {
    				StuffConfigVo configVo = zdbList.get(i);
    				SjdclVo clVo = new SjdclVo();
    				clVo.setData_id(UUIDGenerator.generate());
    				clVo.setProid(vo.getProid());
    				clVo.setSjdid(vo.getSjdid());
    				clVo.setName(configVo.getStuffName());
    				clVo.setXh(configVo.getStuffXh());
    				clVo.setBz(configVo.getRemark());
    				clVo.setType(configVo.getMeterial());
    				
    				if (configVo.getStuffCount() != null && configVo.getStuffCount() > 0) {
    					clVo.setNum(configVo.getStuffCount());
    					if (configVo.getYsnum() == null) {
    						configVo.setYsnum(configVo.getStuffCount());
    					}
    					clVo.setYsnum(configVo.getYsnum());
    					clVo.setDbnum(clVo.getNum()-clVo.getYsnum());
					}
    				
    				//每一个材料创建之后，创建对应的文件中心id
    				Node nodeChild = getOrCreateNode(nid,clVo.getName());
    				clVo.setNode_id(nodeChild.getId());
    				clList.add(i,clVo);
    			}
    			System.out.println("初始化收件单材料字典数据完成！");
    		}
    		//将初始化好的材料列表存储到材料字段中
    		if (clList != null) {
    			String clJson = JSONUtil.serialize(clList);
    			vo.setSjd_cl(clJson.getBytes());
    			sjdDaoImpl.updateObjectByIbatisStr(vo,"update_PF_SJD_CL");
    		}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return clList;
    }
	/**
	 * 根据父节点nodeid生成名称为fName的子文件节点
	 * @param nid
	 * @param fName
	 * @return
	 */
	private Node getOrCreateNode(Integer nid,String fName){
		Node nodeChild = null;
		try {
			nodeChild = nodeService.getNode(nid, fName, true);//getChildNode(nid, fName);
		} catch (Exception e) {
			nodeChild = nodeService.createNode(nid,fName);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		if (nodeChild == null) {
			nodeChild = nodeService.getNode(nid,fName, true);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		return nodeChild;
	}
	
	public void setServletRequest(HttpServletRequest arg0) {
		this.request = arg0;
	}

	public void setServletResponse(HttpServletResponse arg0) {
		this.response = arg0;
	}
	public String getData_id() {
		return data_id;
	}

	public void setData_id(String data_id) {
		this.data_id = data_id;
	}

	public SjdclVo getSjdclVo() {
		return sjdclVo;
	}

	public void setSjdclVo(SjdclVo sjdclVo) {
		this.sjdclVo = sjdclVo;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getIds() {
		return ids;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}
	public String getProid() {
		return proid;
	}
	public void setProid(String proid) {
		this.proid = proid;
	}
	public int getNodeId() {
		return nodeId;
	}
	public void setNodeId(int nodeId) {
		this.nodeId = nodeId;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public String getFilename() {
		return filename;
	}
	public void setFilename(String filename) {
		this.filename = filename;
	}
	public List<String> getListID() {
		return listID;
	}
	public void setListID(List<String> listID) {
		this.listID = listID;
	}
	public String getSjdid() {
		return sjdid;
	}
	public void setSjdid(String sjdid) {
		this.sjdid = sjdid;
	}
	public SjdVo getSjdVo() {
		return sjdVo;
	}
	public void setSjdVo(SjdVo sjdVo) {
		this.sjdVo = sjdVo;
	}
	public NodeService getNodeService() {
		return nodeService;
	}
	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}
	public List<SjdclVo> getSjdclList() {
		return sjdclList;
	}
	public void setSjdclList(List<SjdclVo> sjdclList) {
		this.sjdclList = sjdclList;
	}
	public String[] getData_idArr() {
		return data_idArr;
	}
	public void setData_idArr(String[] data_idArr) {
		this.data_idArr = data_idArr;
	}
	public Integer[] getXhArr() {
		return xhArr;
	}
	public void setXhArr(Integer[] xhArr) {
		this.xhArr = xhArr;
	}
	public String[] getNameArr() {
		return nameArr;
	}
	public void setNameArr(String[] nameArr) {
		this.nameArr = nameArr;
	}
	public Integer[] getNumArr() {
		return numArr;
	}
	public void setNumArr(Integer[] numArr) {
		this.numArr = numArr;
	}
	public Integer[] getYsnumArr() {
		return ysnumArr;
	}
	public void setYsnumArr(Integer[] ysnumArr) {
		this.ysnumArr = ysnumArr;
	}
	public Integer[] getDbnumArr() {
		return dbnumArr;
	}
	public void setDbnumArr(Integer[] dbnumArr) {
		this.dbnumArr = dbnumArr;
	}
	public String[] getBzArr() {
		return bzArr;
	}
	public void setBzArr(String[] bzArr) {
		this.bzArr = bzArr;
	}
	public String getParamString() {
		return paramString;
	}
	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}
	public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}
	public SysWorkFlowInstanceService getSysWorkFlowInstanceService() {
		return sysWorkFlowInstanceService;
	}
	public void setSysWorkFlowInstanceService(SysWorkFlowInstanceService sysWorkFlowInstanceService) {
		this.sysWorkFlowInstanceService = sysWorkFlowInstanceService;
	}
	public BaseDao getSjdDaoImpl() {
		return sjdDaoImpl;
	}
	public void setSjdDaoImpl(BaseDao sjdDaoImpl) {
		this.sjdDaoImpl = sjdDaoImpl;
	}
}