package com.gtis.web.action.dform;

import com.gtis.plat.datasource.BusinessDataSource;
import com.opensymphony.xwork2.Action;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:jibo1024@gmail.com">boji</a>
 * @version V1.0, ${Date}
 */
public class FormDataAction {
    private List rows; // 记录
    private int totalCount; // 记录总数
    private int totalPages=0; // 总页数
    private int pageSize=0; // 页大小
    private int pageIndex=1; //当前页
    private String sql;


    public String execute() throws Exception {
        JdbcTemplate jt = new JdbcTemplate();

        //DataSource ds = BusinessDataSource.getDataSourceByBusiness(formInstance.getBusinessVo());
        String sqlCountRows = getCountSQL(sql);
        totalCount = jt.queryForInt(sqlCountRows);
        if (pageSize>0){
            totalPages=   (totalCount+pageSize-1) / pageSize;
            sql= getPaginationSQL(sql,(pageIndex-1)*pageSize+1,pageSize);
        }
        rows=jt.queryForList(sql);
        return Action.NONE;
    }

    private String getCountSQL(String originalSql) {
        StringBuffer sql = new StringBuffer(" SELECT count(*) FROM ( ");
        sql.append(originalSql);
        sql.append(" )");
        return sql.toString();
    }

    private String getPaginationSQL(String originalSql, int first, int pageSize) {
        StringBuffer sql = new StringBuffer(" SELECT * FROM ( ");
        sql.append(" SELECT temp.* ,ROWNUM num FROM ( ");
        sql.append(originalSql);
        int last = first + pageSize;
        sql.append("　) temp where ROWNUM <= ").append(last);
        sql.append(" ) WHERE　num > ").append(first);
        return sql.toString();
    }

//    private DataSource getFormDataSource(){
//        //workFlowDefineDao.getBusinessByResId(formDefineVo.getFormDefinitionId());
//    }
}
