package com.gtis.web.action;

import java.util.HashMap;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

/**
 * @(#)UserConfigAction.java 2010-7-1 15:22:46
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class UserConfigAction {
    private static final long serialVersionUID = 5157685281455009173L;
    
    private SplitParam splitParam;
    private String newPassWord;
	private PfUserVo userVo;
	private SysUserService userService;
	private String message;

	/**
	 * 登录和修改密码
	 */
	public String execute() throws Exception {
		return Action.SUCCESS;
	}
	
	/**
	 * 获取用户列表
	 * @return
	 * @throws Exception
	 */
	public String list() throws Exception{
		splitParam=new SplitParamImpl();
		splitParam.setQueryString("getAllUserList");
        HashMap params = new HashMap();
		splitParam.setQueryParam(params);
        
		return "list";
	}

    /**
     * 根据登录人的Id查找用户信息
     * @return
     * @throws Exception
     */
	public String userInfo() throws Exception{
		UserInfo userInfo=SessionUtil.getUserInfo(ServletActionContext.getRequest());
		if(StringUtils.isNotEmpty(userInfo.getId())){
			userVo=userService.getUserVo(userInfo.getId());
		}
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(userVo));
		return Action.NONE;
	}
	
	/**
	 * 保存用户
	 * @return
	 * @throws Exception
	 */
	public String save()throws Exception{
		UserInfo userInfo=SessionUtil.getUserInfo(ServletActionContext.getRequest());
		if(StringUtils.isNotEmpty(userInfo.getId())){
			userService.updateUser(userVo);
		}
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(true));
		return Action.NONE;
	}
	
	/**
	 * 登录
	 * @return
	 * @throws Exception
	 */
//	public String login() throws Exception {
//
//		PfUser userObj=sysDAO.getUserVo4logn(userVo.getLoginName());
//		if (userObj==null){
//			message="用户不存在！";
//			return "login";
//		}else{
//			String checkpass=userVo.getLoginPassWord();
//			if (sysDAO.CheckPassWord(checkpass, userObj.getLoginPassWord())){
//				message="密码错误！";
//				return "login";
//			}else{
//				return SUCCESS;
//			}
//		}
//	}

	/**
	 * 注销
	 * @return
	 * @throws Exception
	 */
//	public String loginout() throws Exception {
//		return "login";
//	}
	/**
	 * 修改密码
	 * @return
	 * @throws Exception
	 */
	public String modifyPassWord() throws Exception {
		String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		PfUserVo userObj=userService.getUserVo(userId);
		if (userObj==null){
			message="用户不存在，请联系管理员！";
		}else{
			String checkpass=userVo.getLoginPassWord();
			String md5= Md5Util.Build(checkpass);
			if (md5.equals(userObj.getLoginPassWord())){
				if (userService.savePassWord(userId,newPassWord))
					message="修改成功！";
				else
					message="修改失败，请联系管理员！";
			}else{
				message="原密码错误！";

			}
		}
		return Action.SUCCESS;
	}

	public PfUserVo getUserVo() {
		return userVo;
	}

	public void setUserVo(PfUserVo userVo) {
		this.userVo = userVo;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

	public String getNewPassWord() {
		return newPassWord;
	}

	public void setNewPassWord(String newPassWord) {
		this.newPassWord = newPassWord;
	}

    public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
}