package com.gtis.web.action;

import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TurnWorkFlowAction {
    private static final Log log = LogFactory.getLog(TurnWorkFlowAction.class);
    /** 工作流核心服务 */
	private WorkFlowCoreService workFlowService;
    /** 意见服务 */
    private SysOpinionService opinionService;
    /** 转发信息xml */
	private String turnXml;
    /** 任务id */
	private String taskid;
    /** 意见列表 */
    private String opinions;
    private static final String CONTENT_TYPE_IMAGE = "text/xml";
    //是否弹出转发确认
    private boolean  confirmTurnInfo=false;

    public boolean isConfirmTurnInfo() {
        return confirmTurnInfo;
    }

    public String execute() throws Exception {
		
		String userId = SessionUtil.getCurrentUserId();
		WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        
		turnXml = turnInfo(info);
        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId,info.getWorkFlowDefineVo().getWorkflowName()));
        //
        WorkFlowXml workFlowXml= WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        ActivityModel activityModel= workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        if ("true".equals(activityModel.getExtendedAttribute("ConfirmTurnInfo")))
            confirmTurnInfo=true;
		return Action.SUCCESS;
	}

    public String trunXml() throws Exception {
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);

		turnXml = turnInfo(info);
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(turnXml);

        return Action.NONE;
    }

    public String opinions() throws Exception{
        String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);

        opinions = JSONUtil.serialize(opinionService.getOpinionList(userId,info.getWorkFlowDefineVo().getWorkflowName()));
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(opinions);

        return Action.NONE;
    }
    /**
     *
     * <Activitys RelType="or">
     *  <Activity Name="转发活动一" Id="a1" MutiSelect="true" DefaultSelected="true">
     *      <User Name="××部门" Id="1">
     *          <UserInfo Name="u1" Id="u1" DefaultSelected="true"/>
     *          <UserInfo Name="u11" Id="u11"/>
     *      </User>
     *      <User Name="××部门" Id="2">
     *          <UserInfo Name="au2" Id="u2"/>
     *          <UserInfo Name="au21" Id="u21"/>
     *      </User>
     *      <User Name="××角色" Id="3">
     *          <UserInfo Name="au3" Id="u3" DefaultSelected="true"/>
     *          <UserInfo Name="au31" Id="u31"/>
     *          <UserInfo  Name="au32" Id="u32"/>
     *      </User>
     *  </Activity>
     *  <Activity Name="转发活动二" Id="a2" MutiSelect="false">
     *   <User Name="××部门" Id="11">
     *      <UserInfo Name="u1" Id="u1"/>
     *      <UserInfo Name="u11" Id="u11"/>
     *   </User>
     * </Activitys>
     *
     *
     */

	private String turnInfo(WorkFlowInfo info) throws Exception {

        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());

        String filterType = null;
        List<String> filterStr = null;
        if(StringUtils.isNotBlank(activityModel.getFilterInfo())){
            //过滤信息对象
            Document fileDoc = DocumentHelper.parseText(activityModel.getFilterInfo());
            //过滤类型：User,Organ,Role
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId(ServletActionContext.getRequest()) + "']/Correspondence");
            if(corNode != null){
                filterType = corNode.valueOf("@type");
                List<DefaultText> organList = corNode.selectNodes(filterType + "/text()");
                if(organList != null && !organList.isEmpty()){
                    filterStr = new ArrayList<String>();
                    for(DefaultText text : organList){
                        filterStr.add(text.getText());    
                    }
                }
            }
        }

        WorkFlowTransInfo transInfo=info.getTransInfo();
		Document doc = org.dom4j.DocumentHelper.createDocument();
        //doc.setXMLEncoding("GBK");
		Element root = doc.addElement("Activitys");
		if (transInfo.getTransType().equalsIgnoreCase("and"))
			root.addAttribute("RelType", "and");
		else
			root.addAttribute("RelType", "or");
        
        if(activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")){
            root.addAttribute("ReqOpinion", "true");
        }else{
            root.addAttribute("ReqOpinion", "false");
        }
        if(activityModel.getIsSendSMS().equalsIgnoreCase("true")){
            root.addAttribute("SendSMS","true");
        }else{
            root.addAttribute("SendSMS","false");
        }
        if(StringUtils.isNotBlank(activityModel.getCooperRootId())){
            root.addAttribute("cooperRootId",activityModel.getCooperRootId());
        }
        
		List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans.size()<2)
            root.addAttribute("RelType", "or");
		for (ActivityModel aModel : lstTrans) {
			Element ActivityEle = root.addElement("Activity");
			ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
			ActivityEle.addAttribute("Id", aModel.getDefineId());
			if (aModel.isMutiSelect())
				ActivityEle.addAttribute("MutiSelect", "true");
			if(aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName()))
				ActivityEle.addAttribute("DefaultSelected", "true");
            else
                ActivityEle.addAttribute("DefaultSelected", "false");
            String userName=null;
            if(StringUtils.isNotBlank(aModel.getExtendedAttribute("DefaultSelectedUser"))){
                userName=aModel.getExtendedAttribute("DefaultSelectedUser");    
            }
			for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if(filterStr != null && userModel.getType().equals(filterType)){
                    if(!filterStr.contains(userModel.getId())){
                        continue;    
                    }
                }
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                for (PfUserVo vo : userModel.getUserList()) {
                    Element UserInfo = User.addElement("UserInfo");
                    UserInfo.addAttribute("Name", vo.getUserName());
                    UserInfo.addAttribute("Id", vo.getUserId());
                    if (StringUtils.isNotBlank(userName) && vo.getUserName().equalsIgnoreCase(userName)){
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo.addAttribute("DefaultSelected", "true");
                    }
                    if (vo.getUserId().equals(SessionUtil.getCurrentUserId())){
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo.addAttribute("DefaultSelected", "true");
                    }
                }
			}
		}
		// 加入是否可以办结
		if (transInfo.isCanFinish()) {
			Element ActivityEle = root.addElement("Activity");
			ActivityEle.addAttribute("Name", "任务办结");
			ActivityEle.addAttribute("Id", "-1");
		}

        doc = httpFilterXml(doc,activityModel,info);

		return doc.getRootElement().asXML();
	}

    /**
     * 通过TurnInfo处理url
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc,ActivityModel actModel,WorkFlowInfo info){
        if(StringUtils.isNotBlank(actModel.getTurnInfoUrl())){
            String url = actModel.getTurnInfoUrl();
            if(!url.startsWith("http")){
                url = AppConfig.getPlaceholderValue(url);
            }
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = {
                new NameValuePair("turnInfo",doc.asXML()),
                new NameValuePair("userId",info.getUserId()),
                new NameValuePair("proId",(info.getWorkFlowIntanceVo() == null)? "":info.getWorkFlowIntanceVo().getProId())
            };

            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}",e);
            }
            if (status == HttpStatus.SC_OK){
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if(StringUtils.isNotBlank(xml)){
                        doc = DocumentHelper.parseText(xml);
                    }
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}",e);
                }
            }else{
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

	/**
	 * 开始转发
	 * 
	 * @return
	 * @throws Exception
     *
     *<?xml version="1.0" encoding="UTF-8"?>
     * <Activitys RelType="or">
     *  <Activity Id="2806A214134F42A798483B2033DE05FB">
     *  <UserInfo Id="02501030000007603100000000000000" RoleId="75501003000000000800000000000000"/>
     *  </Activity>
     *  <ReMark>
     *  <text/>
     *  </ReMark>
     *  </Activitys>
	 */
	public String TurnTask() throws Exception {
        try{
		    workFlowService.turnTask(parseTurnInfo(),taskid);
        }catch (Exception e){
            e.printStackTrace();
            printResult(e.getMessage());
        }
        printResult(null);
		return Action.NONE;
	}

	/**
	 * 读取提交的XML信息
	 * 
	 * @return
	 */
	private Document parseTurnInfo() throws Exception{
		Document doc = null;
        SAXReader reader = new SAXReader();
        doc = reader.read(ServletActionContext.getRequest()
                .getInputStream());
		return doc;
	}

	private void printResult(String  info) {
		try {
			ServletActionContext.getResponse().setContentType("text/html; charset=utf-8");
			PrintWriter out = ServletActionContext.getResponse().getWriter();
			if (info==null)
				out.print("true");
			else
				out.println(info);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

    public String getOpinions() {
        return opinions;
    }

    public WorkFlowCoreService getWorkFlowService() {
		return workFlowService;
	}

	public void setWorkFlowService(WorkFlowCoreService workFlowService) {
		this.workFlowService = workFlowService;
	}

	public String getTurnXml() {
		return turnXml;
	}

	public void setTurnXml(String turnXml) {
		this.turnXml = turnXml;
	}

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }
}
