package com.gtis.web.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.gtis.plat.service.SysCollectExceptionService;
import com.gtis.plat.service.SysExceptionService;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.vo.EcExceptionVo;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.util.UUIDGenerator;
import org.apache.commons.lang.StringUtils;

public class TimeExecuteAction {
	private SysCollectExceptionService collectExceptionSe;
	private SysSupervisorService supervisorSe;
	private SysExceptionService exceptionSe;

	EcSupervisorVo supervisor = null;
	EcExceptionVo exception = null;
	List<EcExceptionVo> exceptionList = null;
	HashMap activity = null;

	public void execute() {
		executeActitime();
		executeWftime();
	}

	/***************************************************************************
	 * 1,收集岗位异常信息
	 * 2,判断收集的岗位异常信息 在EXPECTION中 是否有 该记录（根据ACTIVITY_ID 查找）
	 * 3,a如果没有 则新增岗位异常信息 和 新增督办 
	 * 3,b 如果有则 根据该条EXCEPTION记录 查询督办表（根据EXCEPTION_ID查找） 
	 * 3,b 获得相应的督办信息（1，如果EXPLAIN不为空 则 新增 岗位异常信息和督办信息。2，如果EXPLAIN为 空 则更新岗位异常信息）
	 **************************************************************************/
	public void executeActitime() {

		List<HashMap> actitimeExceptions = collectExceptionSe
				.collectActivityException();// 收集的岗位异常信息
		if (actitimeExceptions != null && actitimeExceptions.size() > 0) {
			for (int j = 0; j < actitimeExceptions.size(); j++) {// 遍历收集岗位异常信息
				activity = (HashMap) actitimeExceptions.get(j);
				exceptionList = exceptionSe.getEcExceptionByActivityId(activity
						.get("ACTIVITY_ID").toString());// 根据ACTIVITY_ID
				// 获取岗位异常信息
				if (exceptionList == null || exceptionList.size() == 0) {// 异常表中没有ACTIVITY_ID对应的记录
					// 就新增 岗位异常和督办
					exception = new EcExceptionVo();
					supervisor = new EcSupervisorVo();
					String orgin_id = null;
					if (activity.get("ORGAN_ID") == null) {
						orgin_id = "";
					} else {
						orgin_id = activity.get("ORGAN_ID").toString();
					}

					exception.actitime_exception(UUIDGenerator.generate(),
							activity.get("WORKFLOW_INSTANCE_ID").toString(),
							activity.get("ACTIVITY_ID").toString(), activity
									.get("USER_ID").toString(), orgin_id, null,
							1, null, null,
							activity.get("USER_NAME").toString(), activity.get(
									"ACTIVITY_NAME").toString(), Integer
									.parseInt(activity.get("TIME_LIMIT")
											.toString()), Integer
									.parseInt(activity.get("HANDLES_DAY")
											.toString()), (Date) activity
									.get("BEGIN_TIME"));
					// 实例化 督办
					supervisor.setSupervisorInfoId(UUIDGenerator.generate());
					supervisor.setExceptionId(exception.getExceptionId());
					supervisor.setActivityId(exception.getActivityId());
					supervisor.setSupervisorTime(new Date(System
							.currentTimeMillis()));
					supervisor.setTargetId(exception.getUserId());
					supervisor.setWorkflowInstanceId(exception
							.getWorkflowInstanceId());
					supervisor.setTargetType(2);
					// 保存 岗位时限异常和相应的督办异常
					exceptionSe.saveException(exception);
					supervisorSe.saveEcSupervisorVo(supervisor);
				} else {// 如果异常表中已经有ACTIVITY_ID应的记录 则循环遍历
					int has=0;
					for (int i = 0; i < exceptionList.size(); i++) {
						exception = (EcExceptionVo) exceptionList.get(i);
						supervisor = supervisorSe
								.queryEcSupervisorVoByExceptionId(exception.getExceptionId());// 根据岗位异常ID 获取 督办信息
						if (supervisor.getSupervisorExplain() == null
								|| supervisor.getSupervisorExplain().equals("")) {// 如果督办表中的解释
							// 为空
							// 则更新岗位限时异常
							// 更新岗位异常的部分信息
							has=1;
							exception.actitime_exception(exception
									.getExceptionId(), exception
									.getWorkflowInstanceId(), exception
									.getActivityId(), exception.getUserId(),
									exception.getOrganId(), null, 1, null,
									null, activity.get("USER_NAME").toString(),
									activity.get("ACTIVITY_NAME").toString(),
									Integer.parseInt(activity.get("TIME_LIMIT")
											.toString()), Integer
											.parseInt(activity.get(
													"HANDLES_DAY").toString()),
									(Date) activity.get("BEGIN_TIME"));
							exceptionSe.updateException(exception);// 更新岗位限时异常
						} else if((StringUtils.isNotBlank(supervisor.getSupervisorExplain()))&&has==0){// 如果督办表中的解释不为 空 则 新增 岗位限时异常 并 新增个督办
							String orgin_id = null;
							if (activity.get("ORGAN_ID") == null) {
								orgin_id = "";
							} else {
								orgin_id = activity.get("ORGAN_ID").toString();
							}
							exception = new EcExceptionVo();
							supervisor = new EcSupervisorVo();
							exception.actitime_exception(UUIDGenerator
									.generate(), activity.get(
									"WORKFLOW_INSTANCE_ID").toString(),
									activity.get("ACTIVITY_ID").toString(),
									activity.get("USER_ID").toString(),
									orgin_id, "", 1, null, null, activity.get(
											"USER_NAME").toString(), activity
											.get("ACTIVITY_NAME").toString(),
									Integer.parseInt(activity.get("TIME_LIMIT")
											.toString()), Integer
											.parseInt(activity.get(
													"HANDLES_DAY").toString()),
									(Date) activity.get("BEGIN_TIME"));
							// 实例化 督办
							supervisor.setSupervisorInfoId(UUIDGenerator
									.generate());
							supervisor.setExceptionId(exception
									.getExceptionId());
							supervisor.setActivityId(exception.getActivityId());
							supervisor.setSupervisorTime(new Date(System
									.currentTimeMillis()));
							supervisor.setTargetId(exception.getUserId());
							supervisor.setWorkflowInstanceId(exception
									.getWorkflowInstanceId());
							supervisor.setTargetType(2);
							// 保存 岗位时限异常和相应的督办异常
							exceptionSe.saveException(exception);
							supervisorSe.saveEcSupervisorVo(supervisor);
						}
					}
				}
			}
		}
	}

	/***************************************************************************
	 * 1,收集事项办理异常信息 
	 * 2,判断收集的事项办理异常信息 在EXPECTION中 是否有 该记录（根据WORKFLOW_INSTANCE_ID 查找）
	 * 3,a如果没有 则 新增事项办理异常信息  和 新增督办 
	 * 3,b如果有则 根据更新该条EXCEPTION记录 
	 **************************************************************************/
	public void executeWftime() {
		// 处理事项办理异常
		exceptionList = null;
		exception = null;
		supervisor = null;
		HashMap wftime = null;

		List<HashMap> wftimeList = collectExceptionSe.collectWftimeException();// 收集的岗位异常信息

		if (wftimeList != null && wftimeList.size() > 0) {

			for (int cent = 0; cent < wftimeList.size(); cent++) {
				wftime = wftimeList.get(cent);
				exceptionList = exceptionSe.getEcExceptionByInstanceId(wftime
						.get("WORKFLOW_INSTANCE_ID").toString());
				if (exceptionList == null || exceptionList.size() == 0) {

					exception = new EcExceptionVo();
					supervisor = new EcSupervisorVo();
					// 实例化exception对象
					exception.wftime_exception(UUIDGenerator.generate(), wftime
							.get("WORKFLOW_INSTANCE_ID").toString(), null, 1,
							null, null, Integer.parseInt(wftime.get(
									"TIME_LIMIT").toString()), Integer
									.parseInt(wftime.get("HANDLES_DAY")
											.toString()), (Date) wftime
									.get("CREATE_TIME"));
					// 实例化督办
					supervisor.setSupervisorInfoId(UUIDGenerator.generate());
					supervisor.setExceptionId(exception.getExceptionId());
					// supervisor.setActivityId(exception.getActivityId());
					supervisor.setSupervisorTime(new Date(System
							.currentTimeMillis()));
					supervisor.setTargetId(exception.getWorkflowInstanceId());
					supervisor.setWorkflowInstanceId(exception
							.getWorkflowInstanceId());
					supervisor.setTargetType(1);
//					supervisor.setSupervisorExplain("wlw--------");
					exceptionSe.saveException(exception);
					supervisorSe.saveEcSupervisorVo(supervisor);
				} else {
					exception = exceptionList.get(0);
					exception.wftime_exception(exception.getExceptionId(),
							exception.getWorkflowInstanceId(), null, 1, null,
							null, Integer.parseInt(wftime.get("TIME_LIMIT")
									.toString()), Integer.parseInt(wftime.get(
									"HANDLES_DAY").toString()), (Date) wftime.get("CREATE_TIME"));
					exceptionSe.updateException(exception);
				}
			}

		}

	}

	public SysCollectExceptionService getCollectExceptionSe() {
		return collectExceptionSe;
	}

	public void setCollectExceptionSe(
			SysCollectExceptionService collectExceptionSe) {
		this.collectExceptionSe = collectExceptionSe;
	}

	public SysSupervisorService getSupervisorSe() {
		return supervisorSe;
	}

	public void setSupervisorSe(SysSupervisorService supervisorSe) {
		this.supervisorSe = supervisorSe;
	}

	public SysExceptionService getExceptionSe() {
		return exceptionSe;
	}

	public void setExceptionSe(SysExceptionService exceptionSe) {
		this.exceptionSe = exceptionSe;
	}

}
