package com.gtis.web.action;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

public class TaskRemarkAction {
	private String taskid;
	private SysTaskService taskService;
	private String remark;
	private boolean result=false;
    private String userName;

	public boolean isResult() {
		return result;
	}

	public void setResult(boolean result) {
		this.result = result;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}
	
	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

    public String getUserName() {
        return userName;
    }

    public String execute() throws Exception {
		PfTaskVo taskVo=taskService.getTask(taskid);
		if (taskVo!=null)
			remark=taskVo.getRemark();
		return Action.SUCCESS;
	}
	
	public String save() throws Exception {
		PfTaskVo taskVo=taskService.getTask(taskid);
		if (taskVo!=null){
			taskVo.setRemark(remark);
			taskService.updateTask(taskVo);
			result=true;
		}
		return Action.SUCCESS;
	}

    /**
     * 获取任务之前活动的办理意见
     * @return
     * @throws Exception
     */
    public String info() throws Exception {
        if (StringUtils.isNotBlank(taskid)){
            PfTaskVo taskVo= taskService.getTask(taskid);
            if (taskVo!=null){
                PfActivityVo activityVo=taskService.getActivity(taskVo.getActivityId());
                if (activityVo!=null){
                    List<PfTaskVo> taskVos=taskService.getHistoryTaskListByInstance(activityVo.getWorkflowInstanceId());
                    for(PfTaskVo task:taskVos){
                        if (StringUtils.isNotBlank(task.getRemark())) {
                            remark=task.getRemark();
                            userName= task.getUserVo().getUserName();
                            break;
                        }
                    }
                }
            }
        }
        return "info";
    }
}
