package com.gtis.web.action;

import java.util.List;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.ResourceModel;
import com.opensymphony.xwork2.Action;

public class TaskOverHandleAction {
	String taskid;
	SysTaskService taskService;
	SysWorkFlowInstanceService workFlowIntanceService;
	SysWorkFlowDefineService workFlowDefineService;
    NodeService nodeService;   //用来获取附件

	PfTaskVo taskVo;
	PfActivityVo activityVo;
	PfWorkFlowInstanceVo workFlowInstanceVo;
	PfWorkFlowDefineVo workFlowDefineVo;
	String menu;
    private String fileTokenId;   //文件中心用tokenid
    private int fileCenterNodeId;
  //勘测定界扩展属性配置
    private String kcdjTypeConfig;
    private String busiType;

	public String execute() throws Exception {
		if (StringUtils.isNotBlank(taskid)){
			taskVo=taskService.getHistoryTask(taskid);
			activityVo=taskService.getActivity(taskVo.getActivityId());
			workFlowInstanceVo=workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
			workFlowDefineVo=workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
			//菜单
			//WorkFlowXml xmlModel=workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
			//ActivityModel aModel=xmlModel.getActivity(activityVo.getActivityDefinitionId());
			//List<ResourceModel> lstResource=aModel.getResourceList();
			//menu=ObjectJSONUtil.ObjectToJson(lstResource);
            ///////客户端用来获取附件////////////////////////////////////////
            Space space = nodeService.getWorkSpace(StuffManageAction.WORK_FLOW_STUFF,true);
            try{
                Node node = nodeService.getNode(space.getId(), activityVo.getWorkflowInstanceId(), false);
                if (node!=null){
                    fileTokenId=nodeService.getToken(node);
                    fileCenterNodeId=node.getId();
                }
            }catch (Exception ex){

            }
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineVo);
            ////////////////////////////////////////////////////////////
            //扩展属性中关于勘测定界管理模块的配置属性获取
            kcdjTypeConfig = xmlDao.getExtendedAttribute("KcdjTypeConfig") + "";
            busiType = xmlDao.getExtendedAttribute("BusiType") + "";
            if (StringUtils.isBlank(busiType)) {
                busiType = xmlDao.getExtendedAttribute("busiType") + "";
            }
		}
		return Action.SUCCESS;
	}
	
	public String menu() throws Exception {
		if (taskid!=null && !taskid.equals("")){
			taskVo=taskService.getHistoryTask(taskid);
			activityVo=taskService.getActivity(taskVo.getActivityId());
			workFlowInstanceVo=workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
//			WorkFlowXml xmlModel=workFlowIntanceService.getWorkflowInstanceXmlModel(workFlowInstanceVo);
			WorkFlowXml xmlModel =WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
			//WorkFlowXml xmlModel=workFlowInstanceVo.getXmlModel();
			ActivityModel aModel=xmlModel.getActivity(activityVo.getActivityDefinitionId());
//			ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
//			ServletActionContext.getResponse().setCharacterEncoding("utf-8");
//			ServletActionContext.getResponse().getWriter().println("<?xml version=\"1.0\" encoding=\"GBK\"?>");
//			ServletActionContext.getResponse().getWriter().println(aModel.getResources());
//			ServletActionContext.getResponse().setCharacterEncoding("utf-8");
			ServletActionContext.getResponse().setContentType("text/xml");
			ServletActionContext.getResponse().getWriter().println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
			ServletActionContext.getResponse().getWriter().println(aModel.getResources());
//			OutputFormat format = OutputFormat.createPrettyPrint();
//			format.setEncoding("GBK");
//			format.setTrimText(false);
//			format.setOmitEncoding(false);
//			
//			XMLWriter writer = null;
//			writer = new XMLWriter(ServletActionContext.getResponse().getOutputStream(), format);
//			// 写入xlst
//			writer.processingInstruction("xml","version=\"1.0\" encoding=\"GBK\"");
//			writer.write(aModel.getResourcesNode());
			//ServletActionContext.getResponse().getOutputStream().flush();
			//ServletActionContext.getResponse().getOutputStream().close();
		}
		return Action.NONE;
	}
	

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public PfTaskVo getTaskVo() {
		return taskVo;
	}

	public void setTaskVo(PfTaskVo taskVo) {
		this.taskVo = taskVo;
	}

	public PfActivityVo getActivityVo() {
		return activityVo;
	}

	public void setActivityVo(PfActivityVo activityVo) {
		this.activityVo = activityVo;
	}

	public PfWorkFlowInstanceVo getWorkFlowInstanceVo() {
		return workFlowInstanceVo;
	}

	public void setWorkFlowInstanceVo(PfWorkFlowInstanceVo workFlowInstanceVo) {
		this.workFlowInstanceVo = workFlowInstanceVo;
	}

	public PfWorkFlowDefineVo getWorkFlowDefineVo() {
		return workFlowDefineVo;
	}

	public void setWorkFlowDefineVo(PfWorkFlowDefineVo workFlowDefineVo) {
		this.workFlowDefineVo = workFlowDefineVo;
	}
	public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public String getFileTokenId() {
        return fileTokenId;
    }

    public int getFileCenterNodeId() {
        return fileCenterNodeId;
    }

    public String getMenu() {
		return menu;
	}

	public void setMenu(String menu) {
		this.menu = menu;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public SysWorkFlowInstanceService getWorkFlowIntanceService() {
		return workFlowIntanceService;
	}

	public void setWorkFlowIntanceService(
			SysWorkFlowInstanceService workFlowIntanceService) {
		this.workFlowIntanceService = workFlowIntanceService;
	}

	public String getKcdjTypeConfig() {
		return kcdjTypeConfig;
	}

	public void setKcdjTypeConfig(String kcdjTypeConfig) {
		this.kcdjTypeConfig = kcdjTypeConfig;
	}

	public void setFileTokenId(String fileTokenId) {
		this.fileTokenId = fileTokenId;
	}

	public void setFileCenterNodeId(int fileCenterNodeId) {
		this.fileCenterNodeId = fileCenterNodeId;
	}

	public String getBusiType() {
		return busiType;
	}

	public void setBusiType(String busiType) {
		this.busiType = busiType;
	}

}
