package com.gtis.web.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.rss.RssAction;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.json.JSONUtil;

public abstract class TaskListActionAbstract extends RssAction{
    /** 分页 */
	private SplitParam splitParam;
    /** 工作流定义列表 */
	private List<PfWorkFlowDefineVo> lstWorkFlowDefine;
    /** 业务列表 */
    private List<PfBusinessVo> businessList;
    /** 工作流定义服务 */
	private SysWorkFlowDefineService workFlowDefineService;
    /** 用户管理服务 */
	private SysUserService userService;
    /** 系统配置 */
	PfConfigVo configVo;
    /** 业务类型，可以传入用来过滤不同的业务 */
    private String btypes;

    private String businessid;

    boolean barCodeQuery=false;   //是否使用条形码查询功能

    public boolean isBarCodeQuery() {
        return barCodeQuery;
    }

    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }

    public String getWorkFlowDefineList()throws Exception{
        if (StringUtils.isNotBlank(businessid)){
            lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineByBusiness(businessid);
        }else{
            lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
        }
        PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
        vo.setWorkflowName("----所有流程----");
        vo.setWorkflowDefinitionId("");
        lstWorkFlowDefine.add(0, vo);
        ServletActionContext.getResponse().setContentType("text/xml;charset=utf-8");
        String json= ObjectJSONUtil.ObjectToJson(lstWorkFlowDefine);
        ServletActionContext.getResponse().getOutputStream().write(json.toString().getBytes("utf-8"));
        ServletActionContext.getResponse().getOutputStream().flush();
        ServletActionContext.getResponse().getOutputStream().close();
        return Action.NONE;
    }

    public String execute() throws Exception {
		SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString(this.getIbatisQueryName());
		splitParam1.setQueryParam(this.getParam());
		splitParam=splitParam1;

        lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
		PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
		vo.setWorkflowName("----所有业务----");
		vo.setWorkflowDefinitionId("");
		lstWorkFlowDefine.add(0, vo);

        businessList = workFlowDefineService.getBusinessSimpleList();
        PfBusinessVo pbv = new PfBusinessVo();
        pbv.setBusinessName("----所有业务----");
        pbv.setBusinessId("");
        businessList.add(0,pbv);

        configVo=SessionUtil.getUserConfig(ServletActionContext.getRequest());
		ServletActionContext.getRequest().setAttribute("USERID",SessionUtil.getUserId(ServletActionContext.getRequest()));

        //是否使用条形码查询功能
        String barcode= AppConfig.getProperty("barcode.enable");
        if ("true".equalsIgnoreCase(barcode))
            barCodeQuery= true;

        return Action.SUCCESS;
	}

    /**
     * rss源发布
     * @return
     * @throws Exception
     */
	public String rss() throws Exception {
		SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString(this.getIbatisQueryName());
		splitParam1.setQueryParam(this.getParam());
		super.setRssParam(splitParam1);
		return super.rss();
	}

    /**
     * 参数处理
     * @return
     */
    public HashMap<String,String> getParam() {
        HashMap<String,String> mapParam= new HashMap<String, String>();
        String bType= buildBusinessTypes();
        if (StringUtils.isNotBlank(bType))
            mapParam.put("workflowcodes",bType);
//        if(!(SessionUtil.getCurrentUserId().equals("0"))){
//        	mapParam.put("userIds", SessionUtil.getCurrentUserIds());
//            mapParam.put("workflowcodes",buildBusinessTypes());
//            mapParam.put("regionCode",this.getUserService().getUserRegionCode(SessionUtil.getUserId(ServletActionContext.getRequest())));
//        }
        //mapParam.put("userId", SessionUtil.getUserId(ServletActionContext.getRequest()));
        return mapParam;
    }

    /**
     * 将转入的btype（，号隔开，用‘’隔开，方便查询）
     * @return
     */
    private String buildBusinessTypes(){
        if (!StringUtils.isBlank(btypes)){
            String[] bTypeArray=StringUtils.split(btypes,",");
            StringBuffer sbTypes=new StringBuffer();
            for (String BType : bTypeArray) {
                    sbTypes.append("'" + BType + "',");
            }
            if (sbTypes.length()>0)
                return  sbTypes.toString().substring(0,sbTypes.toString().length()-1);
            else
                return null;
        }
        return null;
    }
	public String exceptionList() throws Exception{
		
		return "";
	}
	
	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}
	
	public String getIbatisQueryName(){
		return "";
	}

	public PfConfigVo getConfigVo() {
		return configVo;
	}

	public void setConfigVo(PfConfigVo configVo) {
		this.configVo = configVo;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

    public String getBtypes() {
        return btypes;
    }

    public void setBtypes(String btypes) {
        this.btypes = btypes;
    }
    
    public SplitParam getSplitParam() {
		return splitParam;
	}

	public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
		return lstWorkFlowDefine;
	}

	public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
		this.lstWorkFlowDefine = lstWorkFlowDefine;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

    public List<PfBusinessVo> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<PfBusinessVo> businessList) {
        this.businessList = businessList;
    }
}
