package com.gtis.web.action;

import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: jibo1024
 * Date: 11-7-9
 * Time: 下午12:34
 * To change this template use File | Settings | File Templates.
 */
public class TaskInfoAction {
    private String taskid;
	private SysTaskService taskService;
    private SysActivityService activityService;
    private PfTaskVo taskVo;
	private PfActivityVo activityVo;
    private List<PfTaskVo> beforeTasks;

    public List<PfTaskVo> getBeforeTasks() {
        return beforeTasks;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysActivityService getActivityService() {
        return activityService;
    }

    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }

    public PfTaskVo getTaskVo() {
        return taskVo;
    }

    public void setTaskVo(PfTaskVo taskVo) {
        this.taskVo = taskVo;
    }

    public PfActivityVo getActivityVo() {
        return activityVo;
    }

    public void setActivityVo(PfActivityVo activityVo) {
        this.activityVo = activityVo;
    }

    /**
     * 获取该任务的提示信息
     * 1退回信息
     * 2前一个办理信息he意见
     * @return
     * @throws Exception
     */
    public String execute() throws Exception{
        StringBuffer infoBuffer=new StringBuffer();
        if (StringUtils.isNotBlank(taskid)) {
			PfTaskVo task = taskService.getTask(taskid);
            //退回信息
            if (task.isBackState()){
                this.activityVo=activityService.queryBeforeBackActivityById(task.getActivityId());
                if (this.activityVo!=null){
                    List<PfTaskVo> tasks=taskService.getHistoryTasks(activityVo.getActivityId());
                    if (tasks!=null && tasks.size()>0){
                        this.taskVo= tasks.get(0);
    //                    infoBuffer.append("【"+activityVo.getActivityName()+"】");
    //                    infoBuffer.append("办理人:"+ task.getUserVo().getUserName());
    //                    infoBuffer.append(activityVo.getFinishTime()+ "退回!");
    //                    if (StringUtils.isNotBlank(task.getRemark())){
    //                        infoBuffer.append("<br/>意见:"+task.getRemark());
    //                    }
                    }
                }
            }
            // 上一个任务的意见
            this.beforeTasks=taskService.getHistoryTaskByBefore(task);
        }
        if (this.taskVo==null || this.beforeTasks.size()==0 )
            return Action.NONE;
        else
            return Action.SUCCESS;
    }
}
