package com.gtis.web.action;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

import java.util.List;

public class TaskEntrustAction {
    SysUserService userService;
    WorkFlowCoreService workFlowService;
    SysTaskService taskService;
    SysWorkFlowInstanceService worFlowInstanceService;

    String taskid;
    String userId;   //被委托人
    List<PfOrganVo> organVoList;

    String organId;
    private static final String CONTENT_TYPE = "text/json; charset=utf-8";
    private static final org.apache.commons.logging.Log log = LogFactory
            .getLog(TaskEntrustAction.class);

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getWorFlowInstanceService() {
        return worFlowInstanceService;
    }

    public void setWorFlowInstanceService(SysWorkFlowInstanceService worFlowInstanceService) {
        this.worFlowInstanceService = worFlowInstanceService;
    }

    public String getOrganId() {
        return organId;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public List<PfOrganVo> getOrganVoList() {
        return organVoList;
    }

    public WorkFlowCoreService getWorkFlowService() {
        return workFlowService;
    }

    public void setWorkFlowService(WorkFlowCoreService workFlowService) {
        this.workFlowService = workFlowService;
    }

    private void initTrustUser() {
        PfTaskVo taskVo = taskService.getTask(taskid);
        PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
        String xmlModel = worFlowInstanceService.getWorkflowInstanceXml(worFlowInstanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId()));
        WorkFlowXml workXml = new WorkFlowXml(xmlModel);
        ActivityModel sourceActivityModel = workXml
                .getActivity(activityVo.getActivityDefinitionId());
        String userName = sourceActivityModel.getExtendedAttribute("DefaultTrustUserName");
        if (StringUtils.isNotBlank(userName)){
            List<PfUserVo> userList = userService.getUserVoListByUserName(userName);
            if (userList.size() > 0) {
                userId = userList.get(0).getUserId();
                List<PfOrganVo> organList = userService.getOrganListByUser(userId);
                if (organList.size() > 0) {
                    organId = organList.get(0).getOrganId();
                }
            }
        }
    }

    public String execute() throws Exception {
        organVoList = userService.getOrganList();
        if (StringUtils.isNotBlank(taskid))
            initTrustUser();
        return Action.SUCCESS;
    }

    public String Users() throws Exception {
        if (StringUtils.isNotBlank(organId)) {
            List<PfUserVo> userVoList = userService.getUserListByOragn(organId);
            ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(userVoList));
            ServletActionContext.getResponse().getWriter().flush();
        }
        return Action.NONE;
    }

    public String Trust() throws Exception {
        if (StringUtils.isNotBlank(taskid) && StringUtils.isNotBlank(userId)) {
            try {
                workFlowService.entrustTask(taskid, userId);
                ServletActionContext.getResponse().getWriter().println("true");
            } catch (Exception e) {
                ServletActionContext.getResponse().getWriter().println(e.getMessage());
                //log.error(e.getMessage(), e);
            }
        }
        return Action.NONE;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
