package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfResourceVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;

public class SysResourceAction {
    String rid;
    SysMenuService menuService;
    SysTaskService taskService;
    SysWorkFlowInstanceService workFlowInstanceService;
    String code;
    String taskid;
    String wiid;
    String resourceUrl;
    String from;
    String title;
    boolean disable = false;

    public String getTitle() {
        return title;
    }

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public SysTaskService getTaskService() {
        return taskService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public SysWorkFlowInstanceService getWorkFlowInstanceService() {
        return workFlowInstanceService;
    }

    public void setWorkFlowInstanceService(
            SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String execute() throws Exception {
        PfResourceVo resourceVo = null;
        if (code != null && !code.equals("")) {
            resourceVo = menuService.getResourceByCode(code);
            this.rid = resourceVo.getResourceId();
        } else
            resourceVo = menuService.getResource(rid);
        if (resourceVo != null) {
            this.title = resourceVo.getResourceName();
            if (resourceVo.getResourceType() == 1) { // 动态表单
                resourceUrl = "./form.action?dfid=" + rid;

                resourceUrl = resourceUrl + "&"
                        + ServletActionContext.getRequest().getQueryString();

                ServletActionContext.getResponse().sendRedirect(resourceUrl);
                return Action.NONE;
            } else if (resourceVo.getResourceType() == 6) { // 表单查询
                resourceUrl = "./forms/fromQuery.action?id=" + rid;
                resourceUrl = resourceUrl + "&"
                        + ServletActionContext.getRequest().getQueryString();
                ServletActionContext.getResponse().sendRedirect(resourceUrl);
                return Action.NONE;
            } else {
                resourceUrl = resourceVo.getResourceUrl();
            }
            ///////////////
            resourceUrl = AppConfig.getPlaceholderValue(resourceUrl);
            /////////////
            if (resourceUrl.indexOf("?") > 0) {
                resourceUrl = resourceUrl + "&"
                        + ServletActionContext.getRequest().getQueryString();
            } else {
                resourceUrl = resourceUrl + "?"
                        + ServletActionContext.getRequest().getQueryString();
            }
            if (!disable) {
                if (resourceUrl.indexOf("disable") > 0)
                    disable = true;
            }
        }
        return Action.SUCCESS;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public SysMenuService getMenuService() {
        return menuService;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public String getProId() {
        if (wiid == null || wiid.equals("")) {
            PfTaskVo taskVo = taskService.getTask(taskid);
            if (taskVo == null)
                taskVo = taskService.getHistoryTask(taskid);
            PfActivityVo activityVo = taskService.getActivity(taskVo
                    .getActivityId());
            PfWorkFlowInstanceVo instanceVo = workFlowInstanceService
                    .getWorkflowInstance(activityVo.getWorkflowInstanceId());
            return instanceVo.getProId();
        }
        return "";
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isDisable() {
        return disable;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }
}
