package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.gtis.web.SystemMenu;
import com.opensymphony.xwork2.Action;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.springframework.util.FileCopyUtils;

import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class SysMenuAction {

    SysMenuService menuService;
    String code;
    private static final String CONTENT_TYPE = "text/html; charset=utf-8";
    private static final String ROOTMENU_CODE = "sys";
    private static final String RESOURCE_URL = "SysResource.action?rid=";
    protected Log log = LogFactory.getLog(getClass());
    String parentid;
    List<PfMenuVo> menus;

    String id;

    public void setId(String id) {
        this.id = id;
    }

    public List<PfMenuVo> getMenus() {
        return menus;
    }

    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    public String config() {
        if (SessionUtil.getCurrentUser().isAdmin()) {
            return "config";
        }
        throw new RuntimeException("no permission");
    }

    public String upload() throws IOException {
        HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper) ((HttpServletRequestWrapper) ServletActionContext.getRequest()).getRequest();
        MultiPartRequestWrapper request = (MultiPartRequestWrapper) wrapper.getRequest();
        File image = request.getFiles("image")[0];
        String imageFileName = request.getFileNames("image")[0];
        File path = new File(AppConfig.getProperty("egov.data.path") + "/egov/menuIcon");
        FileUtils.copyFile(image, new File(path, id + "." + StringUtils.substringAfterLast(imageFileName, ".").toLowerCase()));
        Struts2Utils.renderJs("try{(opener || parent).onUploadCompleted('" + id + "');}catch(e){}");
        return null;
    }

    public String get() throws IOException {
        HttpServletResponse response = ServletActionContext.getResponse();
        File img = null;
        String defIconPath = ServletActionContext.getServletContext().getRealPath("/pf/images/icon/");
        outer:
        for (String path : new String[]{AppConfig.getProperty("egov.data.path") + "/egov/menuIcon", defIconPath}) {
            for (String ext : new String[]{"jpg", "gif", "png"}) {
                img = new File(path, id + "." + ext);
                if (img.exists()) {
                    response.setContentType("image/" + ext);
                    break outer;
                }
            }
        }
        if (img != null) {
            if (!img.exists()) {
                img = new File(defIconPath + "/default/g" + Math.abs(id.hashCode()) % 5 + ".gif");
            }
            long modified = img.lastModified();
            long modifiedSince = ServletActionContext.getRequest().getDateHeader("If-Modified-Since");
            if (modifiedSince > 0L) {
                long modDate = (modified / 1000L) * 1000L;
                if (modDate <= modifiedSince) {
                    response.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
                    return null;
                }
            }
            response.setDateHeader("Last-Modified", modified);
            response.setContentLength((int) img.length());
            FileCopyUtils.copy(new FileInputStream(img), response.getOutputStream());
        }
        return null;
    }

    public String menu() throws Exception {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenuVo menuVo : menuService.getMenusByUserInfo(userInfo)) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        if (root != null) {
            List<Menu> cMenus = root.getChildren();
            for (int i = 0, size = cMenus.size(); i < size; i++) {
                Menu menu = cMenus.get(i);
                List<Menu> children = new ArrayList<Menu>();
                menu.setExpanded(i == 0);
                menu.setLeaf(false);
                menu.setCls("m-group" + (i == 0 ? " m-first" : ""));
                menu.setIcon(ServletActionContext.getRequest().getContextPath() + "/SysMenu!get.action?id=" + menu.getId());
                mergeTo(children, menu);
                menu.setChildren(children);
            }
            Struts2Utils.renderJson(root.getChildren());
        }
        return null;
    }

    public String menu1() throws Exception {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenuVo menuVo : menuService.getMenusByUserInfo(userInfo)) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        if (root != null) {
            merge3(root, 1);
            Struts2Utils.renderJson(root.getChildren());
        }
        return null;
    }

    private static void merge3(Menu menu, int level) {
        List<Menu> children = new ArrayList<Menu>();
        for (Menu m : menu.getChildren()) {
            m.setExpanded(false);
            m.setLeaf(m.getChildren().size() == 0);
            m.setCls("m-item");
            m.setIcon(ServletActionContext.getRequest().getContextPath() + "/SysMenu!get.action?id=" + m.getId());
            if (level > 2) {
                if(m.getChildren().size()==0){
                    children.add(m);
                }else {
                    mergeTo(children, m);
                }
            } else {
                merge3(m, level + 1);
            }
        }
        if (level == 3) {
            menu.setChildren(children);
        }
    }

    private static void mergeTo(List<Menu> children, Menu menu) {
        for (Menu m : menu.getChildren()) {
            m.setExpanded(false);
            m.setLeaf(true);
            m.setCls("m-item");
            m.setIcon(ServletActionContext.getRequest().getContextPath() + "/SysMenu!get.action?id=" + m.getId());
            if (m.getLink() != null) {
                children.add(m);
            }
            mergeTo(children, m);
            m.setChildren(null);
        }
    }

    private static Menu toMenu(PfMenuVo menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull(menuVo.getMenuPId()));
        String rid = menuVo.getResourceVo().getResourceId();
        if (rid != null) {
            menu.setLink(RESOURCE_URL + rid);
        }
        return menu;
    }

    private static String getIcon(String name) {
        return name != null ? ServletActionContext.getRequest().getContextPath() + "/pf/images/icon/" + name + ".gif" : null;
    }

    @SuppressWarnings("unchecked")
    public String execute() throws Exception {
        // long time=Calendar.getInstance().getTimeInMillis();
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<PfMenuVo> lstMenu = menuService.getMenusByUserInfo(userInfo);
        if (code == null || code.equals(""))
            code = ROOTMENU_CODE;

        SystemMenu rootMenu = new SystemMenu();
        List<HashMap> lstMenuObj = new ArrayList<HashMap>();
        HashMap<String, String> treeMap = new HashMap<String, String>();
        for (PfMenuVo menuVo : lstMenu) {
            if (code.equalsIgnoreCase(menuVo.getMenuCode())) {
                rootMenu.setMenuId(menuVo.getMenuId());
                rootMenu.setMenuText(menuVo.getMenuName());
                rootMenu.setMenuUrl(RESOURCE_URL
                        + menuVo.getResourceVo().getResourceId());
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("text", menuVo.getMenuName());
                map.put("url", RESOURCE_URL
                        + menuVo.getResourceVo().getResourceId());
                map.put("id", menuVo.getMenuId());
                map.put("pid", menuVo.getMenuPId());
                treeMap.put(menuVo.getMenuId(), menuVo.getMenuPId());
                lstMenuObj.add(map);
            }
        }
        // for (int i = 0; i < lstMenuObj.size(); i++) {
        // addMenuObj(rootMenu, lstMenuObj.get(i));
        // }
        while (lstMenuObj.size() > 0) {
            int i = 0;
            boolean addIn = addMenuObj(rootMenu, lstMenuObj.get(i));
            while (!addIn) {
                i++;
                if (i < lstMenuObj.size())
                    addIn = addMenuObj(rootMenu, lstMenuObj.get(i));
                else
                    break;
            }
            if (i == lstMenuObj.size() - 1) {
                lstMenuObj.remove(i);
                break;
            } else {
                lstMenuObj.remove(i);
            }
        }
        ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        printJsonTree(rootMenu, ServletActionContext.getResponse());
        ServletActionContext.getResponse().getWriter().flush();
        // log.error(Calendar.getInstance().getTimeInMillis()-time);
        return Action.NONE;
    }

    /**
     * 返回系统菜单，就是我的办公环境菜单
     *
     * @return
     * @throws Exception
     */
    public String childmenus() throws Exception {
        UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
        SystemMenu rootMenu = new SystemMenu();
        if (StringUtils.isNotBlank(parentid)) {
            this.menus = menuService.getRootMenuChildsByRoles(userInfo, parentid);
        } else {
            this.menus = menuService.getSysMenuByUserInfo(userInfo);
        }
        List<HashMap> lstMenuObj = new ArrayList<HashMap>();
        HashMap<String, String> treeMap = new HashMap<String, String>();
        for (PfMenuVo menuVo : menus) {
            if ((StringUtils.isNotBlank(parentid) && menuVo.getMenuId().equals(parentid)) || (StringUtils.isBlank(parentid) && "sys".equals(menuVo.getMenuCode()))) {
                rootMenu.setMenuId(menuVo.getMenuId());
                rootMenu.setMenuText(menuVo.getMenuName());
                rootMenu.setMenuUrl(RESOURCE_URL + menuVo.getResourceVo().getResourceId());
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("text", menuVo.getMenuName());
                map.put("url", RESOURCE_URL + menuVo.getResourceVo().getResourceId());
                map.put("id", menuVo.getMenuId());
                map.put("pid", menuVo.getMenuPId());
                treeMap.put(menuVo.getMenuId(), menuVo.getMenuPId());
                lstMenuObj.add(map);
            }
        }
        while (lstMenuObj.size() > 0) {
            int i = 0;
            boolean addIn = addMenuObj(rootMenu, lstMenuObj.get(i));
            while (!addIn) {
                i++;
                if (i < lstMenuObj.size())
                    addIn = addMenuObj(rootMenu, lstMenuObj.get(i));
                else
                    break;
            }
            if (i == lstMenuObj.size() - 1) {
                lstMenuObj.remove(i);
                break;
            } else {
                lstMenuObj.remove(i);
            }
        }

        ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        printJsonTree(rootMenu, ServletActionContext.getResponse());
        ServletActionContext.getResponse().getWriter().flush();

        return Action.NONE;
    }

    @SuppressWarnings("unchecked")
    private static boolean addMenuObj(SystemMenu menuObj, HashMap map) {
        String menuPid = map.get("pid").toString();
        String url, text;
        if (map.get("url") == null) {
            url = "";
        } else {
            url = map.get("url").toString();
        }

        if (map.get("text") == null) {
            text = "";
        } else {
            text = map.get("text").toString();
        }

        if (menuObj.getMenuId().equals(menuPid)) {
            SystemMenu childObj = new SystemMenu();
            childObj.setMenuId(map.get("id").toString());
            childObj.setMenuText(text);
            childObj.setMenuUrl(url);
            childObj.setMenuPId(map.get("pid").toString());
            menuObj.addChild(childObj);
            return true;
        } else {
            for (int i = 0; i < menuObj.getChildCount(); i++) {
                boolean result = addMenuObj(menuObj.getChild(i), map);
                if (result)
                    return true;
            }
        }
        return false;
    }

    private static void printJsonTree(SystemMenu menuRoot,
                                      HttpServletResponse response) throws IOException {
        response.getWriter().println("[");
        for (int i = 0; i < menuRoot.getChildCount(); i++) {
            printMenuJsonTree(menuRoot.getChild(i), response);
            if (i != menuRoot.getChildCount() - 1)
                response.getWriter().println(",");
        }
        response.getWriter().println("]");
    }

    private static void printMenuJsonTree(SystemMenu menuObj,
                                          HttpServletResponse response) throws IOException {
        String id = menuObj.getMenuId();
        String text = menuObj.getMenuText();
        String href = menuObj.getMenuUrl();

        String temp = "";
        if (menuObj.getChildCount() == 0) {
            response.getWriter().println(
                    "{id: '" + id + "',text: '" + text + "',leaf: true,link:'"
                            + href + "'}");
            temp = "{id: '" + id + "',text: '" + text + "',leaf: true,link:'"
                    + href + "'}";
        } else {
            response.getWriter().println(
                    "{id: '" + id + "',text: '" + text
                            + "',leaf: false,expanded:true,children:");
            temp = "{id: '" + id + "',text: '" + text
                    + "',leaf: false,expanded:true,children:";
            printJsonTree(menuObj, response);
            response.getWriter().println("}");
        }
    }

    public SysMenuService getMenuService() {
        return menuService;
    }

    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

