package com.gtis.web.action;

import org.apache.struts2.ServletActionContext;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

/**
 * 系统配置页面
 * @author jiff
 *
 */
public class SysConfigAction {
	/**
	 * 
	 */
	private static final long serialVersionUID = 8321151070525915186L;
	PfConfigVo configVo;
	SysUserService userService;
	String message;
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	public String execute() throws Exception {
		String userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		configVo = userService.getConfigVo(userId);
		if (configVo==null){   //默认信息
			configVo=new PfConfigVo();
			configVo.setUserId(userId);
			configVo.setMessageAutoTime(5);
			configVo.setTaskAutoTime(2);
			configVo.setShowAllNewTask(true);
			configVo.setShowNewTaskHandle(true);
		}
		return Action.SUCCESS;
	}

	public String save() throws Exception {
//		String userId=configVo.getUserId();
//		if (newConfig.equals("1")){
//			userService.insertConfig(configVo);
//			newConfig="0";
//			message="添加成功！";
//		}else{
			userService.saveConfig(configVo);
			message="修改成功！";
//		}
		UserInfo infoObj=SessionUtil.getUserInfo(ServletActionContext.getRequest());
		infoObj.setConfig(configVo);
		return Action.SUCCESS;
	}

	public PfConfigVo getConfigVo() {
		return configVo;
	}

	public void setConfigVo(PfConfigVo configVo) {
		this.configVo = configVo;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

}
