package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.StuffService;
import com.gtis.plat.service.SysStuffService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfStuffFileVo;
import com.gtis.plat.vo.PfStuffInfoVo;
import com.gtis.rss.RssAction;
import com.gtis.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * @(#)StuffManageAction.java 2010-5-14 14:38:59
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					: 平台附件管理
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class StuffManageAction extends RssAction{
    private static final long serialVersionUID = -6957955419776336137L;

    /** 项目Id */
    private String proid;
    /** 任务Id */
    private String taskid;
    /** 文件中心根节点Id */
    private Integer rootId;
    private boolean disable=false;
    /** 文件中心节点访问令牌 */
    private String token;
    /** 访问参数 */
    private String params;
    //readonly
    private String readOnly;
    private PfStuffInfoVo info;
    private PfStuffFileVo file;
    /** 全局文件中心的表空间 */
    public static final String GLOBLE_STUFF = "GLOBLE_STUFF";
    /** 工作流附件在文件中心的表空间 */
    public static final String WORK_FLOW_STUFF = "WORK_FLOW_STUFF";
    /** 部门网盘在文件中心中的表空间 */
	public static final String ORGAN_STUFF =  "ORGAN_STUFF";

    /** 文件中心节点服务 */
	private NodeService nodeService;
    /** 附件管理服务 */
	private SysStuffService stuffService;
    /** 收件单 */
    private StuffService stuffService2;

    /**
     * 进入工作流附件
     * @return
     * @throws Exception
     */
	public String execute() throws Exception {
        //获得工作流附件工作流空间节点Id
		Space space = nodeService.getWorkSpace(WORK_FLOW_STUFF,true);
		Node prjNode = nodeService.getNode(space.getId(), proid,true);
		rootId = prjNode.getId();
        //获得工作流文件中心节点访问令牌
		token = nodeService.getToken(prjNode);
        //序列化访问中的参数
        params = JSONUtil.serialize(convertParameters(ServletActionContext.getRequest()));
        //获得工作流定义中的附件类型
		List<HashMap<String,String>> configMaps = stuffService.getStuffConfigByProId(proid);
		//创建附件类型
		for(Map<String,String> map : configMaps){
			nodeService.getNode(prjNode.getId(),map.get("stuffConfigName"),true);
		}
        
		return Action.SUCCESS;
	}

    /**
     * 部门文件柜
     * @return
     * @throws Exception
     */
    public String organ() throws Exception {
        //获得部门文件柜在文件中心中的空间
        Space space = nodeService.getWorkSpace(ORGAN_STUFF,true);
        //序列化访问中的参数
        params = JSONUtil.serialize(convertParameters(ServletActionContext.getRequest()));
        //获得当前登录用户的部门
        List<PfOrganVo> organList = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getLstOragn();
        //根据访问节点的Id
        Node node;
        if(organList.size() > 0){
            node = nodeService.getNode(space.getId(),organList.get(0).getOrganId(),true);
            token = nodeService.getToken(node);
            rootId = node.getId();
        }else{
            node = nodeService.getNode(space.getId(),"0",true);
            token = nodeService.getToken(node);
            rootId = node.getId();
        }
        
        return Action.SUCCESS;
    }

    /**
     * request 参数转换
     * @param request
     * @return
     */
    private Map<String, Object> convertParameters(HttpServletRequest request) {
        Map<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String) names.nextElement();
            String value = request.getParameter(name);
            Object v;
            try {
                v = Long.valueOf(value);
            } catch (NumberFormatException e) {
                if ("true".equalsIgnoreCase(value)) {
                    v = Boolean.TRUE;
                } else if ("false".equalsIgnoreCase(value)) {
                    v = Boolean.FALSE;
                } else {
                    v = value;
                }
            }
            params.put(name, v);
        }
        return params;
    }
    
	 /**
     * 全局文件柜
     * @return
     * @throws Exception
     */
    public String globle() throws Exception {
        Space space = nodeService.getWorkSpace(GLOBLE_STUFF,true);
        Node node = null;
        node = nodeService.getNode(space.getId(), StuffManageAction.class.getName(),true);

        rootId = node.getId();
        token = nodeService.getToken(node);
        params = JSONUtil.serialize(convertParameters(ServletActionContext.getRequest()));
        return Action.SUCCESS;
    }

    public String attrSave() throws Exception {
        if(info != null){
            stuffService2.save(info);
        }
        if(file != null){
            stuffService2.save(file);
        }
        return Action.NONE;
    }

    public String fileDel() throws Exception{
        file.setProId(proid);
        stuffService2.delete(file);
        return Action.NONE;
    }

    /**
     * 收件单
     * @return
     * @throws Exception
     */
    public String receive() throws Exception {
        List configMaps = stuffService.getStuffConfigByProId(proid);
        info = stuffService2.getStuffInfoByProId(proid);
        if(info == null){
            info = newStuffInfo(taskid,proid,configMaps);
        }

        return "receive";
    }

    /**
     * 添加收件类型
     * @return
     * @throws Exception
     */
    public String addFile() throws Exception{

        return "file";
    }

    private PfStuffInfoVo newStuffInfo(String taskId,String proId,List confList){
        PfStuffInfoVo stuffInfoVo = new PfStuffInfoVo();
        stuffInfoVo.setProId(proId);
        stuffInfoVo.setTaskId(taskId);
        List<PfStuffFileVo> fileList = new ArrayList<PfStuffFileVo>();
        if(confList != null){
            for(Object obj:confList){
                Map map = (HashMap)obj;
                PfStuffFileVo stuffFileVo = new PfStuffFileVo();
                stuffFileVo.setInfoId(stuffInfoVo.getInfoId());
                stuffFileVo.setProId(proid);
                stuffFileVo.setTaskId(taskid);
                if(map.get("stuffConfigNo") != null){
                    stuffFileVo.setNo(Integer.parseInt("" + map.get("stuffConfigNo")));
                }
                if(map.get("stuffConfigName") != null){
                    stuffFileVo.setStuffName("" + map.get("stuffConfigName"));
                }
                if(map.get("stuffConfigCount") != null){
                    stuffFileVo.setSCopies(Integer.parseInt("" + map.get("stuffConfigCount")));
                }
                if(map.get("stuffConfigRemark") != null){
                    stuffFileVo.setRemark("" + map.get("stuffConfigRemark"));
                }
                fileList.add(stuffFileVo);
            }
        }
        stuffInfoVo.setFileList(fileList);
        stuffService2.save(stuffInfoVo);
        return stuffInfoVo;
    }

    /**
     * rss源发布
     * @return
     * @throws Exception
     */
    public String rss() throws Exception {
        SplitParamImpl splitParam1=new SplitParamImpl();
        HashMap<String, Object> map=new HashMap<String, Object>();
        map.put("nodeName",proid);
        splitParam1.setQueryString("getFilesByNodeName");
        splitParam1.setQueryParam(map);
        super.setRssParam(splitParam1);
        return super.rss();
    }

    public SysStuffService getStuffService() {
		return stuffService;
	}
	public void setStuffService(SysStuffService stuffService) {
		this.stuffService = stuffService;
	}
	public NodeService getNodeService() {
		return nodeService;
	}
	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}
	public Integer getRootId() {
		return rootId;
	}
	public void setRootId(Integer rootId) {
		this.rootId = rootId;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public String getProid() {
		return proid;
	}
	public void setProid(String proid) {
		this.proid = proid;
	}
    public String getParams() {
        return params;
    }
    public void setParams(String params) {
        this.params = params;
    }
	public String getReadOnly() {
		return readOnly;
	}
	public void setReadOnly(String readOnly) {
		this.readOnly = readOnly;
	}
    public StuffService getStuffService2() {
        return stuffService2;
    }
    public void setStuffService2(StuffService stuffService2) {
        this.stuffService2 = stuffService2;
    }
    public String getTaskid() {
        return taskid;
    }
    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }
    public PfStuffInfoVo getInfo() {
        return info;
    }
    public void setInfo(PfStuffInfoVo info) {
        this.info = info;
    }
    public boolean isDisable() {
        return disable;
    }
    public void setDisable(boolean disable) {
        this.disable = disable;
    }
    public PfStuffFileVo getFile() {
        return file;
    }
    public void setFile(PfStuffFileVo file) {
        this.file = file;
    }
}
