package com.gtis.web.action;

import java.io.PrintWriter;
import java.util.HashMap;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysMessageAwokeService;
import com.gtis.plat.service.impl.SysNotifyRssBuilder;
import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import com.sun.syndication.feed.synd.SyndFeed;

import org.apache.struts2.json.JSONUtil;

public class NotifyManageAction extends ActionSupport implements ServletRequestAware,ServletResponseAware{
	
	/**
	 * 
	 */
	
	private SyndFeed  feed;
	private SysNotifyRssBuilder ressBuilder;
	
	private static final long serialVersionUID = 1L;
	private NodeService nodeService;
	private Integer nodeId;
    private String token;
    ServletResponse response;
    ServletRequest request;
    
    
    private static final String NOTIFY_STUFF = "通知附件";
    SplitParam splitParam;
    PfMessageSendAwokeVo msgAwokeVo;
    PfMessageAcceptAwokeVo msgAcceptAwokeVo;
    SysMessageAwokeService msgAwokeService;
    
	private String sendDateBegin;
	private String sendDateEnd;
	private String notifyStadus;
	private String msgAwokeId;
	private String msgAcceptAwokeId;
	private String flag;
	
	//删除
	private String sendIdList;
	private String acceptIdList;

	@Override
	public String execute() throws Exception {
		
		if(this.msgAwokeId!=null&&!this.msgAwokeId.equals(""))
		{
			msgAwokeVo=msgAwokeService.getSendAwoke(this.msgAwokeId);
		}
		if(msgAwokeVo!=null){
			Space space = nodeService.getWorkSpace(NOTIFY_STUFF);
    		Node msgNode = nodeService.getNode(space.getId(), msgAwokeVo.getMessageAwokeId());
    		nodeId = msgNode.getId();
    		token = nodeService.getToken(msgNode);
			
		}else{
			msgAwokeVo=new PfMessageSendAwokeVo();
	    	Space space = nodeService.getWorkSpace(NOTIFY_STUFF,true);
	    	Node msgNode = null;
	    	msgAwokeVo.setMessageAwokeId(UUIDGenerator.generate());
	    	msgNode = nodeService.getNode(space.getId(),msgAwokeVo.getMessageAwokeId(),true);
	    	nodeId = msgNode.getId();
	    	token = nodeService.getToken(msgNode);
		}

    	return Action.SUCCESS;
    }
    
    public String send() throws Exception {
    	PfMessageSendAwokeVo vo=msgAwokeService.getSendAwoke(msgAwokeVo.getMessageAwokeId());
    	HttpServletRequest request = ServletActionContext.getRequest();
    	msgAwokeVo.setUserId(SessionUtil.getUserId(request));// 发送人ID
    	msgAwokeVo.setUserName(SessionUtil.getUserName(request));// 发送人

		boolean isok = msgAwokeService.insertNotifyAwoke(msgAwokeVo);
		
		if(isok){
			request.setAttribute("info", "");
		}else {
			request.setAttribute("info", "上传失败！");
		}
		return "SEND_NOTIFY";
    }
    
    
    
    public String acceptAwokeList() throws Exception {
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("queryacceptnotifylist");
		HashMap<String,String> paramsMap = new HashMap<String,String>();
		
		if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0"))
		{
			paramsMap.put("acceptUserId",SessionUtil.getUserId(ServletActionContext.getRequest()));
		}
		
		if(notifyStadus != null && "1".equals(notifyStadus)){
			paramsMap.put("notifyStadus",notifyStadus);
		}
		splitParam1.setQueryParam(paramsMap);
		splitParam=splitParam1;
		
		return "ACCEPT_NOTIFY_LIST";
    }
    
    public String sendAwokeList() throws Exception{
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("querysendnotifylist");
		HashMap<String,String> paramsMap=new HashMap<String,String>();
		if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0"))
		{
			paramsMap.put("sendUserId", SessionUtil.getUserId(ServletActionContext.getRequest()));
		}
		splitParam1.setQueryParam(paramsMap);
		splitParam = splitParam1;
		
		return "SEND_NOTIFY_LIST";
    }
    
    public String detail() throws Exception{
    	if("accept".equals(flag)){
    		String tempMsgAcceptId = this.msgAcceptAwokeId;
    		if(tempMsgAcceptId != null){
    			msgAcceptAwokeVo = msgAwokeService.getAcceptAwoke(tempMsgAcceptId);
    			msgAwokeVo = msgAcceptAwokeVo.getMessageSendAwokeVo();
    			msgAwokeService.updateNotifyStatus(tempMsgAcceptId);
    		}
    	}else if("send".equals(flag)){
    		msgAwokeVo = msgAwokeService.getSendAwoke(this.msgAwokeId);
    	}
    	
    	if(msgAwokeVo != null){
    		try{
        		Space space = nodeService.getWorkSpace(NOTIFY_STUFF);
        		Node msgNode = nodeService.getNode(space.getId(), msgAwokeVo.getMessageAwokeId());
        		nodeId = msgNode.getId();
    		}catch(NodeNotFoundException e){
        		e.printStackTrace();
				//request.setAttribute("message", "附件列表获取失败！");
    		}
    	}
    	return "NOTIFY_DETAIL";
    }
    
    public String restore() throws Exception{
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("querymsgrestoreawokelist");
		HashMap<String,String> paramsMap=new HashMap<String,String>();
		paramsMap.put("messageAwokeId",this.msgAwokeId);
		splitParam1.setQueryParam(paramsMap);
		splitParam = splitParam1;
    	return "NOTIFY_RESTORE_LIST";
    }
    
    public String del_sendAwoke() throws Exception{
    	String result="";
		String Msg ="";
		String[] sendIdListStr=sendIdList.split(";");
		String readedCount = null;
		int delSuccessCount=0;
		int delFailCount=0;
		HashMap<String,String> resultObj = new HashMap<String,String>();
		try
		{
			//判断该条通知是否被阅读，如果被阅读过，则不能删除
			
			for(int i=0;i<sendIdListStr.length;i++)
			{
				if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0")){
					readedCount=msgAwokeService.getReadedAwokeByAwokeId(sendIdListStr[i].toString());
				}
				if(readedCount==null||readedCount.equals("0")){
					
					//删除发送消息业务数据
					msgAwokeService.delSendAwokeById(sendIdListStr[i].toString());
					//删除附件
					Space space = nodeService.getWorkSpace(NOTIFY_STUFF,true);
					Node node = nodeService.getNode(space.getId(),sendIdListStr[i].toString(),true);
					nodeId = node.getId();
					nodeService.remove(nodeId);
					delSuccessCount++;
				}else{
					delFailCount++;
				}
			}
			if(delFailCount>0&&delSuccessCount>0){
				Msg="成功删除"+delSuccessCount+"条通知,有"+delFailCount+"条通知不能删除！";
			}else if(delSuccessCount>0&&delFailCount==0){
				Msg="成功删除"+delSuccessCount+"条通知！";
			}else{
				Msg="该通知已被查看，无法删除！";
			}
			result="true";
		}
		catch(Exception ex)
		{
			Msg="通知删除失败！";
			result="false";
		}
		
		response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
		resultObj.put("result", result);
		resultObj.put("msg", Msg);
        out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();
		return Action.NONE;
    }
    
    public String del_acceptAwoke() throws Exception{
    	String result="";
		String Msg ="";
		String[] acceptIdListStr=acceptIdList.split(";");
		HashMap<String,String> resultObj = new HashMap<String,String>();
		try
		{
			for(int i=0;i<acceptIdListStr.length;i++)
			{
				//删除接收信息业务数据
				msgAwokeService.delAcceptAwokeById(acceptIdListStr[i].toString());
			}		
			Msg="通知删除成功！";
			result="true";
		}
		catch(Exception ex)
		{
			Msg="通知删除失败！";
			result="false";
		}
		response.setContentType("text/html;charset=UTF-8");
		PrintWriter out=response.getWriter();
		resultObj.put("result", result);
		resultObj.put("msg", Msg);
		out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();
		return Action.NONE;
    }
    
    
    public String rss() throws Exception {
        feed = ressBuilder.getFeed(0,10);
        return "RSS";    
    }
    
    public String readMsg() throws Exception{
    	return "";
    }
    
	public NodeService getNodeService() {
		return nodeService;
	}

	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}

	public Integer getNodeId() {
		return nodeId;
	}

	public void setNodeId(Integer nodeId) {
		this.nodeId = nodeId;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getSendDateBegin() {
		return sendDateBegin;
	}

	public void setSendDateBegin(String sendDateBegin) {
		this.sendDateBegin = sendDateBegin;
	}

	public String getSendDateEnd() {
		return sendDateEnd;
	} 

	public void setSendDateEnd(String sendDateEnd) {
		this.sendDateEnd = sendDateEnd;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}


	public void setServletRequest(HttpServletRequest request) {
		this.request = request;
	}

	public void setServletResponse(HttpServletResponse response) {
		this.response=response;
	}
	public String getNotifyStadus() {
		return notifyStadus;
	}

	public void setNotifyStadus(String notifyStadus) {
		this.notifyStadus = notifyStadus;
	}

	public String getMsgAwokeId() {
		return msgAwokeId;
	}

	public void setMsgAwokeId(String msgAwokeId) {
		this.msgAwokeId = msgAwokeId;
	}

	public ServletResponse getResponse() {
		return response;
	}

	public void setResponse(ServletResponse response) {
		this.response = response;
	}

	public ServletRequest getRequest() {
		return request;
	}

	public void setRequest(ServletRequest request) {
		this.request = request;
	}

	public PfMessageSendAwokeVo getMsgAwokeVo() {
		return msgAwokeVo;
	}

	public void setMsgAwokeVo(PfMessageSendAwokeVo msgAwokeVo) {
		this.msgAwokeVo = msgAwokeVo;
	}

	public PfMessageAcceptAwokeVo getMsgAcceptAwokeVo() {
		return msgAcceptAwokeVo;
	}

	public void setMsgAcceptAwokeVo(PfMessageAcceptAwokeVo msgAcceptAwokeVo) {
		this.msgAcceptAwokeVo = msgAcceptAwokeVo;
	}

	public SysMessageAwokeService getMsgAwokeService() {
		return msgAwokeService;
	}

	public void setMsgAwokeService(SysMessageAwokeService msgAwokeService) {
		this.msgAwokeService = msgAwokeService;
	}

	public String getSendIdList() {
		return sendIdList;
	}

	public void setSendIdList(String sendIdList) {
		this.sendIdList = sendIdList;
	}

	public String getAcceptIdList() {
		return acceptIdList;
	}

	public void setAcceptIdList(String acceptIdList) {
		this.acceptIdList = acceptIdList;
	}

	public String getMsgAcceptAwokeId() {
		return msgAcceptAwokeId;
	}

	public void setMsgAcceptAwokeId(String msgAcceptAwokeId) {
		this.msgAcceptAwokeId = msgAcceptAwokeId;
	}

	public SyndFeed getFeed() {
		return feed;
	}

	public void setFeed(SyndFeed feed) {
		this.feed = feed;
	}

	public SysNotifyRssBuilder getRessBuilder() {
		return ressBuilder;
	}

	public void setRessBuilder(SysNotifyRssBuilder ressBuilder) {
		this.ressBuilder = ressBuilder;
	}
	
}
