package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.plat.vo.PfConfigVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexAction {
	String userName;
	String time;
	PfConfigVo configVo;
    List<PfMenuVo> menus;
    List<PfMenuVo> leaveMenus;
    SysMenuService menuService;
    private boolean useSimpleMenu;
    String title;
    SysUserService sysUserService;
    String userPost;
    //    是否只有首页portal换成cms
    String onlyIndexCms;

    public String getTitle() {
        return title;
    }

    public boolean isUseSimpleMenu() {
        return useSimpleMenu;
    }

    public String getSolrUrl() {
        return AppConfig.getProperty("solr.url");
    }

    public void setUseSimpleMenu(boolean useSimpleMenu) {
        this.useSimpleMenu = useSimpleMenu;
    }

    public void setMenuService(SysMenuService menuService) {
		this.menuService = menuService;
	}
    public List<PfMenuVo> getMenus() {
        return menus;
    }
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getTime() {
		return time;
	}

	public void setTime(String time) {
		this.time = time;
	}

    public SysUserService getSysUserService() {
        return sysUserService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public String getUserPost() {
        return userPost;
    }

    public void setUserPost(String userPost) {
        this.userPost = userPost;
    }

    public String index1() throws Exception {
        execute();
        return Action.SUCCESS;
    }

	public String execute() throws Exception {
		time= SessionUtil.getCurTime();
		userName=SessionUtil.getCurrentUser().getUsername();
		configVo=SessionUtil.getCurrentUser().getConfig();
        title= AppConfig.getProperty("platform.title");
        onlyIndexCms=AppConfig.getProperty("cms.only.index");
        String userid=SessionUtil.getCurrentUserId();
        if(StringUtils.isNotBlank(userid)){
            PfUserVo pfUserVo=sysUserService.getUserVo(userid);
            if(pfUserVo!=null)
                userPost=pfUserVo.getUserPost();
        }

        if (StringUtils.isBlank(title))
            title="国土资源电子政务平台";
        if (isEnterFromCms())
            return "index1";
        else
		    return Action.SUCCESS;
	}

    /**
     * 是否使用cms的界面
     * @return
     */
    private boolean  isEnterFromCms(){
        String result= AppConfig.getProperty("cms.enable");
        if ("true".equalsIgnoreCase(result))
            return true;
        else
            return false;
    }

	public PfConfigVo getConfigVo() {
		return configVo;
	}

	public void setConfigVo(PfConfigVo configVo) {
		this.configVo = configVo;
	}

    public List<PfMenuVo> getLeaveMenus() {
        return leaveMenus;
    }

    public void setLeaveMenus(List<PfMenuVo> leaveMenus) {
        this.leaveMenus = leaveMenus;
    }

    public String getOnlyIndexCms() {
        return onlyIndexCms;
    }

    public void setOnlyIndexCms(String onlyIndexCms) {
        this.onlyIndexCms = onlyIndexCms;
    }
}
