package com.gtis.web.action;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Vector;
import java.text.*;

import javax.imageio.ImageIO;

import com.gtis.plat.service.SysUserService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.web.SessionUtil;

/**
 * 显示数据库中的签名图片，将图片流写出 （1.自动签名 2.签名表中的图片）
 * 
 * @author jiff
 * 
 */
public class FormSignImageAction {
	/*
	 * Generated Methods
	 */
	private static final org.apache.commons.logging.Log log = LogFactory
			.getLog(FormSignImageAction.class);
	private static final String CONTENT_TYPE_IMAGE = "image/jpeg";
	private static final String CONTENT_TYPE = "text/html; charset=utf-8";
	// private String type;
	private String signid;
	private String signdate;
	
	SysFormDao formDao;
    SysUserService userService;

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public SysFormDao getFormDao() {
		return formDao;
	}

	public void setFormDao(SysFormDao formDao) {
		this.formDao = formDao;
	}

	public String getSignid() {
		return signid;
	}

	public void setSignid(String signid) {
		this.signid = signid;
	}

	/**
	 * Method execute
	 * 
	 * @return ActionForward
	 */
	public String execute() throws Exception {
		// 设置响应的类型
		ServletActionContext.getResponse().setContentType(CONTENT_TYPE_IMAGE);
		PfUserSignVo signVo = formDao.getSign(signid);
        if(signVo!=null){
           if (signVo.getSignType()!=null && signVo.getSignType().equals("1")) {
                /*String userId = SessionUtil.getUserId(ServletActionContext
                        .getRequest());*/
                String userId = signVo.getUserId();
                signVo = formDao.getSignUserImage(userId);
            }
            if (signVo.getSignImage() != null) {
                ServletActionContext.getResponse().getOutputStream().write(
                        signVo.getSignImage(), 0, signVo.getSignImage().length);
                ServletActionContext.getResponse().getOutputStream().flush();
                ServletActionContext.getResponse().getOutputStream().close();
            }
        }

		return null;
	}

	public String save() throws Exception {
		SAXReader reader = new SAXReader();
		org.dom4j.Document document = null;
		ServletActionContext.getResponse().setContentType(CONTENT_TYPE);

		document = reader.read(ServletActionContext.getRequest()
				.getInputStream());
		if (document != null) {
			String userId = SessionUtil.getCurrentUserId();
			String userName = SessionUtil.getCurrentUser().getUsername();
			//SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
			Element root = document.getRootElement();
            //判断是否传入了userid
            if (StringUtils.isNotBlank(root.valueOf("@userid"))){
                userId= root.valueOf("@userid");
                userName=  userService.getUserVo(userId).getUserName();
            }
			PfUserSignVo signVo = new PfUserSignVo();
			signVo.setSignId(UUIDGenerator.generate());
			signVo.setUserId(userId);
			//signVo.setSignDate(df.parse(signdate));
			signVo.setSignDate(CommonUtil.formateDateToStr(signdate));
			signVo.setSignName(userName);
			if (root.valueOf("@autopic").equals("true")) { // 保存自动签名
				signVo.setSignType("1");
				formDao.createSign(signVo);
				PrintResult(signVo.getSignId() + "|" + signVo.getSignName()
						+ "|" + signdate);
			} else { // 手动签名
				String pnts = root.getText();
				// //如果pnts为空则删除原来的签名
				if (pnts.trim().equals("")) {
					// signId=root.valueOf("@signid");
					// //sign.DeleteSign(signId);
					PrintResult("||");
				} else {
					signVo.setSignType("2");
					BufferedImage srcImage = drawPic(pnts);
					ByteArrayOutputStream bb = new ByteArrayOutputStream(
							srcImage.getData().getDataBuffer().getSize());
					ImageIO.write(srcImage, "jpg", bb);
					signVo.setSignImage(bb.toByteArray());
					formDao.createSign(signVo);
					PrintResult(signVo.getSignId() + "|" + userName + "|"
							+ signdate);
				}
			}
		}

		return null;
	}

	public void PrintResult(String reponseText) {
		try {
			ServletActionContext.getResponse().setCharacterEncoding("utf-8");
			ServletActionContext.getResponse().setContentType(CONTENT_TYPE);
			PrintWriter out = ServletActionContext.getResponse().getWriter();
			out.println(reponseText);
			out.flush();
			out.close();
		} catch (Exception e) {
			log.error(e.getMessage());
		}
	}

	@SuppressWarnings("unchecked")
	private BufferedImage drawPic(String strPoint) {
		boolean flage = true;
		Graphics2D graphic = null;
		BufferedImage bfimg = new BufferedImage(400, 160,
				BufferedImage.TYPE_INT_RGB);
		BasicStroke bs = new BasicStroke((float) 10.0);

		graphic = bfimg.createGraphics();
		graphic.setStroke(bs);
		graphic.setColor(new Color(255, 255, 255));
		graphic.fillRect(0, 0, 400, 160);
		int[] xPoints = new int[10000];
		int[] yPoints = new int[10000];
		int nPoints = 0, vNum = 0;

		int i = 0, j = 0, k = 0;
		Vector vctline = new Vector();
		String strline;
		strPoint = "|" + strPoint;
		for (i = 0; i < strPoint.length(); i++) {
			String line = new String();
			if (strPoint.charAt(i) != '|') {
				j = i + 1;
				k = 0;
				while (j < strPoint.length() && strPoint.charAt(j) != '|') {
					line = line + strPoint.charAt(j);
					j++;
					k++;
				}
				i = i + k;
				k = 0;
				vctline.add(vNum++, line);
			}
		}
		k = 0;
		for (i = 0; i < vctline.size(); i++) {
			strline = vctline.get(i).toString();
			String strfig = "";
			int p = 0;
			for (j = 0; j < strline.length(); j++) {
				if (strline.charAt(j) == ',') {
					p = j - 1;
					strfig = "";
					while (flage && strline.charAt(p) >= '0'
							&& strline.charAt(j) <= '9') {
						strfig = strline.charAt(p) + strfig;
						p--;
						if (p < 0) {
							p = 0;
							flage = false;
						}
					}
					flage = true;
					xPoints[k] = Integer.parseInt(strfig);
					p = j + 1;
					strfig = "";
					while (flage && strline.charAt(p) >= '0'
							&& strline.charAt(j) <= '9') {
						strfig = strfig + strline.charAt(p);
						p++;
						if (p >= strline.length()) {
							p = 0;
							flage = false;
						}
					}
					flage = true;
					yPoints[k] = Integer.parseInt(strfig);
					k++;
					nPoints = k;
				}
			}
			k = 0;
			if (nPoints > 0) {
				graphic.setColor(new Color(0, 0, 0));
				graphic.drawPolyline(xPoints, yPoints, nPoints);
				nPoints = 0;
			}
		}
		graphic.setColor(new Color(0, 0, 0));
		graphic.drawPolyline(xPoints, yPoints, nPoints);
		return bfimg;
	}

	public String getSigndate() {
		return signdate;
	}

	public void setSigndate(String signdate) {
		this.signdate = signdate;
	}
}