package com.gtis.web.action;

import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import com.gtis.plat.form.FormInstanceFactory;
import com.gtis.plat.form.FormScript;
import com.opensymphony.xwork2.Action;



/**
 * 处理表单的保存 传入dfid表示新建表单的保存 传入ifid表示已有表单的保存
 * 
 * @author jiff
 * 
 */
public class FormSaveAction {
	private static final org.apache.commons.logging.Log log = LogFactory
			.getLog(FormSaveAction.class);
	FormInstanceFactory instanceFactory;
	String proid;
	String dfid;
	private String paramString;
	
	public String getProid() {
		return proid;
	}
	public void setProid(String proid) {
		this.proid = proid;
	}
	public String getDfid() {
		return dfid;
	}
	public void setDfid(String dfid) {
		this.dfid = dfid;
	}
	public FormInstanceFactory getInstanceFactory() {
		return instanceFactory;
	}
	public void setInstanceFactory(FormInstanceFactory instanceFactory) {
		this.instanceFactory = instanceFactory;
	}
	public String execute() throws Exception {
		HttpServletRequest request=ServletActionContext.getRequest();
		try {
			HashMap param = null;
			if (StringUtils.isNotBlank(paramString)) {
				try {
					String json = java.net.URLDecoder.decode(paramString, "utf-8");
					param = (HashMap)JSONUtil.deserialize(json);
				} catch (Exception e) {
					log.error("查询参数配置格式(json格式{'':'','':''})有误："+paramString);
				}
			}
			boolean saveOk=instanceFactory.saveFormInstance(request.getParameterMap(),dfid,proid,param);
			if (saveOk){
				request.setAttribute("info", "saveOk()");
				FormScript.runSave(request.getParameterMap(),dfid,proid);
			}else
				request.setAttribute("info", "saveFail()");
		} catch (Exception e) {
			log.error(e);
			request.setAttribute("info", "saveFail()");
		}
		if (request.getParameter("exit")!=null && request.getParameter("exit").equals("true"))   //窗体退出保存，不用返回 
			return Action.NONE;
		else
			return Action.SUCCESS;
	}
	public String getParamString() {
		return paramString;
	}
	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
}