package com.gtis.web.action;

import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.form.FormInstanceFactory;
import com.gtis.plat.form.FormModelFactory;
import com.gtis.plat.form.print.XMLBuildHelper;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.web.sign.SignUitl;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import java.awt.image.BufferedImage;
import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;

public class FormPrintAction extends ActionSupport{

	public final static String DATA_TYPE_XML="xml";
	public final static String DATA_TYPE_FR3="fr3";
	public final static String DATA_TYPE_SIGNATURE="signature";

	private FormInstanceFactory instanceFactory;
	private String dfid;
	private String proid;
	private String datatype;
	private String signid; //签名表主键
	private SysFormDao formDao;
	private String paramString;
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public String  execute() throws Exception {

		if (datatype.equalsIgnoreCase(DATA_TYPE_XML)){
			buildXmlDataSet() ;
		}else if (datatype.equalsIgnoreCase(DATA_TYPE_FR3)){
			buildFr3DataSet() ;
		}else if (datatype.equalsIgnoreCase(DATA_TYPE_SIGNATURE)){
			buildSignatureDataSet();
		}
		
		return Action.NONE;
	}
	
	public void buildFr3DataSet() throws IOException{
		 
		ServletActionContext.getResponse().setContentType("application/x-msdownload");
		ServletActionContext.getResponse().setHeader("Content-Disposition",
                           "attachment; filename="+String.valueOf(Calendar.getInstance().getTimeInMillis()));

		ServletOutputStream out = ServletActionContext.getResponse().getOutputStream();
//		PfFormDefineVo formDefineVo = formDao.getFormPrint(dfid);
		byte[] formPrintBytes = FormModelFactory.getFormModel(dfid).getFormDefineVo().getFormPrint();
		if (formPrintBytes == null){
			System.out.println("报表模板路径为空!!!");
		}else{
			//如果为fr3文件路径
			if(formPrintBytes.length <= 250){
				String path = ServletActionContext.getServletContext().getRealPath(new String(formPrintBytes));
				InputStream inputStream = new FileInputStream(path);
				int bytesRead;
				byte[] buf = new byte[1000]; //4K buffer
				while((bytesRead = inputStream.read(buf)) != -1){
				   out.write(buf, 0, bytesRead);
				}
				out.flush();
				out.close();
			}else {//如果为fr3文件
                InputStream inputStream = new ByteArrayInputStream(formPrintBytes);
                IOUtils.copy(inputStream,out);
//				InputStream inputStream = new ByteArrayInputStream(formPrintBytes);
//				int bytesRead;
//				byte[] buf = new byte[1000]; //4K buffer
//				while((bytesRead = inputStream.read(buf)) != -1){
//				   out.write(buf, 0, bytesRead);
//				}
//				out.flush();
//				out.close();
			}
		}
	}
	
    /** *//**
     * 文件转化为字节数组
     * @Author wh
     * @EditTime 2007-8-13 上午11:45:28
     */
	public  byte[] getBytesFromFile(File file) throws IOException {
		long len = file.length();
		byte[] bytes = new byte[(int) len];

		BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
		int r = bufferedInputStream.read(bytes);
		if (r != len) {
			throw new IOException("====读取文件不正确!====");
		}
		bufferedInputStream.close();

		return bytes;
	}

	
	/**
	 * 构造签名图片二进制数据流
	 * @throws IOException
	 */
	public void buildSignatureDataSet() throws Exception {
		ServletActionContext.getResponse().setContentType("image/jpeg");
		ServletActionContext.getResponse().setHeader("Content-Disposition",
                           "attachment; filename="+String.valueOf(Calendar.getInstance().getTimeInMillis()));

		//ServletOutputStream out = ServletActionContext.getResponse().getOutputStream();
	
		PfUserSignVo userSign = formDao.getSign(signid);
		if (userSign != null) {
			if(userSign.getSignType() != null && "1".equals(userSign.getSignType())){
				//自动签名
				PfUserSignVo autoUserSign =formDao.getSignUserImage(userSign.getUserId());
				
				if(autoUserSign.getSignImage() == null){
//					System.out.println("=================>image length = 0");
                    //如果签名图片不存在就生成一个
                    SignUitl.BuildSignImage(userSign.getSignName(),  ServletActionContext.getResponse().getOutputStream());
				}else{
					byte[] imageByte = autoUserSign.getSignImage();
	                BufferedImage image=ImageIO.read(new ByteArrayInputStream(imageByte));
	                ImageIO.write(image, "jpg", ServletActionContext.getResponse().getOutputStream());
				}
			}else {
		    //手动签名
				if(userSign.getSignImage() == null){
					System.out.println("=================>image length = 0");
				}else{
					IOUtils.write(userSign.getSignImage(), ServletActionContext.getResponse().getOutputStream());
				}
			}
		}
        

		//out.flush();
		//out.close();
	}

//    public static byte[] transferToJpeg(byte[] imageByteArray) throws IOException {
//        String type = "";
//        ByteArrayInputStream bais = null;
//        MemoryCacheImageInputStream mcis = null;
//        try {
//            bais = new ByteArrayInputStream(imageByteArray);
//            mcis = new MemoryCacheImageInputStream(bais);
//            Iterator itr = ImageIO.getImageReaders(mcis);
//            if (itr.hasNext()) {
//                ImageReader reader = (ImageReader) itr.next();
//                if (reader instanceof JPEGImageReader) {
//                    type = "jpeg";
//                    return imageByteArray;
//                } else {
//
//                    try {
//            			InputStream in = new ByteArrayInputStream(imageByteArray);
//                        BufferedImage image = ImageIO.read(in);
//                        BufferedImage thumbImage = new BufferedImage(image.getWidth(), image.getHeight(), BufferedImage.TYPE_INT_RGB);
//                        Graphics2D graphics2D = thumbImage.createGraphics();
//                        graphics2D.setBackground(Color.white);
//                        graphics2D.drawImage(image, 0, 0, Color.white, null);
//                        ByteArrayOutputStream sout = new ByteArrayOutputStream();
//                        ImageIO.write(image, "jpg", sout);
//
//
////                        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(sout);
////                        JPEGEncodeParam param = encoder
////                                .getDefaultJPEGEncodeParam(thumbImage);
////                        int quality = Math.max(0, Math.min(650, 100));
////                        param.setQuality((float) quality / 100.0f, false);
////                        encoder.setJPEGEncodeParam(param);
////                        encoder.encode(thumbImage, param);
//                        sout.close();
//                        return sout.toByteArray();
//                    } catch (java.io.IOException ioe) {
//                        ioe.printStackTrace();
//                        return    imageByteArray;
//                    }
//                }
//            } else {
//                return imageByteArray;
//            }
//
//        } catch (Exception ex) {
//            ex.printStackTrace();
//            return   imageByteArray;
//        }
//
//    }


//    /**
//     * 生成输出流
//     * @param inputstream
//     * @return
//     */
//	public static OutputStream getOutputStream(InputStream inputstream) {
//		InputStream input = inputstream; // 输入得流
//		ByteArrayOutputStream baos = new ByteArrayOutputStream();
//		try {
//			int count = -1;
//			count = input.read();
//			while (count != -1) {
//				baos.write(count);
//				count = input.read();
//			}
//			baos.flush();
//			baos.close();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return baos;
//	}
	
	/**
	 * 获取Blob数据
	 * @param conn
	 * @param strTableName
	 * @param strColumnName
	 * @param strKeyName
	 * @param strKeyValue
	 * @param sos
	 * @throws Exception
	 */
	public static void getBlobData(Connection conn, String strTableName,
			String strColumnName, String strKeyName, String strKeyValue,
			OutputStream sos) throws Exception {
		Connection con = null;
		PreparedStatement ps = null;
		ResultSet resultset = null;

		try {
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append(" SELECT " + strColumnName + " FROM " + strTableName);
			sbSQL.append(" WHERE " + strKeyName + "='" + strKeyValue + "' ");


			ps = con.prepareStatement(sbSQL.toString());
			resultset = ps.executeQuery();
			while (resultset.next()) {
				InputStream inStream = resultset.getBinaryStream(strColumnName);
//				OutputStream out_ = getOutputStream(is1);
//				ByteArrayOutputStream mather = (ByteArrayOutputStream) out_;
//				InputStream saveStream = new ByteArrayInputStream(mather.toByteArray());

				byte[] buf = new byte[2048];
				if (inStream != null) {
					try {
						int i = 0;
						int num=0;
						while ((num=inStream.read(buf)) > 0) {
							i++;
							sos.write(buf, 0, num);
						}
						if (i > 0) {
							return;
						} else {
							sos = null;
							return;
						}
					} catch (Exception e) {
						e.printStackTrace();
						throw e;
					} finally {
						inStream.close();
					}
				}
			}
		} catch (IOException ex) {
			throw ex;
		} finally {
			if (ps != null) {
				ps.close();
			}
			if (resultset != null) {
				resultset.close();
			}
		}
	}

    public static String getClientIP(HttpServletRequest request) {
        String xForwardedFor;
        xForwardedFor = StringUtils.trimToNull(request.getHeader("$wsra"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull(request.getHeader("X-Real-IP"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull(request.getHeader("X-Forwarded-For"));
        if (xForwardedFor != null) {
            int spaceIndex = xForwardedFor.indexOf(',');
            if (spaceIndex > 0) {
                return xForwardedFor.substring(0, spaceIndex);
            } else {
                return xForwardedFor;
            }
        }
        return request.getRemoteAddr();
    }
	
	
	/**
	 * 生成xml流
	 * @throws Exception
	 */
	public void buildXmlDataSet() throws Exception{
		HashMap param = null;
		if (StringUtils.isNotBlank(paramString)) {
			try {
				String json = java.net.URLDecoder.decode(paramString, "utf-8");
				param = (HashMap)JSONUtil.deserialize(json);
			} catch (Exception e) {
				System.out.println("查询参数配置格式(json格式{'':'','':''})有误："+paramString);
			}
		}
			XMLBuildHelper XMLbh = new XMLBuildHelper();
		
			ServletActionContext.getRequest().setCharacterEncoding("gbk");
			ServletActionContext.getResponse().setContentType("text/xml; charset=gbk");
			
			//String host = ServletActionContext.getRequest().getRemoteHost();
			//String host = getClientIP(ServletActionContext.getRequest());
			//System.out.println("getLocalAddr:"+ServletActionContext.getRequest().getLocalAddr());
			//String port =   ServletActionContext.getRequest().getLocalPort() + "";
			//String port =   ServletActionContext.getRequest().getServerPort() + "";
			//String context = ServletActionContext.getRequest().getContextPath();
			//String httpurl = "http://" + host +":"+ port + context;
			ServletActionContext.getResponse().getWriter().append(
				XMLbh.buildXmlDataSet(ServletActionContext.getRequest(),
						ServletActionContext.getResponse(), dfid, proid,param));

			PrintWriter out = ServletActionContext.getResponse().getWriter();
			
			out.flush();
			out.close();
	}

	public String getDfid() {
		return dfid;
	}

	public void setDfid(String dfid) {
		this.dfid = dfid;
	}

	public String getProid() {
		return proid;
	}

	public void setProid(String proid) {
		this.proid = proid;
	}



	public String getDatatype() {
		return datatype;
	}

	public void setDatatype(String datatype) {
		this.datatype = datatype;
	}

	public FormInstanceFactory getInstanceFactory() {
		return instanceFactory;
	}

	public void setInstanceFactory(FormInstanceFactory instanceFactory) {
		this.instanceFactory = instanceFactory;
	}

	public String getSignid() {
		return signid;
	}

	public void setSignid(String signid) {
		this.signid = signid;
	}

	public SysFormDao getFormDao() {
		return formDao;
	}

	public void setFormDao(SysFormDao formDao) {
		this.formDao = formDao;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	
	
	
}
