package com.gtis.web.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.service.SysExceptionService;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.Reader;
import java.sql.Clob;
import java.util.*;

public class ExceptionStatAction extends ActionSupport{

	private SysExceptionService ses;
	public List<HashMap> userExceptionStat;
	public List<HashMap> orgExceptionStat;
	public String statBeginTime;
	public String statEndTime;
	public String orgId;
	public List<HashMap> organs;
	public String orgName;
	public String userId;
	public int type;
	
	/**
	 * 获取异常详细
	 * @return
	 * @throws Exception
	 */
	public String detail()throws Exception{
		HashMap condition=new HashMap();
		Date beginTime=null;
		Date endTime=null;
        if(StringUtils.isBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			Calendar d=Calendar.getInstance();
			d.setTime(new Date());
			endTime=d.getTime();
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isBlank(statBeginTime) && StringUtils.isNotBlank(statEndTime)){
			endTime=CommonUtil.formateDateToStr(statEndTime);
			Calendar d=Calendar.getInstance();
			d.setTime(endTime);
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isNotBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
			endTime=new Date(System.currentTimeMillis());
		}else{
			endTime=CommonUtil.formateDateToStr(statEndTime);
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
		}
		condition.put("BEGINTIME",beginTime);
		condition.put("ENDTIME", endTime);
		condition.put("USER_ID", userId);
		condition.put("TYPE", type);
		List<HashMap> list=ses.getDetailStat(condition);
		List<HashMap> list2=new ArrayList();
		HashMap temp=null;
		String descri=null;
		for(HashMap obj:list){
			temp=new HashMap();
			temp.put("WORKFLOW_NAME",obj.get("WORKFLOW_NAME"));
			temp.put("WORKFLOW_INSTANCE_NAME", obj.get("WORKFLOW_INSTANCE_NAME"));
			temp.put("ACTIVITY_NAME",obj.get("ACTIVITY_NAME"));
			temp.put("USER_NAME", obj.get("USER_NAME"));
			temp.put("EXCEPTION_REC_TIME", obj.get("EXCEPTION_REC_TIME"));
			descri=descXML(obj,type,obj.get("USER_NAME").toString());
			temp.put("DESCRIPT", descri);
			list2.add(temp);
			temp=null;
		}
		HashMap map=new HashMap();
		map.put("root", list2);
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(
				JSONUtil.serialize(map));
		return Action.NONE;
	}
	
	
	
	/**
	 * 根据人员统计异常
	 * @return
	 * @throws Exception
	 */
	public String statUserException() throws Exception {
		HashMap condition=new HashMap();
		Date beginTime=null;
		Date endTime=null;
        if(StringUtils.isBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			Calendar d=Calendar.getInstance();
			d.setTime(new Date());
			endTime=d.getTime();
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isBlank(statBeginTime) && StringUtils.isNotBlank(statEndTime)){
			endTime=CommonUtil.formateDateToStr(statEndTime);
			Calendar d=Calendar.getInstance();
			d.setTime(endTime);
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isNotBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
			endTime=new Date(System.currentTimeMillis());
		}else{
			endTime=CommonUtil.formateDateToStr(statEndTime);
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
		}
		
		if(orgId==null||orgId.equals("")||orgId.equals("NON")){
			orgId=null;
		}else{
			
		}
		condition.put("BEGINTIME",beginTime);
		condition.put("ENDTIME", endTime);
		condition.put("ORGANID", orgId);
		userExceptionStat=ses.statUserException(condition);
		organs=ses.queryOrgan();
		
		return "statuser";
	}

	/**
	 * 根据部门统计异常
	 * @return
	 * @throws Exception
	 */
	public String statOrganException() throws Exception {
		HashMap condition=new HashMap();
		Date beginTime=null;
		Date endTime=null;
        if(StringUtils.isBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			Calendar d=Calendar.getInstance();
			d.setTime(new Date());
			endTime=d.getTime();
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isBlank(statBeginTime) && StringUtils.isNotBlank(statEndTime)){
			endTime=CommonUtil.formateDateToStr(statEndTime);
			Calendar d=Calendar.getInstance();
			d.setTime(endTime);
			d.add(Calendar.MONTH, -3);
			beginTime=d.getTime();
        }else if(StringUtils.isNotBlank(statBeginTime) && StringUtils.isBlank(statEndTime)){
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
			endTime=new Date(System.currentTimeMillis());
		}else{
			endTime=CommonUtil.formateDateToStr(statEndTime);
			beginTime=CommonUtil.formateDateToStr(statBeginTime);
		}
		condition.put("BEGINTIME",beginTime);
		condition.put("ENDTIME", endTime);
		orgExceptionStat=ses.statOrganException(condition);
		return "statorgan";
	}
	
	/**
	 * 解析XML
	 * @param source
	 * @param exceptionType
	 * @param userName
	 * @return
	 * @throws Exception
	 */
	public String descXML(HashMap source,int exceptionType,String userName) throws Exception {
		String exceptionRecTime = source.get("EXCEPTION_REC_TIME").toString();
		if (source.get("DESC_XML") == null) {
			return "";
		}
		Clob descXmlClob = (Clob) source.get("DESC_XML");
		SAXReader reader = new SAXReader();
		Reader descXmlReader = descXmlClob.getCharacterStream();
		Document document = reader.read(descXmlReader);
		Element descDocument = document.getRootElement();// 得到根节点
		StringBuilder builder = new StringBuilder();
		if (exceptionType == 1) {
			String handleDay = descDocument.attributeValue("handles_day");
			String timeLimit = descDocument.attributeValue("time_limit");
			String beginTime = descDocument.attributeValue("begin_time");
			String outTime = descDocument.attributeValue("out_time");
//			String userName = SessionUtil.getUserName(ServletActionContext
//					.getRequest());
			String activityName = descDocument.attributeValue("activity_name");
			builder.append(userName);
			builder.append("于");
			builder.append(beginTime);
			builder.append("接收到“");
			builder.append(activityName);
			builder.append("”办理，活动限时");
			builder.append(timeLimit);
			builder.append("天，因其于");
			builder.append(exceptionRecTime);
			builder.append("尚未办理完成，共耗时");
			builder.append(handleDay);
			builder.append("工作日，办理超期");
			builder.append(outTime);
			builder.append("天，进行系统督办。");
		} else if (exceptionType == 2) {
			String beginTime = descDocument.attributeValue("begin_time");
			String timeLimit = descDocument.attributeValue("time_limit");
			String handleDay = descDocument.attributeValue("handles_day");
			String outTime = descDocument.attributeValue("out_time");

			builder.append("本项目于");
			builder.append(beginTime);
			builder.append("开始办理，活动限时");
			builder.append(timeLimit);
			builder.append("天，因其于");
			builder.append(exceptionRecTime);
			builder.append("尚未办理完成，共耗时");
			builder.append(handleDay);
			builder.append("工作日，办理超期");
			builder.append(outTime);
			builder.append("天");
		} else if (exceptionType == 3) {
			String beginTime = descDocument.attributeValue("backtimes");
			builder.append("本活动被打回");
			builder.append(beginTime);
			builder.append("次，超过了允许的范围。");
		} else if (exceptionType == 4) {
			builder.append("该活动决定与其他办理人员意见不符。");
		} else if (exceptionType == 5) {
			String needFee = descDocument.attributeValue("needfee");
			String getFree = descDocument.attributeValue("getfee");
			builder.append("本项目应收费");
			builder.append(needFee);
			builder.append("，实收费");
			builder.append(getFree);
			builder.append("。");
		} else if (exceptionType == 6) {
			builder.append("该活动发生挂起异常。");
		} else if (exceptionType == 7) {
			String id = descDocument.attributeValue("id");
			builder.append(id);
		} else if (exceptionType == 8) {
			builder.append("无");
		}
		return builder.toString();
	}
	public String getOrgName() {
		return orgName;
	}

	public String getUserId() {
		return userId;
	}



	public void setUserId(String userId) {
		this.userId = userId;
	}



	public int getType() {
		return type;
	}



	public void setType(int type) {
		this.type = type;
	}



	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public SysExceptionService getSes() {
		return ses;
	}

	public void setSes(SysExceptionService ses) {
		this.ses = ses;
	}

	public List<HashMap> getUserExceptionStat() {
		return userExceptionStat;
	}

	public void setUserExceptionStat(List<HashMap> userExceptionStat) {
		this.userExceptionStat = userExceptionStat;
	}

	public List<HashMap> getOrgExceptionStat() {
		return orgExceptionStat;
	}

	public void setOrgExceptionStat(List<HashMap> orgExceptionStat) {
		this.orgExceptionStat = orgExceptionStat;
	}


	public String getStatBeginTime() {
		return statBeginTime;
	}

	public void setStatBeginTime(String statBeginTime) {
		this.statBeginTime = statBeginTime;
	}

	public String getStatEndTime() {
		return statEndTime;
	}

	public void setStatEndTime(String statEndTime) {
		this.statEndTime = statEndTime;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	public List<HashMap> getOrgans() {
		return organs;
	}

	public void setOrgans(List<HashMap> organs) {
		this.organs = organs;
	}
}
