package com.gtis.web.action;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.form.print.xmlutil.DynamicSignVoXml;
import com.gtis.plat.form.print.xmlutil.VoListXml;
import com.gtis.plat.form.print.xmlutil.VoXml;
import com.gtis.plat.service.SysDynamicSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PFDynamicSignVo;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserSignVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

@Deprecated
public class DynamicSignAction {
	private PFDynamicSignVo dynamicsignVo;
	private PfUserSignVo signVo;
	private PfTaskVo taskVo;
	private PfActivityVo activityVo;
	private PfUserVo userVo;
	private String dynamicSignId;
	private String proid;
	private String taskid;
	private String userId;
	private String activityId;
	private String opnion;
	private String signid;
	private List<PFDynamicSignVo> signList;
	
	private SysDynamicSignService dynamicSignService;
	private SysTaskService taskService;
	private SysUserService userService;
	
	public String execute() throws Exception{
		if (taskid!=null && !taskid.equals("")){
			taskVo=taskService.getTask(taskid);
			activityId = taskVo.getActivityId();
		}
		
		HashMap<String, String> map = new HashMap<String, String>();
		userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		map.put("PRO_ID", proid);
		map.put("ACTIVITY_ID", activityId);
		signList = dynamicSignService.getDynamicSign(map);

		StringBuffer signKeyBuf = new StringBuffer();
		HashMap<String,PFDynamicSignVo> dynamicsignVoMap = new HashMap<String,PFDynamicSignVo>();
		for (int i=0;i <signList.size();i++){
			signKeyBuf.append(signList.get(i).getUserId());
			signKeyBuf.append(",");
			dynamicsignVoMap.put(signList.get(i).getUserId(), signList.get(i));
		}
		if (signKeyBuf.length() > 0){
			signKeyBuf.deleteCharAt(signKeyBuf.length()-1);
		}

		
		if (signKeyBuf.toString().length() > 0) {
			HashMap<String, String> paraMap = new HashMap<String, String>();
			paraMap.put("PRO_ID", proid);
			paraMap.put("SIGN_KEY", signKeyBuf.toString());
			List<PfUserSignVo>  tempPfUserSignVoList = dynamicSignService
					.getUserSignBySignKey(paraMap);

			
			for (int j = 0; j < tempPfUserSignVoList.size(); j++) {
				String tempSignKey = tempPfUserSignVoList.get(j).getSignKey();
				if (tempPfUserSignVoList.get(j).getSignImage() == null
						|| tempPfUserSignVoList.get(j).getSignImage().length == 0) {
					dynamicsignVoMap.get(tempSignKey).setSignId("");

				} else {
					String paraBuf = "proid=" + proid + "&signkey="
							+ tempSignKey;
					if (dynamicsignVoMap.get(tempSignKey) != null) {
						dynamicsignVoMap.get(tempSignKey).setSignId(
								paraBuf.toString());
					}

				}
			}
		}
		
		return Action.SUCCESS;
	}
	
	
	/**
	 * 打印
	 * @return
	 * @throws Exception
	 */
	public String print() throws Exception{
		
		
		if (taskid != null && !taskid.equals("")) {
			taskVo = taskService.getTask(taskid);
			activityId = taskVo.getActivityId();
		}
 
		HashMap<String, String> map = new HashMap<String, String>();
		userId = SessionUtil.getUserId(ServletActionContext.getRequest());
		map.put("PRO_ID", proid);
		map.put("ACTIVITY_ID", activityId);
		List<PFDynamicSignVo> tempSignList = dynamicSignService.getDynamicSign(map);
		HttpServletResponse response = ServletActionContext.getResponse();
		StringBuffer printBuf = new StringBuffer();
		
		
		String iframeid = ServletActionContext.getRequest().getParameter("iframeid");
		if (iframeid == null){
			iframeid = "0";
		}
		//VoListXml volistXml = new VoListXml(tempSignList);
		
		//printBuf.append("\n<detail ID=\""+iframeid+"\">\n");//wh 2009-07-22
		printBuf.append("\n<detail ID=\""+"0"+"\">\n");
		
		printBuf.append(getXMLData(tempSignList));
		printBuf.append("\n</detail>\n");
		System.out.println("---------printBuf="+printBuf.toString());
		
		response.getOutputStream().write(printBuf.toString().getBytes("utf-8"));
		
		return Action.NONE;
	}
	
	public String getXMLData(List list){
		StringBuffer sb=new StringBuffer();
		Iterator it= list.iterator();
		int i=0;
		while(it.hasNext())
		{
			Object obj=(Object)it.next();
			sb.append("<row ID=\""+Integer.toString(i)+"\">\n");
			sb.append("<data name=\"GtisNo\" type=\"String\">"+String.valueOf(i+1)+"</data>\n");
			DynamicSignVoXml vxml=new DynamicSignVoXml(obj);
			sb.append(vxml.getXMLData());
			sb.append("</row>\n");
			i++;
		}
		return sb.toString();
	} 
	
	/**获取方法**/
	private Method getMethod(String methodName, Object vo)
	{
		Method method=null;
		try {
			method =vo.getClass().getDeclaredMethod(methodName,new Class[]{});
		} catch (Exception e) {
			method=null;
			e.printStackTrace();
		}
		return method;
	}
	
	
	
	public String save() throws Exception{
		userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		if (taskid!=null && !taskid.equals("")){
			taskVo=taskService.getTask(taskid);
			activityId = taskVo.getActivityId();
		}
		System.out.println("==============="+this.getTaskid()+"==========="+this.getProid()+"====="+this.getActivityId());
		HashMap<String, String> map2 = new HashMap<String, String>();
		map2.put("PRO_ID", proid);
		map2.put("TASK_ID", taskid);
		map2.put("USER_ID", userId);
		signList = dynamicSignService.getDynamicSign(map2);
		
		if(signList.size()==0){
			String dynamicSignId = UUIDGenerator.generate();
			
			dynamicsignVo = new PFDynamicSignVo();
			dynamicsignVo.setDynamicSignId(dynamicSignId);

			
			dynamicsignVo.setYj(opnion);
			dynamicsignVo.setActivityId(activityId);
			dynamicsignVo.setProId(proid);
			dynamicsignVo.setTaskId(taskid);
			userVo = userService.getUserVo(userId);
			dynamicsignVo.setUserId(userId);
			dynamicsignVo.setUserName(userVo.getUserName());
			dynamicsignVo.setUserNo(userVo.getUserNo());
			if(userService.getOrganListByUser(userId).size()>0){
				dynamicsignVo.setOrganName(userService.getOrganListByUser(userId).get(0).getOrganName());
			}
			HashMap<String, String> map1 = new HashMap<String, String>();
			map1.put("USER_ID", userId);
			map1.put("PRO_ID", proid);
			if(dynamicSignService.getUserSign(map1).size()==0){
				System.out.println("没有签名");
			}else{
				signVo = dynamicSignService.getUserSign(map1).get(0);
				dynamicsignVo.setSignDate(signVo.getSignDate());
			}
			dynamicSignService.saveDynamicSign(dynamicsignVo);
			
		}
		else{
			
			dynamicsignVo = signList.get(0);
//			dynamicsignVo.setDynamicSignId(signList.get(0).getDynamicSignId());
			dynamicsignVo.setYj(opnion);
			dynamicSignService.updateDynamicSign(dynamicsignVo);
		}
		HashMap<String, String> map = new HashMap<String, String>();
		userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		map.put("PRO_ID", proid);
		map.put("ACTIVITY_ID", activityId);
		signList = dynamicSignService.getDynamicSign(map);

		StringBuffer signKeyBuf = new StringBuffer();
		HashMap<String,PFDynamicSignVo> dynamicsignVoMap = new HashMap<String,PFDynamicSignVo>();
		for (int i=0;i <signList.size();i++){
			signKeyBuf.append(signList.get(i).getUserId());
			signKeyBuf.append(",");
			dynamicsignVoMap.put(signList.get(i).getUserId(), signList.get(i));
		}
		if (signKeyBuf.length() > 0){
			signKeyBuf.deleteCharAt(signKeyBuf.length()-1);
		}

		
		if (signKeyBuf.toString().length() > 0) {
			HashMap<String, String> paraMap = new HashMap<String, String>();
			paraMap.put("PRO_ID", proid);
			paraMap.put("SIGN_KEY", signKeyBuf.toString());
			List<PfUserSignVo>  tempPfUserSignVoList = dynamicSignService
					.getUserSignBySignKey(paraMap);

			
			for (int j = 0; j < tempPfUserSignVoList.size(); j++) {
				String tempSignKey = tempPfUserSignVoList.get(j).getSignKey();
				if (tempPfUserSignVoList.get(j).getSignImage() == null
						|| tempPfUserSignVoList.get(j).getSignImage().length == 0) {
					dynamicsignVoMap.get(tempSignKey).setSignId("");

				} else {
					String paraBuf = "proid=" + proid + "&signkey="
							+ tempSignKey;
					if (dynamicsignVoMap.get(tempSignKey) != null) {
						dynamicsignVoMap.get(tempSignKey).setSignId(
								paraBuf.toString());
					}

				}
			}
		}
		return Action.SUCCESS;
	}
	
	/**
	 * 获取签名图片
	 * @return
	 * @throws Exception
	 */
	public String getSignImage() throws Exception{
		HttpServletResponse response = ServletActionContext.getResponse();
		String userId=SessionUtil.getUserId(ServletActionContext.getRequest());
		response.setContentType("image/jpeg");
		
		ServletOutputStream out = response.getOutputStream();
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("USER_ID", userId);
		map.put("PRO_ID", proid);
//		if(dynamicSignService.getUserSign(map).size()==0){
//			
//		}
		byte[] imageBytes = dynamicSignService.getUserSign(map).get(0).getSignImage();//
		try {
			out.write(imageBytes);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
		} 
		return Action.NONE;
	}

	public PFDynamicSignVo getDynamicsignVo() {
		return dynamicsignVo;
	}

	public void setDynamicsignVo(PFDynamicSignVo dynamicsignVo) {
		this.dynamicsignVo = dynamicsignVo;
	}

	public PfUserSignVo getSignVo() {
		return signVo;
	}

	public void setSignVo(PfUserSignVo signVo) {
		this.signVo = signVo;
	}


	public String getActivityId() {
		return activityId;
	}

	public void setActivityId(String activityId) {
		this.activityId = activityId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public List<PFDynamicSignVo> getSignList() {
		return signList;
	}

	public void setSignList(List<PFDynamicSignVo> signList) {
		this.signList = signList;
	}

	public SysDynamicSignService getDynamicSignService() {
		return dynamicSignService;
	}

	public void setDynamicSignService(SysDynamicSignService dynamicSignService) {
		this.dynamicSignService = dynamicSignService;
	}

	public String getDynamicSignId() {
		return dynamicSignId;
	}

	public void setDynamicSignId(String dynamicSignId) {
		this.dynamicSignId = dynamicSignId;
	}

	public String getProid() {
		return proid;
	}

	public void setProid(String proid) {
		this.proid = proid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public PfTaskVo getTaskVo() {
		return taskVo;
	}

	public void setTaskVo(PfTaskVo taskVo) {
		this.taskVo = taskVo;
	}

	public PfActivityVo getActivityVo() {
		return activityVo;
	}

	public void setActivityVo(PfActivityVo activityVo) {
		this.activityVo = activityVo;
	}

	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public PfUserVo getUserVo() {
		return userVo;
	}

	public void setUserVo(PfUserVo userVo) {
		this.userVo = userVo;
	}

	public SysUserService getUserService() {
		return userService;
	}

	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}

	public String getOpnion() {
		return opnion;
	}

	public void setOpnion(String opnion) {
		this.opnion = opnion;
	}

	public String getSignid() {
		return signid;
	}

	public void setSignid(String signid) {
		this.signid = signid;
	}

}
