package com.gtis.util;

import java.util.*;
import org.apache.struts2.json.JSONUtil;

import com.gtis.common.util.*;
import com.gtis.plat.vo.*;

/**
 * @文件名 SjdUtil.java
 * @作者 卢向伟
 * @创建日期 2013-11-2
 * @创建时间 上午9:33:49 
 * @版本号 V 1.0
 */
public class SjdUtil {
	/**
	 * 获取收件单材料list
	 * @param sjdid
	 * @return
	 */
	public static List<SjdclVo> getSjdclListBySjdVo(SjdVo vo){
		List<SjdclVo> clList = new ArrayList<SjdclVo>();
		try {
			if (vo != null && vo.getSjd_cl() != null) {
				List<HashMap> tempList = (List<HashMap>)JSONUtil.deserialize(new String(vo.getSjd_cl()));
				for (int i = 0; i < tempList.size(); i++) {
					HashMap map = tempList.get(i);
					SjdclVo clVo = new SjdclVo();
					if (map.get("data_id") != null) {
						clVo.setData_id(map.get("data_id").toString());
					}
					if (map.get("bz") != null) {
						clVo.setBz(map.get("bz").toString());
					}
					
					if (map.get("jjr") != null) {
						clVo.setJjr(map.get("jjr").toString());
					}
					if (map.get("lxdh") != null) {
						clVo.setLxdh(map.get("lxdh").toString());
					}
					if (map.get("name") != null) {
						clVo.setName(map.get("name").toString());
					}
					
					if (map.get("xh") != null) {
						long value = (Long)map.get("xh");
						clVo.setXh((int)value);
					}
					if (map.get("node_id") != null) {
						long value = (Long)map.get("node_id");
						clVo.setNode_id((int)value);
					}
					if (map.get("num") != null) {
						long value = (Long)map.get("num");
						clVo.setNum((int)value);
					}
					if (map.get("ysnum") != null) {
						long value = (Long)map.get("ysnum");
						clVo.setYsnum((int)value);
					}else {
						clVo.setYsnum(clVo.getNum());
					}
					if (map.get("dbnum") != null) {
						long value = (Long)map.get("dbnum");
						clVo.setDbnum((int)value);
					}else {
						if (clVo.getNum() != null && clVo.getYsnum() != null && clVo.getNum() >= clVo.getYsnum()) {
							clVo.setDbnum(clVo.getNum() - clVo.getYsnum());
						}
					}
					
					if (map.get("proid") != null) {
						clVo.setProid(map.get("proid").toString());
					}
					if (map.get("sj_date") != null) {
						clVo.setSj_date(CommonUtil.formateDateToStr(map.get("sj_date").toString()));
					}
					if (map.get("sjdid") != null) {
						clVo.setSjdid(map.get("sjdid").toString());
					}
					if (map.get("sjr") != null) {
						clVo.setSjr(map.get("sjr").toString());
					}
					if (map.get("type") != null) {
						clVo.setType(map.get("type").toString());
					}
					if (map.get("user_id") != null) {
						clVo.setUser_id(map.get("user_id").toString());
					}
					clList.add(clVo);
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return clList;
	}
}
