package com.gtis.plat.wf.bean;

import java.util.List;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowUtil;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.TransitionModel;
import org.apache.commons.lang.StringUtils;

/**
 * 
 * 根据是否要等待所有参与者办结 办结任务和活动
 * 
 * @author jiff
 * 
 */
public class WorkFlowTaskOverBean extends WorkFlowBeanAbstract {

	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
				.getWorkFlowIntanceVo());
		PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
		ActivityModel sourceActivityModel = workXml
				.getActivity(sourceActivityVo.getActivityDefinitionId());
		if (sourceActivityModel.isWaitAllUsers() || sourceActivityModel.isSpecialFinish()) { // WaitAllUsers,SpecialFinish
			List<PfTaskVo> lstTasks = this.getTaskService().getTaskListByActivity(sourceActivityVo.getActivityId());
			if (lstTasks.size() > 1) {
				// 当前活动的其他任务还没有办结
				// infoObj.setTargetActivitys(null);
				// 当前活动转发的任务需要记录
                //以下注释代码移动到taskbuild代码中
//				for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
//					String tempActivityId = WorkFlowUtil
//							.buildTEMPActivityId(taskVo.getActivityId());
//					taskVo.setActivityId(tempActivityId);
//				}
				// infoObj.setTargetTasks(null);
                
				// 办结当前任务
				doEndTask(infoObj);
				return true;
			}
		}
		//是否存在协办,如果存在不办结当前活动
		List<ActivityModel> transActivitys=infoObj.getTransInfo().getTranActivitys();
		for(ActivityModel transModel:transActivitys){
			if (transModel.getCooperRootId() != null
				&& !transModel.getCooperRootId().equals("")) {
				if (transModel.getCooperRootId().equals(infoObj.getSourceActivity().getActivityDefinitionId()))
					return true;
			}
		}
		// 办结活动
		this.getTaskService().updateActivityStadus(
				infoObj.getSourceActivity().getActivityId(),
				WorkFlowEnum.ACTIVITY_END);
		// 办结任务
		doEndTask(infoObj);
		// 删除多余任务
		this.getTaskService().deleteActivityTask(
				infoObj.getSourceActivity().getActivityId());
		return true;
	}

	private void doEndTask(WorkFlowInfo infoObj) {
        //根据用户id和活动结点判断历史表有没有重复的
        List<PfTaskVo> history_taskList=this.getTaskService().getHistoryTaskListByActivity(infoObj.getSourceActivity().getActivityId());
        int isRepeat=0;//0表示没有重复的
        if(history_taskList.size()>0){
            for(PfTaskVo pfTaskVo:history_taskList){
                if(pfTaskVo!=null && StringUtils.isNotBlank(pfTaskVo.getUserVo().getUserId()) && StringUtils.equals(pfTaskVo.getUserVo().getUserId(),infoObj.getUserId())){
                    isRepeat=1;
                    break;
                }
            }
        }
		// 办结任务
		this.getTaskService().insertTaskHistory(
				infoObj.getSourceTask().getTaskId());

		this.getTaskService().deleteTask(infoObj.getSourceTask().getTaskId());

		// 更新任务意见
		if (infoObj.getTransInfo().getRemark() != null) {
            PfTaskVo taskHisVo = this.getTaskService().getHistoryTask(
                    infoObj.getSourceTask().getTaskId());
			taskHisVo.setRemark(infoObj.getTransInfo().getRemark());
			this.getTaskService().updateHistoryTask(taskHisVo);

		}
        //重复状态为1，更新历史任务的重复状态
        if(isRepeat==1  && StringUtils.isNotBlank(infoObj.getSourceTask().getTaskId()))
            this.getTaskService().updateAssignmentHistoryRepeat(infoObj.getSourceTask().getTaskId());
	}

}
