package com.gtis.plat.wf.bean;

import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * 流程办结
 *
 * @author jiff
 */
public class WorkFlowTaskFinishBean extends WorkFlowBeanAbstract {

    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String activityDefineId = infoObj.getSourceActivity()
                .getActivityDefinitionId();
        // 判断是否任务办结，两种情况（1为最后一个活动，2为中间活动的）
        if (infoObj.getTransInfo().getTranActivitys().size() == 0) {
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                    .getWorkFlowIntanceVo());
            ActivityModel aModel = workXml.getActivity(activityDefineId);
            ///////排除WaitAllUsers情况，如果其他人还在办理///////////
            PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
            List<PfTaskVo> lstTasks = this.getTaskService()
                    .getTaskListByActivity(sourceActivityVo.getActivityId());
            if (lstTasks.size() > 1) {
                return true;
            }

            //////////////////////////////////////////////////////////
            String endActivityDefine = workXml.getEndActivityDefine();
            if (StringUtils.isBlank(endActivityDefine)) {
                ///没有结束节点
                endActivityDefine = "";
            }
            if (endActivityDefine.equals(activityDefineId)
                    || aModel.isCanFinish()) {
                FinishWorkFlowInstance(infoObj,aModel.isSpecialFinish());
            } else if (workXml.getActivitiesCount() == 1) {
                ////只有一个节点，over
                FinishWorkFlowInstance(infoObj,aModel.isSpecialFinish());
            }
        }
        return true;
    }

    private void FinishWorkFlowInstance(WorkFlowInfo infoObj,boolean specialFinish) throws Exception {
        //WorkFlowCoreService service = (WorkFlowCoreService) Container.getBean("WorkFlowService");
        if(specialFinish){
            if(worFlowInstanceService.statTaskCountByWiid(infoObj.getWorkFlowIntanceVo()
                        .getWorkflowIntanceId()) <= 0){
                FinishWorkFlow(infoObj);
            }
        }else{
            FinishWorkFlow(infoObj);
        }     
	}

    /**
     * 办结了
     * @param infoObj
     * @throws Exception
     */
    private void FinishWorkFlow(WorkFlowInfo infoObj) throws Exception {
        WorkFlowCoreService service = (WorkFlowCoreService) Container.getBean("WorkFlowCoreService");
        service.finishWorkFlow(infoObj);
    }
}
