package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;

import java.util.ArrayList;
import java.util.List;

/**
 * 根据是否要等待所有参与者办结 办结任务和活动
 *
 * @author jiff
 */
public class WorkFlowRemoveRepeatTaskBean extends WorkFlowBeanAbstract {
    final static String TASKNOTREPEAT = "TaskNotRepeat";

    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(infoObj
                .getWorkFlowIntanceVo());
        if (infoObj.getTargetActivitys() != null) {
            List<PfActivityVo> lstRemoveActivitys = new ArrayList<PfActivityVo>();
            for (PfActivityVo activityVo : infoObj.getTargetActivitys()) {
                ActivityModel sourceActivityModel = workXml
                        .getActivity(activityVo.getActivityDefinitionId());
                if (sourceActivityModel.getExtendedAttribute(TASKNOTREPEAT).equalsIgnoreCase("true")) {
                    List<PfTaskVo> lstTasks =
                            this.getTaskService().getHistoryTaskListByDefineId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(), sourceActivityModel.getDefineId());
                    List<String> userIds = BuildUserIds(lstTasks);
                    List<PfTaskVo> lstRemoveTasks = new ArrayList<PfTaskVo>();
                    if (userIds.size()==0)
                        continue;
                    //去除重复的任务
                    boolean activityTask = false;
                    for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                        if (!taskVo.getActivityId().equals(activityVo.getActivityId()))
                            continue;

                        if (userIds.contains(taskVo.getUserVo().getUserId())) {
                            lstRemoveTasks.add(taskVo);
                        } else {
                            activityTask = true;
                        }
                    }
                    infoObj.getTargetTasks().removeAll(lstRemoveTasks);
                    if (!activityTask) lstRemoveActivitys.add(activityVo);
                }
            }
            infoObj.getTargetActivitys().removeAll(lstRemoveActivitys);
        }
        return true;
    }

    private List<String> BuildUserIds(List<PfTaskVo> lstTasks) {
        List<String> userIds = new ArrayList<String>();
        if (lstTasks != null) {
            for (PfTaskVo taskVo : lstTasks) {
                userIds.add(taskVo.getUserVo().getUserId());
            }
        }
        return userIds;
    }
}