package com.gtis.plat.wf.bean;

import com.gtis.config.AppConfig;
import com.gtis.plat.datasource.BusinessDataSource;
import com.gtis.plat.form.FormSqlBuilder;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowMessage;
import com.gtis.spring.Container;
import com.gtis.util.DataSourceManager;
import com.gtis.util.JmsDestinationFactory;
import com.gtis.util.StaticParamHelper;
import com.gtis.util.ThreadPool;
import com.gtis.web.SessionUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.dom4j.*;
import org.springframework.jms.JmsException;

import javax.sql.DataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;

public class WorkFlowEventBean extends WorkFlowBeanAbstract {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(WorkFlowEventBean.class);
    private String eventName;

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    /**
     * 工作流事件
     */
    @SuppressWarnings("unchecked")
    public boolean doWork(WorkFlowInfo infoObj) throws Exception {
        String xmlEvent = this.getWorkFlowDefineService()
                .getWorkFlowDefineEventXml(infoObj.getWorkFlowDefineVo());
        if (!StringUtils.isBlank(xmlEvent)) {
            try {
                Document doc = DocumentHelper.parseText(xmlEvent);
                List eventNodes = doc.selectNodes("//Event[@name='" + eventName
                        + "']");
                for (int i = 0; i < eventNodes.size(); i++) {
                    log.info("-------------------------事件名称:" + eventName);
                    Node eventNode = (Node) eventNodes.get(i);
                    String activityDefinitionId = eventNode
                            .valueOf("@activityDefinitionId");

                    PfActivityVo activityVo = infoObj.getSourceActivity();
                    if (activityVo != null) {
                        if (activityDefinitionId != null && !"".equals(activityDefinitionId.trim())
                                && !activityDefinitionId.equals(activityVo.getActivityDefinitionId())) {
                            continue;
                        }
                    }
                    ExcuteCommand(infoObj, eventNode);
                }

            } catch (Exception e) {
                // log.error("工作流事件定义错误！", e);
                throw e;
            }
        }
//        try {
//            HashMap map = new HashMap();
//            map.put("WorkFlowEvent",eventName);
//            XStream xstream = new XStream(new DomDriver());
//            xstream.alias("WorkFlowInfo", WorkFlowInfo.class);
//            map.put("WorkFlowInfo",xstream.toXML(infoObj));
//            jmsTemplate.convertAndSend(destination, map);
//        } catch (JmsException e) {
//            log.error("send jms message error:[{}]", e);
//        }
        return true;
    }

    private void ExcuteCommand(WorkFlowInfo infoObj, Node eventNode)
            throws Exception {
        Element eleNode = (Element) eventNode;
        List<Element> childsElement = eleNode.elements();
        for (Element ele : childsElement) {
            String proId = infoObj.getWorkFlowIntanceVo().getProId();
            if (ele.getName().equalsIgnoreCase("SqlExcute")) {
                PfBusinessVo businessVo = super.getWorkFlowDefineService()
                        .getBusiness(
                                infoObj.getWorkFlowDefineVo().getBusinessId());
                ExcuteSql(businessVo, ele.getTextTrim(), proId, infoObj.getUserId());
            } else if (ele.getName().equalsIgnoreCase("SqlSelect")) {
                PfBusinessVo businessVo = super.getWorkFlowDefineService()
                        .getBusiness(
                                infoObj.getWorkFlowDefineVo().getBusinessId());
                boolean result = ExcuteSelectSql(businessVo, ele.getTextTrim(),
                        proId);
                if (!result) {
                    String errMessage = ele.valueOf("@message");
                    WorkFlowException ex = new WorkFlowException(errMessage);
                    throw ex;
                }
            } else if (ele.getName().equalsIgnoreCase("Url")) {
                String url = AppConfig.getPlaceholderValue(ele.getTextTrim());
                boolean asyn = false;
                if (StringUtils.isNotBlank(ele.valueOf("@asyn")) && ele.valueOf("@asyn").equalsIgnoreCase("true")) {
                    asyn = true; //表示异步执行
                }
                String result = ExcuteUrl(url, proId, infoObj, asyn);
                if (StringUtils.isNotBlank(result)) {
                    WorkFlowException ex = new WorkFlowException(java.net.URLDecoder.decode(result,"UTF-8"));
                    throw ex;
                }

            } else if (ele.getName().equalsIgnoreCase("Jms")) {
                Attribute attr = ele.attribute("type");
                sendJmsMessage(ele.getTextTrim(), infoObj, attr != null && "queue".equalsIgnoreCase(attr.getValue()));
            }
        }
    }

    private void sendJmsMessage(final String name, WorkFlowInfo infoObj, final boolean toQueue) {
        SysWorkFlowDefineService workFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineServiceImpl");
        PfBusinessVo business = workFlowDefineService.getBusiness(infoObj.getWorkFlowDefineVo().getBusinessId());
        if (!StringUtils.isBlank(business.getBusinessUrl())) {
            business.setBusinessUrl(business.getBusinessUrl() + infoObj.getWorkFlowIntanceVo().getProId());
        }
        WorkFlowMessage workFlowMsg = new WorkFlowMessage();
        workFlowMsg.setBusinessVo(business);
        workFlowMsg.setWorkFlowIntanceVo(infoObj.getWorkFlowIntanceVo());
        workFlowMsg.setSourceActivity(infoObj.getSourceActivity());
        workFlowMsg.setSourceTask(infoObj.getSourceTask());
        //将vo变成xml传出
        XStream xstream = new XStream(new DomDriver());
        xstream.alias("WorkFlowMessage", WorkFlowMessage.class);
        final String xml = xstream.toXML(workFlowMsg);
        ThreadPool.execute(new Runnable() {
            public void run() {
                try {
                    log.info("--sendMessageXml------" + xml);
                    jmsTemplate.convertAndSend(toQueue ? JmsDestinationFactory.getQueue(name) : JmsDestinationFactory.getTopic(name), xml);
                } catch (JmsException e) {
                    log.error("send jms message error:[" + e.getMessage() + "]");
                }
            }
        });
    }

    /**
     * 执行sql语句
     *
     * @param
     * @param
     * @param
     */
    private void ExcuteSql(PfBusinessVo businessVo, String sql, String proId, String userId)
            throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            DataSource ds = BusinessDataSource
                    .getDataSourceByBusiness(businessVo);
            con = ds.getConnection();
            sql = this.getFormSqlProcessor().processor(sql,proId);
//            if (StringUtils.isNotBlank(userId)) {
//                sql = FormSqlBuilder.replaceUserIdSql(sql, userId); //userId
//                sql = FormSqlBuilder.replaceUserName(sql, this.userService.getUserVo(userId).getUserName());//userName
//            }
//            sql = FormSqlBuilder.replaceDateSql(sql); // 当前时间

            String[] sqlExcute = sql.split(StaticParamHelper.SQL_SEPARATOR_SPLIT);
            for (int i = 0; i < sqlExcute.length; i++) {
                ps = con.prepareStatement(sqlExcute[i]);
                ps.executeQuery();
                DataSourceManager.attemptClose(ps);
            }
        } catch (Exception e) {
            log.error("工作流事件定义sql错误,请检查！", e);
            throw e;
        } finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose(con);
        }
    }

    private boolean ExcuteSelectSql(PfBusinessVo businessVo, String sql,
                                    String proId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            DataSource ds = BusinessDataSource
                    .getDataSourceByBusiness(businessVo);
            con = ds.getConnection();
            sql = this.getFormSqlProcessor().processor(sql,proId);
            log.debug(sql);
//            System.out.println(sql);
//            sql = FormSqlBuilder.replaceDateSql(sql); // 当前时间
            String[] sqlExcute = sql.split(StaticParamHelper.SQL_SEPARATOR_SPLIT);
            for (int i = 0; i < sqlExcute.length; i++) {
                ps = con.prepareStatement(sqlExcute[i]);
                rs = ps.executeQuery();
                if (rs.next()) {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int count = rsmd.getColumnCount();
                    for (int j = 1; j < count + 1; j++) {
                        if (StringUtils.isBlank(rs.getString(j))) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }

            }
        } catch (Exception e) {
            throw e;
        } finally {
            DataSourceManager.attemptClose(ps);
            DataSourceManager.attemptClose(con);
        }
        return true;
    }

    private String ExcuteUrl(String urlStr, String proId, WorkFlowInfo infoObj, boolean asyn) throws Exception {
        String[] urlStrs = urlStr.split(StaticParamHelper.URL_SEPARATOR_SPLIT);
        String workflowParaUrl = getWorkFlowInfoUrlFormat(infoObj);
        for (String urlTemp : urlStrs) {
            urlTemp = urlTemp.trim();
            if (!urlTemp.startsWith("http://")) {
                urlTemp = "http://" + platUrl + urlTemp;
            }
            try {
                if (urlTemp.indexOf("?") > 0)
                    urlTemp = urlTemp + "&proid=" + proId + "&" + workflowParaUrl;
                else
                    urlTemp = urlTemp + "?proid=" + proId + "&" + workflowParaUrl;
                if (infoObj.getSourceActivity() != null)
                    urlTemp = urlTemp + "&adid=" + infoObj.getSourceActivity().getActivityId();
                if(infoObj.getTargetActivitys()!=null){
                    String targetActivityDefIds="";
                    for(PfActivityVo pfActivityVo:infoObj.getTargetActivitys()){
                        if(pfActivityVo!=null){
                            if(StringUtils.isNotBlank(targetActivityDefIds))
                                targetActivityDefIds=targetActivityDefIds+","+pfActivityVo.getActivityDefinitionId();
                            else
                                targetActivityDefIds=pfActivityVo.getActivityDefinitionId();
                        }
                    }
                    if(StringUtils.isNotBlank(targetActivityDefIds))
                        urlTemp = urlTemp + "&targetActivityDefids=" + targetActivityDefIds;
                }

                //urlTemp = urlTemp + "&userid=" + SessionUtil.getCurrentUserId();
                log.info("-------------------------urlTemp:" + urlTemp);
                return ExcuteUrl(urlTemp, asyn);
            } catch (Exception e) {
                log.error("工作流事件定义url错误,请检查！" + urlTemp, e);
            }
        }
        return null;
    }

    /**
     * 获取参数的WorkFlowInfo html url格式字符串的形式
     *
     * @return
     */
    private String getWorkFlowInfoUrlFormat(WorkFlowInfo infoObj) throws Exception {
        StringBuffer resultBuf = new StringBuffer();
        resultBuf.append("userid=");
        resultBuf.append(infoObj.getUserId());
        if (infoObj.getSourceActivity() != null) {
            resultBuf.append("&activityid=");
            resultBuf.append(infoObj.getSourceActivity().getActivityId());
        }
        if (infoObj.getSourceTask() != null) {
            resultBuf.append("&taskid=");
            resultBuf.append(infoObj.getSourceTask().getTaskId());
        }
        List<PfActivityVo> targetActivitys = infoObj.getTargetActivitys();
        if (targetActivitys != null) {
            resultBuf.append("&targetActivityIds=");
            for (int index = 0; index < targetActivitys.size(); index++) {
                if (index != 0) {
                    resultBuf.append(",");
                }
                resultBuf.append(targetActivitys.get(index).getActivityId());
            }
            resultBuf.append("&targetActivityNames=");
            for (int index = 0; index < targetActivitys.size(); index++) {
                if (index != 0) {
                    resultBuf.append(",");
                }
                if(StringUtils.isNotBlank(targetActivitys.get(index).getActivityName()))
                resultBuf.append(java.net.URLEncoder.encode(targetActivitys.get(index).getActivityName(), "utf-8"));
            }
        }
        return resultBuf.toString();
    }

    private String ExcuteUrl(String urlString, boolean asyn) throws Exception {
        if (asyn) {
            final String urlStr = urlString;
            ///采用异步的方式执行，这个就没有返回结果了
            ThreadPool.execute(new Runnable() {
                public void run() {
                    HttpClient httpClient = null;
                    GetMethod getMethod = null;
                    try {
                        httpClient = new HttpClient();
                        getMethod = new GetMethod(urlStr);
                        httpClient.executeMethod(getMethod);
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }finally {
                        if(getMethod!=null)
                            getMethod.releaseConnection();
                    }
                }
            });
        } else {
            URL url = new URL(urlString);
            URLConnection URLconnection = url.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection) URLconnection;
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                InputStream urlStream = httpConnection.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(urlStream));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                }
                return buffer.toString();
            }
        }
        return null;
    }

    public static void main(String[] param) throws Exception {
        //WorkFlowEventBean obj=new WorkFlowEventBean();
        //System.out.println(obj.ExcuteUrl("http://www.baidu.com?proid=0129792d959429792d95000040281643&userid=0&activityid=0129792d975b29792d97000140281643&taskid=0129792d976829792d97000b40281643"));
//        Connection conn=null;
//        try {
//            Class.forName( "oracle.jdbc.driver.OracleDriver" );
//            conn = DriverManager.getConnection( "jdbc:oracle:thin:@192.168.50.23:1521:ORCL", "oa", "oa" );
//        } catch (ClassNotFoundException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        } catch (SQLException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        System.out.println(conn+"----------------->");

        //String sql="DELETE FROM BM_GTZYJSFTZD WHERE LCD_ID = '012b193a68222b193a6800004028b26d' @![SEPARATOR]!@ DELETE FROM BM_YDFACQD WHERE LCD_ID = '012b193a68222b193a6800004028b26d' @![SEPARATOR]!@ DELETE FROM BM_GLXMYDFASPD WHERE LCD_ID = '012b193a68222b193a6800004028b26d' @![SEPARATOR]!@ DELETE FROM BM_YWBLLCD WHERE LCD_ID = '012b193a68222b193a6800004028b26d'";
        //String[] str= sql.split("\\@!\\[SEPARATOR\\]!\\@");
        //String sql="ddd " +    StaticParamHelper.SQL_SEPARATOR + "[SEPARATOR]  cccc";

        //StringUtils.
        //System.out.println("----------------->" + str.length);
    }


}
