package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * 协办任务处理
 * 
 * @author jiff
 * 
 */
public class WorkFlowCooperBean extends WorkFlowBeanAbstract {

	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		// 判断当前任务下是否有协办任务
		String xmlModel=this.getWorFlowInstanceService().getWorkflowInstanceXml(infoObj.getWorkFlowIntanceVo());
		WorkFlowXml workXml =new WorkFlowXml(xmlModel);
		PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
		ActivityModel sourceActivityModel = workXml
				.getActivity(sourceActivityVo.getActivityDefinitionId());
		//判断转发活动中是否有已经存在的协办活动
		List<ActivityModel> transActivitys=infoObj.getTransInfo().getTranActivitys();
		boolean cooperTask=false;
		for(ActivityModel transModel:transActivitys){
			if (transModel.getCooperRootId() != null
				&& !transModel.getCooperRootId().equals("")) {
				PfActivityVo cooperActityVo = this.getTaskService()
				.getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),
						transModel.getDefineId());
				if (cooperActityVo!=null &&  cooperActityVo.getActivityState()==WorkFlowEnum.ACTIVITY_START){
					throw new WorkFlowException(
							WorkFlowException.ExceptionNum.CooperatAlready);
				}
				cooperTask=true;
				//设置协办状态
				this.getTaskService().updateCooperateStateDown(sourceActivityVo.getActivityId());  
			}
		}
		if (cooperTask){   //判断协办任务是否和其他非协办任务是否同时转发
			for(ActivityModel transModel:transActivitys){
				if (transModel.getCooperRootId() == null
					|| transModel.getCooperRootId().equals("")) {
						throw new WorkFlowException(
								WorkFlowException.ExceptionNum.CooperatAndOthers);
				}
			}
		}
		//是否存在不能强行办理的协办
		if (sourceActivityModel.getCooperState() == 1) { 
			if (sourceActivityVo.getCooperatState() < 0)
				throw new WorkFlowException(
						WorkFlowException.ExceptionNum.CooperatNotEnd);
		}
		// 如果当前活动为协办活动
		if (StringUtils.isNotBlank(sourceActivityModel.getCooperRootId())) {
            if (sourceActivityModel.isWaitAllUsers()) { // WaitAllUsers
                List<PfTaskVo> lstTasks = this.getTaskService()
                    .getTaskListByActivity(sourceActivityVo.getActivityId());
                if (lstTasks.size() > 0) {
                    return true;    
                }
            }
			//查找协办根活动
			PfActivityVo rootActityVo = this.getTaskService()
					.getActivityBywIdandadId(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId(),
							sourceActivityModel.getCooperRootId());
			this.getTaskService().updateCooperateStateUp(rootActityVo.getActivityId()); // 设置协办状态
		}
		return true;
	}

}
