package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.wf.*;
import com.gtis.plat.wf.model.ActivityModel;
import org.apache.commons.lang.StringUtils;

import java.text.MessageFormat;
import java.util.List;

/**
 * 检查是否有其他活动的任务没有办结
 * 
 * @author jiff
 * 
 */
public class WorkFlowCheckOtherFinishBean extends WorkFlowBeanAbstract {
    private static String checkFinishStr="CheckOtherFinish";

	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		// 判断当前任务下是否有协办任务
		String xmlModel=this.getWorFlowInstanceService().getWorkflowInstanceXml(infoObj.getWorkFlowIntanceVo());
		WorkFlowXml workXml =new WorkFlowXml(xmlModel);
		PfActivityVo sourceActivityVo = infoObj.getSourceActivity();
		ActivityModel sourceActivityModel = workXml
				.getActivity(sourceActivityVo.getActivityDefinitionId());
        String checkFinish=sourceActivityModel.getExtendedAttribute(checkFinishStr);
        if (checkFinish.toLowerCase().equals("true")){
            List<PfActivityVo> activityVos=this.getTaskService().getWorkFlowInstanceActivityList(infoObj.getWorkFlowIntanceVo().getWorkflowIntanceId());
            for(PfActivityVo activityVo:activityVos){
                if (activityVo.getActivityState()==WorkFlowEnum.ACTIVITY_START){
                    String users=getTaskUsers(activityVo.getActivityId());
                    throw new WorkFlowException(MessageFormat.format("仍有活动【{0}】正在办理中，办理人：{1}", activityVo.getActivityName(),users));
                }
            }
        }
		return true;
	}


    private String getTaskUsers(String activityId){
        String users="";
        List<PfTaskVo> tasks=this.getTaskService().getTaskListByActivity(activityId);
        for(PfTaskVo task:tasks){
            users=users+ task.getUserVo().getUserName()+" ";
        }
        return users;
    }
}
