package com.gtis.plat.wf.bean;

import java.util.ArrayList;
import java.util.List;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import org.apache.commons.lang.ArrayUtils;

public class WorkFlowBeanUtil {
	
	/**
	 * 根据模型中的定义创建PfActivityVo对象
	 * @param activityModel
	 * @return
	 */
	public static PfActivityVo createActivityVoByModel(ActivityModel activityModel){
		PfActivityVo activityVo = new PfActivityVo();
		activityVo.setActivityDefinitionId(activityModel.getDefineId());
		activityVo.setActivityName(activityModel.getActivityDefineName());
		activityVo.setTimeLimit(activityModel.getLimit());
		activityVo.setPriority(activityModel.getPriority());
		activityVo.setActivityState(WorkFlowEnum.ACTIVITY_START);
		activityVo.setOrganId(activityModel.getOrganId());
        if(activityModel.getRiskModelList() != null && !activityModel.getRiskModelList().isEmpty()){
            activityVo.setRisk(1);
        }
		return activityVo;
	}
	
//	public static List<PfTaskVo> createTaskListByModel(List<ActivityModel> activityModelList){
//		List<String> userIds=new ArrayList<String>();
//		for (ActivityModel activityModel:activityModelList){
//			List<PerformerTaskModel> taskModels=activityModel.getPerformerModelList();
//			for(PerformerTaskModel taskModel:taskModels){
//				List<PfUserVo> userList=taskModel.getUserList();
//				for(PfUserVo vo:userList){
//					userIds.add(vo.getUserId());
//				}
//			}
//		}
//		List<PfTaskVo> result=new ArrayList<PfTaskVo>();
//		for(String userId:userIds){
//			PfTaskVo vo=new PfTaskVo();
//			vo.setTaskId(UUIDGenerator.generate());
//			vo.setAccepted(false);
//			PfUserVo userVo=new PfUserVo();
//			userVo.setUserId(userId);
//			vo.setUserVo(userVo);
//			result.add(vo);
//		}
//		return result;
//	}	
	
	public static List<PfTaskVo> createTasks(List<PerformerTaskModel> lstTaskModel,String activityId,String taskBefore){
		List<PfTaskVo> result=new ArrayList<PfTaskVo>();
        if(lstTaskModel != null){
            for(PerformerTaskModel taskModel:lstTaskModel){
                List<PfUserVo> userList=taskModel.getUserList();
                for(PfUserVo vo:userList){
                    result.add(createTask(vo.getUserId(),activityId,taskModel.getId(),taskBefore));
                }
            }
        }
		return result;
	}
	
	public static PfTaskVo createTask(String userId,String activityId,String performerId,String taskBefore){
		PfTaskVo vo=new PfTaskVo();
		vo.setTaskId(UUIDGenerator.generate());
		vo.setAccepted(false);
		vo.setActivityId(activityId);
        vo.setPerformerId(performerId);
        vo.setTaskBefore(taskBefore);
		PfUserVo userVo=new PfUserVo();
		userVo.setUserId(userId);
		vo.setUserVo(userVo);
		return vo;
	}
}
