package com.gtis.plat.wf.bean;

import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import org.apache.commons.lang.StringUtils;

public class LockWorkFlowInstanceBean extends WorkFlowBeanAbstract {

	/**
	 * 挂起工作流
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		String workflowIntanceId = infoObj.getWorkFlowIntanceVo()
				.getWorkflowIntanceId();
		PfWorkFlowInstanceVo intanceVo = super.getWorFlowInstanceService()
				.getWorkflowInstance(workflowIntanceId);
		if (intanceVo.getWorkflowState() != WorkFlowEnum.WORKFLOW_STOP) {
			intanceVo.setWorkflowState(WorkFlowEnum.WORKFLOW_STOP);
			//intanceVo.setRemark(infoObj.getWorkFlowIntanceVo().getRemark());
            PfTaskVo sourceTask=super.getTaskService().getTask(infoObj.getSourceTask().getTaskId());
            //super.getTaskService().getActivity(sourceTask.getActivityId());
            if (StringUtils.isNotBlank(infoObj.getWorkFlowIntanceVo().getRemark()))
                super.getTaskService().updateActivityRemark(sourceTask.getActivityId(),infoObj.getWorkFlowIntanceVo().getRemark());
			super.getWorFlowInstanceService().updateWorkFlowIntanceStadus(
                    intanceVo);
		}else{
			throw new WorkFlowException(WorkFlowException.ExceptionNum.AlreadyStop);
		}
		return true;
	}
}
