package com.gtis.plat.wf.bean;

import java.util.List;

import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowInfo;

public class EcSuperviseHandler extends WorkFlowBeanAbstract{
	private SysSupervisorService supervisorService;
	private String supervisorExplain;
	
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		if(infoObj.getWorkFlowDefineVo().getIsMonitor() == 1){
			String activityId = infoObj.getSourceActivity().getActivityId();
			List<EcSupervisorVo> supervisorVoList = supervisorService.getUnansweredSupervisorVoListByActivityId(activityId);
			System.out.println(supervisorVoList);
			for(EcSupervisorVo supervisor : supervisorVoList){
				supervisor.setSupervisorExplain(supervisorExplain);
				supervisorService.updateSuperviseExplain(supervisor);
			}
		}
		return true;
	}

	public SysSupervisorService getSupervisorService() {
		return supervisorService;
	}

	public void setSupervisorService(SysSupervisorService supervisorService) {
		this.supervisorService = supervisorService;
	}

	public String getSupervisorExplain() {
		return supervisorExplain;
	}

	public void setSupervisorExplain(String supervisorExplain) {
		this.supervisorExplain = supervisorExplain;
	}
}
