package com.gtis.plat.wf.bean;

import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.util.Calendar;
import java.util.List;

public class CreateWorkFlowTaskBean extends WorkFlowBeanAbstract {

	/**
	 * 创建工作流实例
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		//创建活动
		if (infoObj.getTargetActivitys() != null && infoObj.getTargetActivitys().size()>0){
			for(PfActivityVo activityVo: infoObj.getTargetActivitys()){
				//activityVo.setActivityBefore(infoObj.getSourceActivity().getActivityId());
//                if (infoObj.getSourceActivity()!=null
//                        && infoObj.getSourceActivity().isBackState()
//                        && activityVo.getActivityState()!= WorkFlowEnum.ACTIVITY_BACK)
//                    activityVo.setBackState(true);
                activityVo.setActivityState(WorkFlowEnum.ACTIVITY_START);
				this.getTaskService().createActivity(activityVo);
			}
		}
		//创建任务
		if (infoObj.getTargetTasks() != null && infoObj.getTargetTasks().size()>0){
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
               //////判断任务是否退回任务
                List<PfTaskVo> userTasks= this.getTaskService().getHistoryTaskListByActivity(taskVo.getActivityId());
                if (userTasks!=null && userTasks.size()>0 && infoObj.getSourceTask().isBackState())
                    taskVo.setBackState(true);
                this.getTaskService().createTask(taskVo);
                //判断任务是否需要委托
                PfActivityVo activityVo=this.getTaskService().getActivity(taskVo.getActivityId());
                PfWorkFlowInstanceVo instanceVo=this.getWorFlowInstanceService().getWorkflowInstance(activityVo.getWorkflowInstanceId());
                beginTrustTask(taskVo.getUserVo().getUserId(),instanceVo.getWorkflowDefinitionId() , activityVo.getActivityDefinitionId(),taskVo.getTaskId());
            }
		}
		return true;
	}
    private void beginTrustTask(String userId,String workflowDefineId,String activityDefineId,String taskId) throws Exception{
        String trustUserId=getTrustAgentUserId(userId,workflowDefineId,activityDefineId);
        if (StringUtils.isNotBlank(trustUserId)){
            WorkFlowCoreService workFlowCoreService=(WorkFlowCoreService)Container.getBean("WorkFlowCoreService");
            workFlowCoreService.entrustTask(taskId,trustUserId);
        }
    }
    /**
     * 查找任务的委托人
     * @param userId
     * @param workflowDefineId
     * @param activityDefineId
     * @return
     */
    private String getTrustAgentUserId(String userId,String workflowDefineId,String activityDefineId){
        String trustAgentUserId=null;
        List<PfTaskAgentVo> agentUsers=this.userService.getTaskAgentListByUser(userId);
        if (agentUsers!=null){
            for(PfTaskAgentVo taskAgentVo:agentUsers){
                if (taskAgentVo.getWorkFlowDefinitionId()==null || taskAgentVo.getWorkFlowDefinitionId().equals(workflowDefineId)){
                    if (StringUtils.isBlank(taskAgentVo.getActivityDefinitionId()) ||
                            taskAgentVo.getActivityDefinitionId().equals(activityDefineId)){
                        if (taskAgentVo.getBeginTime()==null || taskAgentVo.getBeginTime().before(Calendar.getInstance().getTime()) ){
                            if (taskAgentVo.getEndTime()==null || taskAgentVo.getEndTime().after(Calendar.getInstance().getTime()) ){
                                trustAgentUserId= taskAgentVo.getUserId();
                                break;
                            }
                        }
                    }
                }
            }
        }
        return trustAgentUserId;
    }

}
