package com.gtis.plat.wf.bean;

import com.gtis.plat.wf.WorkFlowBeanAbstract;
import com.gtis.plat.wf.WorkFlowEnum;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;

public class CreateWorkFlowInstanceBean extends WorkFlowBeanAbstract {
	
	/**
	 * 创建工作流实例
	 */
	public boolean doWork(WorkFlowInfo infoObj) throws Exception {
		if (infoObj.getWorkFlowIntanceVo() != null){
			//设置创建人
			infoObj.getWorkFlowIntanceVo().setCreateUser(infoObj.getUserId());
			//默认状态
			infoObj.getWorkFlowIntanceVo().setWorkflowState(WorkFlowEnum.WORKFLOW_START);
			//默认优先级
			if (infoObj.getWorkFlowIntanceVo().getPriority()==null)
				infoObj.getWorkFlowIntanceVo().setPriority("1");
			
			// 处理地区编码
			if (infoObj.getWorkFlowIntanceVo().getRegionCode() == null) {
				String regionCode = this.getUserService().getUserRegionCode(infoObj.getUserId());
				infoObj.getWorkFlowIntanceVo().setRegionCode(regionCode);
			}
			this.getWorFlowInstanceService().createWorkFlowIntance(
					infoObj.getWorkFlowIntanceVo());
			
			if (infoObj.getTargetActivitys() == null || infoObj.getTargetActivitys().size()==0){
				throw new WorkFlowException(WorkFlowException.ExceptionNum.NoActivty);
			}
			if (infoObj.getTargetTasks() == null || infoObj.getTargetTasks().size()==0){
				throw new WorkFlowException(WorkFlowException.ExceptionNum.NoUsers);
			}
		}
		return true;
	}

}
