package com.gtis.plat.wf;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Transactional(readOnly = true)
public class WorkFlowCoreServiceImpl implements WorkFlowCoreService {
    private String smsMsg;

    private SysSmsService smsService;

    private SysUserService userService;

    private List<WorkFlowBean> createWorkFlowBeans;

    private List<WorkFlowBean> getWorkFlowTurnInfoBeans;

    private List<WorkFlowBean> getWorkFlowTurnBackInfoBeans;

    private List<WorkFlowBean> turnWorkFlowBeans;

    private List<WorkFlowBean> delWorkFlowBean;

    private List<WorkFlowBean> lockWorkFlowBean;

    private List<WorkFlowBean> unLockWorkFlowBean;

    private List<WorkFlowBean> finishWorkFlowBean;

    private List<WorkFlowBean> turnBackWorkFlowBeans;

    private List<WorkFlowBean> retrieveWorkFlowBeans;

    private List<WorkFlowBean> restartWorkFlowBeans;

    private List<WorkFlowBean> entrustWorkFlowBeans;

    public void setEntrustWorkFlowBeans(List<WorkFlowBean> entrustWorkFlowBeans) {
        this.entrustWorkFlowBeans = entrustWorkFlowBeans;
    }

    public List<WorkFlowBean> getRetrieveWorkFlowBeans() {
        return retrieveWorkFlowBeans;
    }

    public void setRetrieveWorkFlowBeans(List<WorkFlowBean> retrieveWorkFlowBeans) {
        this.retrieveWorkFlowBeans = retrieveWorkFlowBeans;
    }

    static Log log = LogFactory.getLog(WorkFlowCoreServiceImpl.class);


    /**
     * 委托任务
     * @param taskId
     * @param trustUserId 被委托人
     * @return
     * @throws Exception
     */
    @Transactional
    public boolean entrustTask(String taskId,String trustUserId) throws Exception{
        if (entrustWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(trustUserId);
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);


            try {
                doWorkBeans(infoObj, entrustWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
                return false;
            }
        }
        return true;
    }

    /**
     * 创建工作流
     */
    @Transactional
    public WorkFlowInfo createWorkFlowInstance(
            PfWorkFlowInstanceVo workFlowIntanceVo, String userId)
            throws Exception {
        if (createWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                doWorkBeans(infoObj, createWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getCreateWorkFlowBeans() {
        return createWorkFlowBeans;
    }

    public void setCreateWorkFlowBeans(List<WorkFlowBean> createWorkFlowBeans) {
        this.createWorkFlowBeans = createWorkFlowBeans;
    }


    /**
     * 任务转发信息
     */
    public WorkFlowInfo getWorkFlowTurnInfo(String userId, String taskId) throws Exception {
        if (getWorkFlowTurnInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                doWorkBeans(infoObj, getWorkFlowTurnInfoBeans);
            } catch (Exception e) {
                throw e;
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnInfoBeans() {
        return getWorkFlowTurnInfoBeans;
    }

    public void setGetWorkFlowTurnInfoBeans(
            List<WorkFlowBean> getWorkFlowTurnInfoBeans) {
        this.getWorkFlowTurnInfoBeans = getWorkFlowTurnInfoBeans;
    }

    /**
     * 工作流转发
     */
    @Transactional
    public boolean postWorkFlow(String userId, String taskId, WorkFlowInfo infoObj)
            throws Exception {
        if (turnWorkFlowBeans != null) {
            try {
                return doWorkBeans(infoObj, turnWorkFlowBeans);
            } catch (Exception e) {
                throw e;
            }
        }
        return false;
    }

    /**
     * 工作流退回
     */
    @Transactional
    public boolean postBackWorkFlow(String userId, String taskId, String[] backDefineActivitys, String remark) throws Exception {
        if (turnBackWorkFlowBeans != null) {
            try {
                WorkFlowInfo infoObj = new WorkFlowInfo();
                infoObj.setUserId(userId);
                /////退回备注
                WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
                transInfo.setRemark(remark);
                infoObj.setTransInfo(transInfo);
                /////
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
                List<PfActivityVo> backActivitys = new ArrayList<PfActivityVo>();
                for (int i = 0; i < backDefineActivitys.length; i++) {
                    PfActivityVo aVo = new PfActivityVo();
                    aVo.setActivityDefinitionId(backDefineActivitys[i]);
                    backActivitys.add(aVo);
                }
                infoObj.setTargetActivitys(backActivitys);
                return doWorkBeans(infoObj, turnBackWorkFlowBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    log.error("-----工作流引擎错误：" + e.getMessage(), e);
                    throw e;
                }

            }
        }
        return false;
    }

    /**
     * 工作流重新开始
     *
     * @param userId
     * @param wiid
     * @param remark
     * @return
     * @throws Exception
     */
    @Transactional
    public boolean restartWorkFlow(String userId, String wiid, String remark) throws Exception {
        if (restartWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            infoObj.setUserId(userId);
            /////重新开始备注
            WorkFlowTransInfo transInfo = new WorkFlowTransInfo();
            transInfo.setRemark(remark);
            infoObj.setTransInfo(transInfo);
            /////
            PfWorkFlowInstanceVo intanceVo = new PfWorkFlowInstanceVo();
            intanceVo.setWorkflowIntanceId(wiid);
            infoObj.setWorkFlowIntanceVo(intanceVo);
            return doWorkBeans(infoObj, restartWorkFlowBeans);
        }
        return false;
    }

    @Transactional
    public boolean turnTask(Document doc, String taskId) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = getWorkFlowTurnInfo(userId, taskId);
        WorkFlowXml xmlUtil = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlUtil.getActivity(info.getSourceActivity().getActivityDefinitionId());
//        doc = httpFilterXml(doc,activityModel);
        List<Node> activityList = doc.selectNodes("//Activity");
        List<String> activitys = new ArrayList<String>();
        for (Node node : activityList) {
            activitys.add(node.valueOf("@Id"));
        }
        //处理活动
        List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
        for (Iterator<ActivityModel> itModel = lstActivityModel.iterator(); itModel.hasNext(); ) {
            ActivityModel model = itModel.next();
            if (!activitys.contains(model.getDefineId())) {
                itModel.remove();
            } else {
                //处理活动中的任务
                List<PerformerTaskModel> lstPerformer = model.getPerformerModelList();
                List<Node> lstUser = (List<Node>) doc.selectNodes("//Activity[@Id='"
                        + model.getDefineId() + "']/UserInfo");
                List<String> userIds = new ArrayList<String>();
                List<String> performerIds = new ArrayList<String>();   //转发任务中，人员的部门或角色ids
                for (Node node : lstUser) {
                    if (node.valueOf("@RoleId") != null){
                        performerIds.add(node.valueOf("@RoleId"));
                        //如果id为空或者-1表示该角色下所有人
                        if (StringUtils.isBlank(node.valueOf("@Id")) || node.valueOf("@Id").equals("-1")) {
                            userIds.addAll(getUsersByRoleId(node.valueOf("@RoleId")));
                        }else{
                            userIds.add(node.valueOf("@Id"));
                        }
                    }else{
                        if (StringUtils.isNotBlank(node.valueOf("@Id")))
                            userIds.add(node.valueOf("@Id"));
                    }
                }
                List<String> userTmpList = new ArrayList<String>();
                //过滤用户
                if (userIds.size() > 0) {
                    //for(PerformerTaskModel taskModel:lstPerformer){
                    for (Iterator<PerformerTaskModel> itPerformer = lstPerformer.iterator(); itPerformer.hasNext(); ) {
                        PerformerTaskModel taskModel = itPerformer.next();
                        if (taskModel.getId() != null && !performerIds.contains(taskModel.getId())) {
                            itPerformer.remove();
                            continue;
                        }
                        for (Iterator<PfUserVo> it = taskModel.getUserList().iterator(); it.hasNext(); ) {
                            PfUserVo vo = (PfUserVo) it.next();
                            if (userTmpList.contains(vo.getUserId())) {
                                it.remove();
                            } else {
                                if (!userIds.contains(vo.getUserId())) {
                                    //taskModel.getUserList().remove(vo);
                                    it.remove();
                                } else {
                                    userTmpList.add(vo.getUserId());
                                }
                            }
                        }
                    }
                }

            }
        }
        // 备注
        Node remarkNode = doc.selectSingleNode("//ReMark/text");
        if (remarkNode != null) {
            if (!"".equals(remarkNode.getText().trim()))
                info.getTransInfo().setRemark(remarkNode.getText());
        }
        //开始转发
        postWorkFlow(userId, taskId, info);

        boolean  sendSms="always".equalsIgnoreCase(activityModel.getIsSendSMS());
        if (Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS")) || sendSms) {
            sendTaskSMS(info);
        }


        return false;
    }

    /**
     * 根据角色id或者所有的人
     * @param roleId
     * @return
     */
    private List<String> getUsersByRoleId(String roleId){
        List<PfUserVo> users=userService.getUserListByRole(roleId);
        if (users==null || users.size()==0){
            users=userService.getUserListByOragn(roleId);
        }
        List<String> result=new ArrayList<String>();
        for(PfUserVo userVo:users){
            result.add(userVo.getUserId());
        }
        return result;
    }
    
    public void setRestartWorkFlowBeans(List<WorkFlowBean> restartWorkFlowBeans) {
        this.restartWorkFlowBeans = restartWorkFlowBeans;
    }

    /**
     * 删除工作流实例
     */
    @Transactional
    public boolean deleteWorkFlowInstance(String userId, String workflowIntanceId) throws Exception {
        if (delWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            infoObj.setUserId(userId);
            try {
                return doWorkBeans(infoObj, delWorkFlowBean);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }

    public List<WorkFlowBean> getTurnWorkFlowBeans() {
        return turnWorkFlowBeans;
    }

    public void setTurnWorkFlowBeans(List<WorkFlowBean> turnWorkFlowBeans) {
        this.turnWorkFlowBeans = turnWorkFlowBeans;
    }

    public List<WorkFlowBean> getDelWorkFlowBean() {
        return delWorkFlowBean;
    }

    public void setDelWorkFlowBean(List<WorkFlowBean> delWorkFlowBean) {
        this.delWorkFlowBean = delWorkFlowBean;
    }

    @Transactional
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId, String remark) throws Exception {
        if (lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            workFlowIntanceVo.setRemark(remark);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return doWorkBeans(infoObj, lockWorkFlowBean);
            } catch (Exception e) {
//				log.error("-----工作流引擎错误：",e);
            }
        }
        return false;
    }

    @Transactional
    public boolean lockWorkFlowInstance(String workflowIntanceId, String taskId) throws Exception {
        if (lockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            if (taskId != null && !taskId.equals("")) {
                PfTaskVo taskVo = new PfTaskVo();
                taskVo.setTaskId(taskId);
                infoObj.setSourceTask(taskVo);
            }
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return doWorkBeans(infoObj, lockWorkFlowBean);
            } catch (Exception e) {
                log.error("-----工作流引擎错误：", e);
            }
        }
        return false;
    }

    @Transactional
    public boolean unLockWorkFlowInstance(String workflowIntanceId) throws Exception {
        if (unLockWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            try {
                return doWorkBeans(infoObj, unLockWorkFlowBean);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }

    public List<WorkFlowBean> getLockWorkFlowBean() {
        return lockWorkFlowBean;
    }

    public void setLockWorkFlowBean(List<WorkFlowBean> lockWorkFlowBean) {
        this.lockWorkFlowBean = lockWorkFlowBean;
    }

    public List<WorkFlowBean> getUnLockWorkFlowBean() {
        return unLockWorkFlowBean;
    }

    public void setUnLockWorkFlowBean(List<WorkFlowBean> unLockWorkFlowBean) {
        this.unLockWorkFlowBean = unLockWorkFlowBean;
    }

    @Transactional
    public boolean finishWorkFlow(WorkFlowInfo infoObj) throws Exception {
        if (finishWorkFlowBean != null) {
            try {
                return doWorkBeans(infoObj, finishWorkFlowBean);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                    throw ex;
                } else {
                    throw e;
                }
            }
        }
        return false;
    }

    @Transactional
    public boolean finishWorkFlow(String workflowIntanceId) throws Exception {
        if (finishWorkFlowBean != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfWorkFlowInstanceVo workFlowIntanceVo = new PfWorkFlowInstanceVo();
            workFlowIntanceVo.setWorkflowIntanceId(workflowIntanceId);
            infoObj.setWorkFlowIntanceVo(workFlowIntanceVo);
            finishWorkFlow(infoObj);
        }
        return false;
    }

    public List<WorkFlowBean> getFinishWorkFlowBean() {
        return finishWorkFlowBean;
    }

    public void setFinishWorkFlowBean(List<WorkFlowBean> finishWorkFlowBean) {
        this.finishWorkFlowBean = finishWorkFlowBean;
    }

    @Transactional
    public boolean doWorkBeans(WorkFlowInfo infoObj, List<WorkFlowBean> beans) throws Exception {
        try {
            for (WorkFlowBean step : beans) {
                boolean result = step.doWork(infoObj);
                if (!result) break;
            }
            return true;
        } catch (Exception e) {
            throw e;
        }
    }

    /**
     * 返回可以退回的活动id和名称
     */
    public WorkFlowInfo getWorkFlowTurnBackInfo(String userId, String taskId)
            throws Exception {
        if (getWorkFlowTurnBackInfoBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                doWorkBeans(infoObj, getWorkFlowTurnBackInfoBeans);
            } catch (Exception e) {
                if (e instanceof WorkFlowException) {
                    WorkFlowException ex = (WorkFlowException) e;
                    log.error("-----工作流引擎错误：" + ex.getMessage(), ex);
                } else {
                    throw e;
                }
            }
            return infoObj;
        }
        return null;
    }

    public List<WorkFlowBean> getGetWorkFlowTurnBackInfoBeans() {
        return getWorkFlowTurnBackInfoBeans;
    }

    public void setGetWorkFlowTurnBackInfoBeans(
            List<WorkFlowBean> getWorkFlowTurnBackInfoBeans) {
        this.getWorkFlowTurnBackInfoBeans = getWorkFlowTurnBackInfoBeans;
    }

    public List<WorkFlowBean> getTurnBackWorkFlowBeans() {
        return turnBackWorkFlowBeans;
    }

    public void setTurnBackWorkFlowBeans(List<WorkFlowBean> turnBackWorkFlowBeans) {
        this.turnBackWorkFlowBeans = turnBackWorkFlowBeans;
    }

    @Transactional
    public boolean retrieveWorkFlow(String userId, String taskId) throws Exception {
        if (this.retrieveWorkFlowBeans != null) {
            WorkFlowInfo infoObj = new WorkFlowInfo();
            PfTaskVo taskVo = new PfTaskVo();
            taskVo.setTaskId(taskId);
            infoObj.setSourceTask(taskVo);
            try {
                return doWorkBeans(infoObj, this.retrieveWorkFlowBeans);
            } catch (Exception e) {
                throw e;
            }
        }
        return false;
    }

    /**
     * 短信发送
     *
     * @param info
     */
    private void sendTaskSMS(WorkFlowInfo info) {

//        List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
//        for (Iterator<ActivityModel> itModel = lstActivityModel.iterator(); itModel.hasNext(); ) {
//            ActivityModel model = itModel.next();
//            model.get
//        }
        List<PfTaskVo> taskList = info.getTargetTasks();
        HashMap praseMap = new HashMap();
        praseMap.put("workflowName", info.getWorkFlowIntanceVo().getWorkflowIntanceName());
//            praseMap.put("createUser", SessionUtil.getUserName(ServletActionContext.getRequest()));
        praseMap.put("createTime", CommonUtil.formateDate(info.getWorkFlowIntanceVo().getCreateTime()));
        StrSubstitutor sub = new StrSubstitutor(praseMap, "%{", "}");
        String tempSms = sub.replace(smsMsg);
        for (PfTaskVo task : taskList) {
            PfUserVo user = userService.getUserVo(task.getUserVo().getUserId());
            if (user.getMobilePhone() != null) {
                try {
                    smsService.sendMsg("系统发送", user.getUserName(), user.getMobilePhone(), tempSms);
                } catch (Exception e) {
                    log.debug(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 通过TurnInfo处理url
     *
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc, ActivityModel actModel) {
        if (StringUtils.isNotBlank(actModel.getTurnInfoUrl())) {
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new PostMethod(actModel.getTurnInfoUrl());
            NameValuePair[] data = {
                    new NameValuePair("turnInfo", doc.asXML())
            };
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}", e);
            }
            if (status == HttpStatus.SC_OK) {
                SAXReader reader = new SAXReader();
                try {
                    doc = reader.read(postMethod.getResponseBodyAsString());
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}", e);
                }
            } else {
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

     @Transactional(rollbackFor=Exception.class)
    public boolean turnTask(String xml, String taskId, String userId) throws Exception {
             Document doc = DocumentHelper.parseText(xml);
            WorkFlowInfo info = getWorkFlowTurnInfo(userId, taskId);
            List<Node> activityList = doc.selectNodes("//Activity");
            List<String> activitys=new ArrayList<String>();
            for (Node node : activityList) {
                activitys.add(node.valueOf("@Id"));
            }
            //处理活动
            List<ActivityModel> lstActivityModel= info.getTransInfo().getTranActivitys();

            for (Iterator<ActivityModel> itModel = lstActivityModel.iterator();itModel.hasNext();){
                ActivityModel model=itModel.next();
                if (!activitys.contains(model.getDefineId())){
                    itModel.remove();
                }else{
                    //处理活动中的任务
                    List<PerformerTaskModel> lstPerformer= model.getPerformerModelList();
                    List<Node> lstUser = (List<Node>) doc.selectNodes("//Activity[@Id='"
                            + model.getDefineId() + "']/UserInfo");
                    List<String> userIds=new ArrayList<String>();
                    List<String> performerIds=new ArrayList<String>();   //转发任务中，人员的部门或角色ids
                    for (Node node : lstUser) {
                        if (node.valueOf("@Id").equals("-1")){      //表示该角色或部门的所有人
                            break;
                        }else{
                            userIds.add(node.valueOf("@Id"));
                            if (node.valueOf("@RoleId")!=null)
                                performerIds.add(node.valueOf("@RoleId"));
                        }
                    }
                    List<String> userTmpList=new ArrayList<String>();
                    //过滤用户
                    if (userIds.size()>0){
                        //for(PerformerTaskModel taskModel:lstPerformer){
                        for (Iterator<PerformerTaskModel> itPerformer =lstPerformer.iterator();itPerformer.hasNext();){
                            PerformerTaskModel taskModel= itPerformer.next();
                            if (taskModel.getId()!=null && !performerIds.contains(taskModel.getId())){
                                itPerformer.remove();
                                continue;
                            }
                            for (Iterator<PfUserVo> it = taskModel.getUserList().iterator();it.hasNext();){
                                 PfUserVo vo = (PfUserVo)it.next();
                                 if (userTmpList.contains(vo.getUserId())){
                                     it.remove();
                                 }else{
                                     if (!userIds.contains(vo.getUserId())){
                                        //taskModel.getUserList().remove(vo);
                                        it.remove();
                                     }else{
                                         userTmpList.add(vo.getUserId());
                                     }
                                 }
                             }
                        }
                    }
                }
            }
            // 备注
            Node remarkNode = doc.selectSingleNode("//ReMark/text");
            if (remarkNode != null){
                if (!"".equals(remarkNode.getText().trim()))
                    info.getTransInfo().setRemark(remarkNode.getText());
            }
            //开始转发
            postWorkFlow(userId, taskId, info);

            if(Boolean.parseBoolean(doc.selectSingleNode("/Activitys").valueOf("@SendSMS"))){
                sendTaskSMS(info);
            }

        return false;
    }

    public void setSmsService(SysSmsService smsService) {
        this.smsService = smsService;
    }

    public void setUserService(SysUserService userService) {
        this.userService = userService;
    }

    public void setSmsMsg(String smsMsg) {
        this.smsMsg = smsMsg;
    }
}
