package com.gtis.plat.service.impl.search;

import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.search.EntityIndexProvider;
import com.gtis.search.IndexManager;
import org.springframework.aop.AfterReturningAdvice;

import java.lang.reflect.Method;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-11
 */
public class WorkFlowIndexAdvice implements AfterReturningAdvice {

    private SysTaskService taskService;
    private SysActivityService activityService;
    private IndexManager indexManager;
    private EntityIndexProvider<PfWorkFlowInstanceVo> indexProvider;

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setIndexProvider(EntityIndexProvider<PfWorkFlowInstanceVo> indexProvider) {
        this.indexProvider = indexProvider;
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        String name = method.getName();
        WorkFlowInfo info = null;
        String wiid = null;
        if ("deleteWorkFlowInstance".equals(name)) {
            wiid = (String) args[1];
            indexManager.remove(wiid);
            return;
        } else if ("createWorkFlowInstance".equals(name)) {
            info = (WorkFlowInfo) returnValue;
        } else if ("postWorkFlow".equals(name)) {
            info = (WorkFlowInfo) args[2];
        } else if ("postBackWorkFlow".equals(name)) {
            wiid = getWiidByTaskId((String) args[1]);
        } else if ("lockWorkFlowInstance".equals(name) || "unLockWorkFlowInstance".equals(name)) {
            wiid = (String) args[0];
        } else if ("finishWorkFlow".equals(name)) {
            if (args[0] instanceof String) {
                wiid = (String) args[0];
            } else {
                info = (WorkFlowInfo) args[0];
            }
        } else if ("retrieveWorkFlow".equals(name)) {
            wiid = getWiidByTaskId((String) args[1]);
        } else if ("restartWorkFlow".equals(name)) {
            wiid = (String) args[1];
        } else if ("turnTask".equals(name)) {
            wiid = getWiidByTaskId((String) args[1]);
        }
        if(info!=null){
            indexManager.update(indexProvider.toIndex(info.getWorkFlowIntanceVo()));
        }else if(wiid!=null){
            indexManager.update(indexProvider.getIndex(null, wiid));
        }
    }

    /**
     *
     * @param taskId
     * @return
     */
    private String getWiidByTaskId(String taskId) {
        PfTaskVo taskVo=taskService.getTask(taskId);
        if (taskVo==null)
            taskVo=taskService.getHistoryTask(taskId);
        return activityService.getActivityById(taskVo.getActivityId()).getWorkflowInstanceId();
    }
}
