package com.gtis.plat.service.impl.search;

import com.gtis.dao.ibatis.IbatisDataAccess;
import com.gtis.search.SearchService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;

import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-11-28
 */
@SuppressWarnings("unchecked")
public class IndexSupportIbatisDataAccess extends IbatisDataAccess {

    private SearchService searchService;
    private boolean enabled;
    private Set<String> enabledQuerys = new HashSet<String>();

    public IndexSupportIbatisDataAccess() {
        Collections.addAll(enabledQuerys, "getTaskList", "getTaskOverList", "getProjectList");
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getCount(SplitParam param) {
        if (!enabled || !enabledQuerys.contains(param.getQueryString())) {
            return super.getCount(param);
        }
        return searchService.search(null, toFilter(param), "wf", param.getQueryString(), null, null, 0, 0).getTotalCount();
    }

    @Override
    public List queryForList(SplitParam param, int skipSize, int pageSize) {
        if (!enabled || !enabledQuerys.contains(param.getQueryString())) {
            return super.queryForList(param, skipSize, pageSize);
        }
        Map<String, String> map = (Map) param.getQueryParam();
        String order = map.get("_orderdir_");
        String orderField = map.get("_orderfield_");
        if ("CREATE_TIME".equals(orderField) || "BEGIN_TIME".equals(orderField) || "FINISH_TIME".equals(orderField)) {
            orderField += "_t";
        } else if ("IDAY".equals(orderField) || "CDAY".equals(orderField) || "WORKFLOW_STATE".equals(orderField)) {
            orderField += "_i";
        } else {
            orderField += "_s";
        }
        return searchService.search(null, toFilter(param), "wf", param.getQueryString(), orderField, order, skipSize, pageSize).getItems();
    }

    private Map<String, Object> toFilter(SplitParam param) {
        Map<String, Object> filter = new HashMap<String, Object>();
        if (!SessionUtil.getCurrentUser().isAdmin()) {
            //filter.put("USER_ID", SessionUtil.getCurrentUserId());
        }
        Map<String, String> map = (Map) param.getQueryParam();
        map.remove("userIds");
        map.remove("_query");
        map.remove("_orderfield_");
        map.remove("_orderdir_");
        if (map != null) {
            filter.putAll(map);
        }
        return filter;
    }
}
