package com.gtis.plat.service.impl.search;

import com.gtis.plat.service.FormDataService;
import com.gtis.search.DataFetcher;

import java.io.Serializable;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class FormDataDataFetcher implements DataFetcher {
    private String[] formCodes;
    private Set<String> fields = new HashSet<String>();
    private FormDataService formDataService;

    public void setFormCodes(String[] formCodes) {
        this.formCodes = formCodes;
    }

    public void setFields(String[] fields) {
        for (String field : fields) {
            this.fields.add(field.toLowerCase());
        }
    }

    public void setFormDataService(FormDataService formDataService) {
        this.formDataService = formDataService;
    }

    public Map<String, Object> fetchData(String id) {
        Map<String, Object> dataMap = new HashMap<String, Object>();
        for (String code : formCodes) {
            for (Map.Entry<String, String> entry : formDataService.getData(code, id).entrySet()) {
                String key = entry.getKey().toLowerCase();
                if (fields.contains(key)) {
                    dataMap.put(key, entry.getValue());
                }
            }
        }
        return dataMap;
    }

    public String getDescription() {
        return getClass() + " formCodes:[" + Arrays.toString(formCodes) + "]";
    }
}
