package com.gtis.plat.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.dao.SysWorkFlowInstanceRelDao;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public class SysWorkFlowInstanceRelServicelImpl implements SysWorkFlowInstanceRelService {

    private static final Logger logger = LoggerFactory.getLogger(SysWorkFlowInstanceRelServicelImpl.class);

    private SysWorkFlowInstanceRelDao workFlowInstanceRelDao;

    public void setWorkFlowInstanceRelDao(SysWorkFlowInstanceRelDao workFlowInstanceRelDao) {
        this.workFlowInstanceRelDao = workFlowInstanceRelDao;
    }

    /**
     *   获得任务关联的其他项目列表
     * @param workflowIntanceId
     * @return
     */
    @Transactional(readOnly = true)
    public List<PfWorkFlowInstanceVo> getWorkFlowRelList(String workflowIntanceId) {
        return workFlowInstanceRelDao.getWorkFlowRelList(workflowIntanceId);
    }

    /**
     * 插入项目的关联关系
     * @param workflowIntanceId
     * @param workflowIntanceRid
     */
    @Transactional
    public void insertWorkFlowRel(String workflowIntanceId,String workflowIntanceRid){
        PfWorkFlowInstanceRelVo workFlowInstanceRelVo=new PfWorkFlowInstanceRelVo();
        workFlowInstanceRelVo.setRelId(UUIDGenerator.generate());
        workFlowInstanceRelVo.setWorkflowIntanceId(workflowIntanceId);
        workFlowInstanceRelVo.setWorkflowIntanceRid(workflowIntanceRid);
        workFlowInstanceRelDao.insertWorkFlowRel(workFlowInstanceRelVo);
    }

    /**
     * 删除关联关系
     * @param workflowIntanceId
     * @param workflowIntanceRid
     */
    @Transactional
    public void deleteWorkFlowRel(String workflowIntanceId,String workflowIntanceRid){
        PfWorkFlowInstanceRelVo workFlowInstanceRelVo=new PfWorkFlowInstanceRelVo();
        workFlowInstanceRelVo.setWorkflowIntanceId(workflowIntanceId);
        workFlowInstanceRelVo.setWorkflowIntanceRid(workflowIntanceRid);
        workFlowInstanceRelDao.deleteWorkFlowRel(workFlowInstanceRelVo);
    }
}
