package com.gtis.plat.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.Calendar;
import java.util.List;

/**
 * 吉波
 * 利用数据库中间件完成短信发送
 *
 */
public class SysSmsSQLServiceImpl extends SysSmsServiceImpl{
    private static final Log LOG = LogFactory.getLog(SysSmsSQLServiceImpl.class);
    private JdbcTemplate jdbcTemplate;
    private String sql;
    private static int index=1;
    private String stateSql;
    private String senderUnit;

    public void setSenderUnit(String senderUnit) {
        this.senderUnit = senderUnit;
    }

    public void setStateSql(String stateSql) {
        this.stateSql = stateSql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int msgState(String msgNo) throws Exception {
        String[] msg=new String[1];
        msg[0]= msgNo;
        List result= jdbcTemplate.queryForList(stateSql,msg);
        if (result.size()>0)
            return 1;
        else
            return 0;
    }

    public String sendMsg(String sender,String receive,String phone, String content) throws Exception {
        String[] msg=new String[3];
        String result=buildIndex();
        msg[0]=result;
        msg[1]=phone;
        msg[2]=content + senderUnit;
        try{
            jdbcTemplate.update(sql,msg);
            return result;
        }catch(Exception ex){
            LOG.error("短信发送数据库中间件连接失败，请检查！",ex);
            return "";
        }
    }
    
    private static String buildIndex(){
        Calendar calCurrent=Calendar.getInstance();
        int intDay=calCurrent.get(Calendar.DATE);
        int intMonth=calCurrent.get(Calendar.MONTH)+1;
        int intYear=calCurrent.get(Calendar.YEAR);
        String now=String.valueOf(intYear)+String.valueOf(intMonth)+String.valueOf(intDay);
        now=Integer.toHexString(Integer.parseInt(now));
        index++;
        if (index>9000) index=1;
        String result=now+index;
        return result;
    }
}