package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;

import com.gtis.plat.dao.SysOpinionDao;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.vo.PfOpinionVo;

/**
 * 默认意见维护
 */
public class SysOpinionServiceImpl implements SysOpinionService{
	/** 意见持久层服务 */
	private SysOpinionDao opinionDao;

    /**
     * 根据UserID获得默认意见列表
     * @param UserId
     * @return
     */
	public List<PfOpinionVo> getOpinionListByUserId(String UserId){
		List<PfOpinionVo> opinionList = opinionDao.getOpinionListByUserIdAndDefault(UserId) ;
		return opinionList;
		
	}

     public List<PfOpinionVo> getOpinionList(String UserId){
        List<PfOpinionVo> opinionList = opinionDao.getOpinionListByUserId(UserId) ;
		return opinionList;   
     }
    /**
     * 新增默认意见
     * @param vo
     */
	public void insertOpinion (PfOpinionVo vo){
		opinionDao.insertOpinion(vo);
	}

    public void updateOpinion(PfOpinionVo vo) {
        opinionDao.updateOpinion(vo);    
    }

    /**
	根据OPIN_ID查询意见 
	*/
	public PfOpinionVo getOpinionByOpinId(String OpinId){
		
		return opinionDao.getOpinionByOpinId(OpinId);
	}


    /**
     * 删除默认意见
     * @param opinId
     */
	public void deleteOpinion (String opinId){
		
		opinionDao.deleteOpinion(opinId) ;
	}

    /**
     * 根据OPIN_ID更新意见是否 
     * @param map
     */
	public void updateIsUseByOpinId(HashMap<String, String> map){
		
		opinionDao.updateIsUseByOpinId(map);
	}

    /**
     * 根据用户Id和Type类型,查找意见列表
     * @param userId
     * @param type
     * @return
     */
	public List<PfOpinionVo> getOpinionList(String userId,String type){
        HashMap<String,String> paramsMap = new HashMap<String,String>();
        paramsMap.put("USER_ID",userId);
        paramsMap.put("TYPE",type);
        paramsMap.put("ISUSE","1");
        return opinionDao.getOpinionList(paramsMap);
    }

	public SysOpinionDao getOpinionDao() {
		return opinionDao;
	}
	public void setOpinionDao(SysOpinionDao opinionDao) {
		this.opinionDao = opinionDao;
	}
}
