package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.plat.service.SysMessageService;
import com.gtis.plat.vo.PfMessageAcceptVo;
//import com.gtis.plat.vo.PfMessageFileVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;
import com.gtis.plat.vo.PfMessageSendVo;

public class SysMessageServiceImpl implements SysMessageService {
	
	private SysMessageDAO messageDAO;
	
	public PfMessageAcceptVo getAcceptMessage(String acceptMessageId){
		
		return messageDAO.getAcceptMessage(acceptMessageId);
	}
	
	public PfMessageSendVo getSendMessage(String sendMessageId){
		return messageDAO.getSendMessage(sendMessageId);
		
	}
	
//	public List<PfMessageFileVo> getSendFile(String SendMessageId){
//		return messageDAO.getSendFile(SendMessageId);
//	}
	
	public void updateMessageStatus(String acceptMessageId){
		messageDAO.updateMessageStatus(acceptMessageId);
	}
	
	public List<String> getMessageList(HashMap<String, String> map){
		
		return messageDAO.getMessageList(map);
	}

	public SysMessageDAO getMessageDAO() {
		return messageDAO;
	}

	public void setMessageDAO(SysMessageDAO messageDAO) {
		this.messageDAO = messageDAO;
	}

	public boolean insertMessage(PfMessageSendVo pfMessageSendVo) {
		return messageDAO.insertMessage(pfMessageSendVo);
	}
	
	//lf
	public void delSendMsgById(String messageSendId)
	{
		messageDAO.delSendMsgById(messageSendId);
	}
	public void delAcceptMsgById(String messageAcceptId)
	{
		messageDAO.delAcceptMsgById(messageAcceptId);
	}
	
	public String getReadedMsgBySendId(String msgSendId){
		return messageDAO.getReadedMessageCount(msgSendId);
	}

	public List<PfMessageAcceptVo> getAcceptMsgListRss(Map<String, String> map) {
		return messageDAO.getAcceptMsgListRss(map);
	}

	
}
