package com.gtis.plat.service.impl;

import com.gtis.plat.dao.SysFormDao;
import com.gtis.plat.form.FormModel;
import com.gtis.plat.service.SysFormModelService;
import com.gtis.plat.vo.PfFormDefineVo;
import org.springframework.cache.annotation.Cacheable;

/**
 * Created with IntelliJ IDEA.
 * User: jibo
 * Date: 14-2-19
 * Time: 上午2:00
 * To change this template use File | Settings | File Templates.
 */
public class SysFormModelServiceImpl implements SysFormModelService {

    SysFormDao formDao;

    public SysFormDao getFormDao() {
        return formDao;
    }

    public void setFormDao(SysFormDao formDao) {
        this.formDao = formDao;
    }

    @Override
    @Cacheable(value="FormDefineCache",key="#defineId+'FormModelById'")
    public FormModel getFormModel(String defineId) {
        PfFormDefineVo formVo = formDao.getFormDefine(defineId);
        FormModel formModel = new FormModel();
        formModel.parseVo(formVo);
        return formModel;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    @Cacheable(value="FormDefineCache",key="#defineId+'FormById'")
    public PfFormDefineVo getFormDefineVo(String defineId) {
        return formDao.getFormDefine(defineId);
    }
}
