package com.gtis.plat.service.impl;

import java.util.HashMap;
import java.util.List;

import com.gtis.plat.dao.SysExceptionDAO;
import com.gtis.plat.service.SysExceptionService;
import com.gtis.plat.vo.EcExceptionVo;

public class SysExceptionServiceImpl implements SysExceptionService {
	private SysExceptionDAO exceptionDAO;	

	//根据instanceID获取EXCEPTION信息
	public List<EcExceptionVo> getEcExceptionByInstanceId(String instanceId) {
		return exceptionDAO.getEcExceptionByInstanceId(instanceId);
	}
	//保存异常信息
	public void saveException(EcExceptionVo exception) {
		exceptionDAO.saveException(exception);

	}
	//更新异常信息
	public void updateException(EcExceptionVo exception) {
		exceptionDAO.updateException(exception);

	}
	//根据activityID获取EXCEPTION信息
	public List<EcExceptionVo> getEcExceptionByActivityId(String activityId){
		return exceptionDAO.getEcExceptionByActivityId(activityId);
	}
	
	//根据人员统计
	public List<HashMap> statUserException(HashMap map){
		return exceptionDAO.statUserException(map);
	}
	//统计详细
	public List<HashMap> getDetailStat(HashMap condition){
		return exceptionDAO.getDetailStat(condition);
	}
	
	//根据部门 统计
	public List<HashMap> statOrganException(HashMap map){
		return exceptionDAO.statOrganException(map);
	}
	//查询 所有部门ID 和部门NAME
	public List<HashMap> queryOrgan() {
		return exceptionDAO.queryOrgan();
	}
	
	public List<HashMap> getActivityExceptionList(String workflowInstanceId){
		return exceptionDAO.getActivityExceptionList(workflowInstanceId);
	}

	public List<HashMap> getEcExceptionList(String workflowInstanceId,String activityId,int exceptionType,String userId) {
		HashMap<String,Object> paramsMap = new HashMap<String,Object>();
		if(workflowInstanceId != null && !"".equals(workflowInstanceId)){
			paramsMap.put("WORKFLOW_INSTANCE_ID", workflowInstanceId);
		}
		if(activityId != null && !"".equals(activityId)){
			paramsMap.put("ACTIVITY_ID", activityId);
		}
		if(exceptionType != 0 && !"".equals(exceptionType)){
			paramsMap.put("EXCEPTION_TYPE", exceptionType);
		}
		if(userId != null && !"".equals(userId)){
			paramsMap.put("USER_ID", userId);
		}
		
		return exceptionDAO.getEcExceptionList(paramsMap);
	}
	
	public void updateExceptionStatus(HashMap statusMap){
		exceptionDAO.updateExceptionStatus(statusMap);
	}
	
	public SysExceptionDAO getExceptionDAO() {
		return exceptionDAO;
	}

	public void setExceptionDAO(SysExceptionDAO exceptionDAO) {
		this.exceptionDAO = exceptionDAO;
	}
}
