package com.gtis.plat.service.impl;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.dao.SysCalendarDAO;
import com.gtis.plat.service.SysCalendarService;

import java.util.Date;
import java.util.List;

/**
 * @(#)SysCalendarServiceImpl.java 2010-12-8 10:05:31
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class SysCalendarServiceImpl implements SysCalendarService {
    private SysCalendarDAO calendarDAO;
    
    public List<Date> getWorkDateList(Date begin, Date finish) {
        return calendarDAO.getDateList(begin,finish,"工作日");
    }

    public List<Date> getHolidayList(Date begin, Date finish) {
        return calendarDAO.getDateList(begin,finish,"节假日");
    }

    public int statWorkDate(Date begin, Date finish) {
        return calendarDAO.statDate(begin,finish,"工作日");
    }
    
    public int statHoliday(Date begin, Date finish) {
        return calendarDAO.statDate(begin,finish,"节假日");
    }

    public boolean isWorkDate(Date date){
        Date d = CommonUtil.formatDate(date);
        int count = statWorkDate(d,d);
        if(count>0){
            return true;
        }else {
            return false;
        }
    }

    public boolean isHoliday(Date date){
        Date d = CommonUtil.formatDate(date);
        int count = statHoliday(d,d);
        if(count>0){
            return true;
        }else {
            return false;
        }
    }
    
    public void setCalendarDAO(SysCalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }
}
