package com.gtis.plat.service.impl;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.dao.StuffDao;
import com.gtis.plat.service.StuffService;
import com.gtis.plat.vo.PfStuffFileVo;
import com.gtis.plat.vo.PfStuffInfoVo;
import com.gtis.web.action.StuffManageAction;

/**
 * @(#)StuffServiceImpl.java 11-5-5 下午1:54
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class StuffServiceImpl implements StuffService{
    private StuffDao stuffDao;
    private NodeService nodeService;

    public PfStuffInfoVo getStuffInfo(String infoid) {
        return stuffDao.getStuffInfo(infoid);
    }

    public PfStuffInfoVo getStuffInfoByProId(String proid) {
        return stuffDao.getStuffInfoByProId(proid);
    }

    public PfStuffInfoVo getStuffInfoByProId(String proid, String taskid) {
        return null;
    }

    public PfStuffInfoVo save(PfStuffInfoVo info) {
        return stuffDao.insertStuffInfo(info);
    }

    public PfStuffFileVo save(PfStuffFileVo file) {
        if(file.getFileId() != null){
            return stuffDao.updateStuffFile(file);
        }
        return stuffDao.insertStuffFile(file);
    }

    public void delete(PfStuffFileVo file) {
        stuffDao.deleteStuffFile(file.getFileId());
    }

    public void setStuffDao(StuffDao stuffDao) {
        this.stuffDao = stuffDao;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}
